package com.upyuns.platform.rs.datacenter.rest;


import com.github.wxiaoqi.security.auth.client.annotation.IgnoreUserToken;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.rest.BaseController;
import com.github.wxiaoqi.security.common.vo.PageDataVO;
import com.upyuns.platform.rs.datacenter.biz.RscpImageDataNewestBiz;
import com.upyuns.platform.rs.datacenter.entity.RscpImageDataNewest;
import com.upyuns.platform.rs.datacenter.pojo.RscpImageDataNewestDTO;
import io.swagger.annotations.ApiModelProperty;
import org.apache.commons.lang.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import tk.mybatis.mapper.entity.Example;

import java.util.List;

@RestController
@RequestMapping("/web/DataNewest")
public class RscpImageDataNewestController extends BaseController<RscpImageDataNewestBiz, RscpImageDataNewest> {


    @ApiModelProperty("最新原始遥感影像分页")
    @IgnoreUserToken
    @RequestMapping(value = "/app/unauth/mapAll",method = RequestMethod.GET)
    public ObjectRestResponse<List<RscpImageDataNewest>> getPageList(RscpImageDataNewestDTO dto) {
        Example example = new Example(RscpImageDataNewest.class);
        Example.Criteria criteria = example.createCriteria();
        example.setOrderByClause("image_take_time DESC");
        PageDataVO pageDataVO = PageDataVO.pageInfo(dto.getPage(), dto.getLimit(), ()->baseBiz.selectByExample(example));
        return ObjectRestResponse.succ(pageDataVO);
    }

}
