package com.upyuns.platform.rs.datacenter.rest;

import cn.hutool.core.util.StrUtil;
import com.github.wxiaoqi.security.auth.client.annotation.IgnoreClientToken;
import com.github.wxiaoqi.security.auth.client.annotation.IgnoreUserToken;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.rest.BaseController;
import com.github.wxiaoqi.security.common.vo.PageDataVO;
import com.upyuns.platform.rs.datacenter.biz.RscpImageCoverBiz;
import com.upyuns.platform.rs.datacenter.entity.RscpImageCover;
import com.upyuns.platform.rs.datacenter.pojo.BgImageCoverQueryDTO;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping("/web/cover")
public class RscpImageCoverController extends BaseController<RscpImageCoverBiz, RscpImageCover> {

    @ApiOperation("查询分页")
    @RequestMapping(value = "/app/unauth/pages",method = RequestMethod.GET)
    @ResponseBody
    @IgnoreUserToken
    public ObjectRestResponse<PageDataVO<RscpImageCover>> bgPages(BgImageCoverQueryDTO dto) {
        if(StrUtil.isNotBlank(dto.getDateMonth())) {
            if(dto.getDateMonth().length() < 2) {
                dto.setDateMonth("0"+ dto.getDateMonth());
            }
        }
        return ObjectRestResponse.succ(PageDataVO.pageInfo(dto.initQuery(), () -> baseBiz.queryDataList(dto)));
    }
}