package com.upyuns.platform.rs.datacenter.rest;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.github.wxiaoqi.security.auth.client.annotation.IgnoreUserToken;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.rest.BaseController;
import com.upyuns.platform.rs.datacenter.biz.RscpAreaInfoBiz;
import com.upyuns.platform.rs.datacenter.entity.RscpAreaInfo;

import lombok.Data;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;
import java.util.stream.Collectors;

import static com.github.wxiaoqi.security.common.constant.CommonConstants.SYS_TRUE;

@RestController
@RequestMapping("/web/areaInfo")
public class RscpAreaInfoController extends BaseController<RscpAreaInfoBiz, RscpAreaInfo> {

    @RequestMapping(value = "/app/unauth/getAreaList", method = RequestMethod.GET)
    @IgnoreUserToken
    public ObjectRestResponse<List<RscpAreaInfo>> getAreaList(String parentId) {
        if(StrUtil.isBlank(parentId)) {
            parentId = "000000";
        }
        return ObjectRestResponse.succ( baseBiz.getDirectSubAreas(parentId));
    }

    @RequestMapping(value = "/app/unauth/queryAreaInfoByAreaId", method = RequestMethod.GET)
    @IgnoreUserToken
    public ObjectRestResponse<RscpAreaInfo> queryAreaInfoByAreaId(String areaCode) {
        return ObjectRestResponse.succ( baseBiz.queryAreaInfoByAreaId(areaCode));
    }

    @RequestMapping(value = "/app/unauth/Fegin/queryByCodeFegin", method = RequestMethod.GET)
    @IgnoreUserToken
    public ObjectRestResponse<RscpAreaInfo> queryByCode(String areaCode) {
        return ObjectRestResponse.succ( baseBiz.queryAreaInfoByAreaId(areaCode));
    }
}