package com.upyuns.platform.rs.datacenter.mapper;

import com.upyuns.platform.rs.datacenter.entity.RscpAreaInfo;
import com.upyuns.platform.rs.datacenter.entity.RscpImagePrice;
import org.apache.ibatis.annotations.Select;
import tk.mybatis.mapper.common.Mapper;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.Set;

public interface RscpAreaInfoMapper extends Mapper<RscpAreaInfo> {
    public RscpAreaInfo queryAreaInfoByAreaCode(String areaCode);

    public List<RscpAreaInfo> getDirectSubAreas(String parentId);

    @Select("select adminCode,proadcode,cityadcode,name,cityname,proname from rscp_area_info where st_intersects(geom, st_GeomFromText('MULTIPOLYGON(((${leftTopLon} ${leftTopLat}  ,${leftBottomLon} ${leftBottomLat}  , ${rightBottomLon} ${rightBottomLat}  ,${rightTopLon} ${rightTopLat},   ${leftTopLon} ${leftTopLat})))',4326))")
    public List<RscpAreaInfo> getIntersectAreaInfo(BigDecimal leftTopLon, BigDecimal leftTopLat, BigDecimal leftBottomLon, BigDecimal leftBottomLat, BigDecimal rightBottomLon, BigDecimal rightBottomLat, BigDecimal rightTopLon, BigDecimal rightTopLat);

    @Select(" select t1.proadcode,string_agg(t1.adminCode, ',') as admin_code_ary,"
            + " string_agg(t1.is_cover, ',') as is_cover_ary,string_agg(t1.image_area, ',') as image_area_ary "
            + " from "
            + " (select (case when proadcode is null then adminCode else proadcode end) as proadcode,adminCode, "
            + "  case(st_contains(geom, ${geomArea})) when true then '1' else '0' end  as is_cover, "
            + "  cast(cast(st_area(st_intersection(geom, ${geomArea}),true)/1000/1000 as numeric(10,3))as text) as image_area "
            + "  from rscp_area_info where admincode in (${adminCodeSetStr}) order by admincode "
            + "  ) t1 "
            + " group by t1.proadcode order by proadcode ")
    public List<Map<String, Object>> queryIntersectionArea(String geomArea, String adminCodeSetStr);
}