package com.upyuns.platform.rs.datacenter.job;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateField;
import cn.hutool.core.date.DateUtil;
import com.upyuns.platform.rs.datacenter.biz.RscpImageDataTotalBiz;
import com.upyuns.platform.rs.datacenter.biz.RscpImagePriceBiz;
import com.upyuns.platform.rs.datacenter.biz.RscpImageStatisticsBiz;
import com.upyuns.platform.rs.datacenter.entity.RscpImageDataTotal;
import com.upyuns.platform.rs.datacenter.entity.RscpImagePrice;
import com.upyuns.platform.rs.datacenter.entity.RscpImageStatistics;
import com.upyuns.platform.rs.datacenter.pojo.imagedata.BgImageQueryDTO;
import com.upyuns.platform.rs.datacenter.rest.RscpImagePriceController;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;

import java.time.LocalDateTime;
import java.util.List;
import java.util.stream.Collectors;

import static com.github.wxiaoqi.security.common.constant.CommonConstants.SYS_FALSE;
import static com.github.wxiaoqi.security.common.constant.CommonConstants.SYS_TRUE;

@Configuration      //1.主要用于标记配置类，兼备Component的效果。
@EnableScheduling   // 2.开启定时任务
@Slf4j
public class SaticScheduleTask {

    @Autowired
    RscpImagePriceBiz rscpImagePriceBiz;

    @Autowired
    RscpImageDataTotalBiz rscpImageDataTotalBiz;

    @Autowired
    RscpImageStatisticsBiz rscpImageStatisticsBiz;

    //定时统计影像数量
    @Scheduled(cron = "0 0 1 * * ?")
    //或直接指定时间间隔，例如：5秒
    //@Scheduled(fixedRate=5000)
    public void configureTasks() {
        //定时统计数据
            //查询卫星列表
        List<RscpImagePrice> list = rscpImagePriceBiz.selectByWeekend(w -> {
            w.andEqualTo(RscpImagePrice::getStatus, SYS_TRUE);
            w.andEqualTo(RscpImagePrice::getIsDel, SYS_FALSE);
            return w;
        }, " daily_sort asc");

        List<String> satelliteTypes = list.stream().map(RscpImagePrice::getImageSatelliteType).distinct().collect(Collectors.toList());

        int sort = 0;
        for(String satelliteType : satelliteTypes) {
            sort = sort+1;

            //逻辑删除已有的
            rscpImageStatisticsBiz.logicDelByWeekendSelective(w ->{
                        w.andEqualTo(RscpImageStatistics::getName, satelliteType);
                        return w;
                    }
            );

            //统计最近七天数据
            String start = DateUtil.beginOfDay(DateUtil.offsetDay(DateUtil.date(), -7)).toString();
            String end = DateUtil.endOfDay(DateUtil.offsetDay(DateUtil.date(), -1)).toString();
            Integer count7 = rscpImageDataTotalBiz.selectCountByWeekend(w-> {
                w.andGreaterThanOrEqualTo(RscpImageDataTotal::getImageTakeTime, start);
                w.andLessThanOrEqualTo(RscpImageDataTotal::getImageTakeTime, end);
                w.andEqualTo(RscpImageDataTotal::getImageSatelliteType, satelliteType);
                return w;
            });

                //添加
            insertPart(sort, satelliteType, count7, RscpImageStatistics.TYPE_SEVEN);

            //统计全部
            Integer countAll = rscpImageDataTotalBiz.selectCountByWeekend(w-> {
                w.andEqualTo(RscpImageDataTotal::getImageSatelliteType, satelliteType);
                return w;
            });

                //添加
            insertPart(sort, satelliteType, countAll, RscpImageStatistics.TYPE_ALL);

            //统计年份
                //获取最近三年
            for(int i = 0; i < 3; i++) {
                String yearStr = DateUtil.offset(DateUtil.date(), DateField.YEAR, -i).year()+"";
                yearInsert(yearStr, satelliteType, sort);
            }

        }

    }

    private void insertPart(int sort, String satelliteType, Integer countAll, int type) {
       insertPart(sort, satelliteType, countAll, type, null);
    }

    private void insertPart(int sort, String satelliteType, Integer countAll, int type, String year) {
        RscpImageStatistics rscpImageStatisticsAll = new RscpImageStatistics();
        rscpImageStatisticsAll.setName(satelliteType);
        rscpImageStatisticsAll.setNum(countAll);
        rscpImageStatisticsAll.setSort(sort);
        rscpImageStatisticsAll.setType(type);
        rscpImageStatisticsAll.setDateyear(Integer.valueOf(year));
        rscpImageStatisticsBiz.insertSelective(rscpImageStatisticsAll);
    }

    private void yearInsert(String year, String satelliteType, Integer sort) {
        Integer countYear = rscpImageDataTotalBiz.selectCountByWeekend(w-> {
            w.andEqualTo(RscpImageDataTotal::getImageSatelliteType, satelliteType);
            w.andEqualTo(RscpImageDataTotal::getImageYear, year);
            return w;
        });

        //添加
        insertPart(sort, satelliteType, countYear, RscpImageStatistics.TYPE_YEAR, year);
    }
}