package com.upyuns.platform.rs.datacenter.biz;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONUtil;
import com.github.wxiaoqi.security.common.biz.BaseBiz;
import com.github.wxiaoqi.security.common.exception.BaseException;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.upyuns.platform.rs.datacenter.entity.RscpAreaImageTotal;
import com.upyuns.platform.rs.datacenter.entity.RscpAreaInfo;
import com.upyuns.platform.rs.datacenter.entity.RscpImageDataTotal;
import com.upyuns.platform.rs.datacenter.entity.RscpImageInputLog;
import com.upyuns.platform.rs.datacenter.fegin.RscloudboxClientRest;
import com.upyuns.platform.rs.datacenter.mapper.RscpAreaInfoMapper;
import com.upyuns.platform.rs.datacenter.mapper.RscpImageDataTotalMapper;
import com.upyuns.platform.rs.datacenter.pojo.ImageTotalInputDTO;
import com.upyuns.platform.rs.datacenter.pojo.imagedata.BgImageQueryDTO;
import com.upyuns.platform.rs.datacenter.pojo.imagedata.QueryDTO;
import com.upyuns.platform.rs.datacenter.pojo.rscloudbox.ImageDataDto;
import com.upyuns.platform.rs.datacenter.rest.RscpImageDataTotalController;
import com.upyuns.platform.rs.datacenter.vo.ImageInputVO;
import com.upyuns.platform.rs.datacenter.vo.MaxMinVO;
import com.upyuns.platform.rs.gtdata.GtDataRestClient;
import lombok.extern.slf4j.Slf4j;
import org.springframework.amqp.support.AmqpHeaders;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

import static com.github.wxiaoqi.security.common.util.process.ResultCode.PARAM_ILLEGAL_CODE;
import static com.upyuns.platform.rs.datacenter.constant.DataConstant.THUMBNAIL_PATH;

@Service
@Slf4j
public class RscpImageDataTotalBiz extends BaseBiz<RscpImageDataTotalMapper, RscpImageDataTotal> {

    @Autowired
    RscpImageInputLogBiz rscpImageInputLogBiz;

    @Autowired
    RscpImageDataTotalBiz rscpImageDataTotalBiz;

    @Autowired
    RscpAreaImageTotalBiz rscpAreaImageTotalBiz;

    @Autowired
    RscpAreaInfoMapper rscpAreaInfoMapper;

    @Autowired
    RscloudboxClientRest rscloudboxClientRest;

    @Autowired
    GtDataRestClient gtDataRestClient;

    public void inStorage(ImageInputVO ii) {
        ExecutorService executorService = Executors.newCachedThreadPool();
        executorService.execute(() -> {
            ii.setThumbnailPath(ii.getThumbnailPath().replace(THUMBNAIL_PATH, ""));
            ii.setThumbnailPath(ii.getThumbnailPath().replace("//", "/"));
            ii.setImageFilePath(ii.getImageFilePath().replace("//", "/"));
            RscpImageDataTotal rscpImageDataTotal= null;
            try {
                //查询数据是否存在
                rscpImageDataTotal = rscpImageDataTotalBiz.selectOne(new RscpImageDataTotal(){{
                    setName(ii.getName());
                }});

                ImageTotalInputDTO imageTotalInputDTO = BeanUtil.toBean(ii, ImageTotalInputDTO.class);

                if(null != rscpImageDataTotal) {
                    //更新
                    BeanUtil.copyProperties(ii, rscpImageDataTotal);
//                    rscpImageDataTotal.setImageResolution(null);
                    rscpImageDataTotalBiz.updateSelectiveById(rscpImageDataTotal);
                }else {
                    rscpImageDataTotal = BeanUtil.toBean(ii, RscpImageDataTotal.class);
                    rscpImageDataTotal.setImageProductType("0101");
                    rscpImageDataTotalBiz.insertSelective(rscpImageDataTotal);
                    RscpImageDataTotal finalRscpImageDataTotal = rscpImageDataTotal;
                    rscpImageDataTotalBiz.updateSelectiveById(new RscpImageDataTotal(){{
                        setId(finalRscpImageDataTotal.getId());
                        setDataId(finalRscpImageDataTotal.getId());
                    }});
                }
                imageTotalInputDTO.setId(rscpImageDataTotal.getId());
                //更新几何范围
                updateGeom(imageTotalInputDTO);

                //更新地区信息
                rscpAreaImageTotalBiz.inStorageAreaDeal(imageTotalInputDTO);

                //插入接收系统
//                inputbox(imageTotalInputDTO.getId());

            }catch (Exception e) {
                log.error(e.getMessage(), e);
                if(null != ii.getLogId()) {
                    rscpImageInputLogBiz.updateSelectiveById(new RscpImageInputLog(){{
                        setId(ii.getLogId());
                        setStatus(STATU_FAIL);
                        setResult(e.getMessage());
                    }});
                }
                throw e;
            }finally {
                if(null != ii.getLogId()) {
                    if(null != rscpImageDataTotal) {
                        String message = rscpImageDataTotal.getId()+ "";
                        rscpImageInputLogBiz.updateSelectiveById(new RscpImageInputLog(){{
                            setId(ii.getLogId());
                            setStatus(STATU_SUCC);
                            setResult(message);
                            //setResult(JSONUtil.toJsonStr(CollUtil.newArrayList(resultDTO)));
                        }});

                    }else {
                        rscpImageInputLogBiz.updateSelectiveById(new RscpImageInputLog(){{
                            setId(ii.getLogId());
                            setStatus(STATU_FAIL);
                        }});
                    }
                }
            }
        });
    }

    public List<RscpImageDataTotal> queryDataList(QueryDTO dto) {
        return mapper.queryDataList(dto);
    }

    public List<RscpImageDataTotal> bgQueryDataList(BgImageQueryDTO dto) {
        return mapper.bgQueryDataList(dto);
    }


    public RscpImageDataTotal queryDataList(Long id) {
        List<RscpImageDataTotal> list2 = mapper.queryDataById(id);
        if(list2.size() > 0) {
//            RscpImageDataTotal rscpImageDataTotal = list2.get(0);
            return list2.get(0);
        }
        throw new BaseException("数据不存在", PARAM_ILLEGAL_CODE);
    }

    public List<RscpAreaImageTotal> queryDataAreaList(QueryDTO dto) {
        List<RscpImageDataTotal> list = mapper.queryDataList(dto);
        List<RscpAreaImageTotal> list2 = CollUtil.newArrayList();
        if(CollUtil.isNotEmpty(list)) {
//            for(RscpImageDataTotal ridt : list) {
//                RscpAreaImageTotal rait = BeanUtil.toBean(ridt, RscpAreaImageTotal.class);
//                rait.setBeginTime(ridt.getImageTakeTime());
//                rait.setImageResolution(rait.getImageResolution().replace("[","{").replace("]", "}"));
//                list2.add(rait);
//            }
            list2 = Convert.toList(RscpAreaImageTotal.class, list);
        }
        return list2;
    }

    public String getBinNameByGId(ImageTotalInputDTO dto){
//        String param = StrUtil.format("MULTIPOLYGON((({} {}  ,{} {}  , {} {}  ,#{rightTopLon} #{rightTopLat},   #{leftTopLon} #{leftTopLat})))");
        return mapper.getBinNameByGId(dto.getLeftTopLon(), dto.getLeftTopLat(), dto.getLeftBottomLon(), dto.getLeftBottomLat(), dto.getRightBottomLon(), dto.getRightBottomLat(), dto.getRightTopLon(), dto.getRightTopLat());
    }

    public Integer updateGeom(ImageTotalInputDTO dto){
        return mapper.updateGeom(dto.getLeftTopLon(), dto.getLeftTopLat(), dto.getLeftBottomLon(), dto.getLeftBottomLat(), dto.getRightBottomLon(), dto.getRightBottomLat(), dto.getRightTopLon(), dto.getRightTopLat(), dto.getId());
    }

    public MaxMinVO coverStatisticsMaxMin() {
        return mapper.coverStatisticsMaxMin();
    }

    public String geoJsonByRange(String rangeMeta){
        return mapper.geoJsonByRange(rangeMeta);
    }

    public void aaa(ImageInputVO vo) {
        ImageTotalInputDTO dto = BeanUtil.toBean(vo, ImageTotalInputDTO.class);
//        dto.setRange(getBinNameByGId(dto));
        List<RscpAreaInfo> imageAreaInfoList = rscpAreaInfoMapper.getIntersectAreaInfo(dto.getLeftTopLon(), dto.getLeftTopLat(), dto.getLeftBottomLon(), dto.getLeftBottomLat(), dto.getRightBottomLon(), dto.getRightBottomLat(), dto.getRightTopLon(), dto.getRightTopLat());
    }

    public String queryGeomsJson(QueryDTO dto){
        return mapper.queryGeomsJson(dto);
    }

    public Map<String, Object>  inputbox(Long dataid) {
        RscpImageDataTotal rscpImageDataTotal = queryDataList(dataid);
        ImageDataDto imageDataDto = new ImageDataDto();
        imageDataDto.setId(rscpImageDataTotal.getId().toString());
//        imageDataDto.setAreaDescription(null);
//        imageDataDto.setAreaNo(null);
//        imageDataDto.setAreaNoArray(null);
//        imageDataDto.setAutoTag(null);
        imageDataDto.setImageTakeTime(rscpImageDataTotal.getImageTakeTime());
        imageDataDto.setImageEndTime(rscpImageDataTotal.getImageEndTime());
        imageDataDto.setImageStartTime(rscpImageDataTotal.getImageStartTime());
        imageDataDto.setImageProductTime(rscpImageDataTotal.getImageProductTime());
//        imageDataDto.setDataId(rscpImageDataTotal.getId().toString());
//        imageDataDto.setGemo(null);
        imageDataDto.setImageArea(StrUtil.isNotBlank(rscpImageDataTotal.getImageArea()) ? rscpImageDataTotal.getImageArea() : null);
        imageDataDto.setImageCity(rscpImageDataTotal.getImageCity());
        imageDataDto.setImageCloudage(null != rscpImageDataTotal.getImageCloudage() ? rscpImageDataTotal.getImageCloudage().doubleValue() : null);
//        Double resolution = (rscpImageDataTotal.getImageResolution() == null || rscpImageDataTotal.getImageResolution().length <= 0)?
//                null: rscpImageDataTotal.getImageResolution()[0].doubleValue();
//        rscmAreaImageDto.setImageEndResolution(resolution);

        if((rscpImageDataTotal.getImageResolution() == null || rscpImageDataTotal.getImageResolution().length <= 0)) {
            imageDataDto.setImageResolution("");
        }else {
            String resolutionStr = "{";
            for(int i = 0; i < rscpImageDataTotal.getImageResolution().length; i++) {
                BigDecimal resolution = rscpImageDataTotal.getImageResolution()[i];
                resolutionStr += resolution;
                if(i == rscpImageDataTotal.getImageResolution().length - 1) {
                    resolutionStr += "}";
                }else {
                    resolutionStr += ",";
                }
//                if(i = 0) {
//                    rscmAreaImageDto.setImageStartResolution();
//                }
            }
            imageDataDto.setImageResolution(resolutionStr);
        }

        imageDataDto.setImageIsSave(1);
        imageDataDto.setImageProductType(rscpImageDataTotal.getImageProductType());
        imageDataDto.setImageProjection(rscpImageDataTotal.getImageProjection());
        imageDataDto.setImageRowCol(rscpImageDataTotal.getImageRowCol());
        imageDataDto.setImageSatelliteType(rscpImageDataTotal.getImageSatelliteType());
        imageDataDto.setImageSensorType(rscpImageDataTotal.getImageSensorType());
//        imageDataDto.setImageSize(null);
//        rscmAreaImageDto.setImageSpectrumType(null != rscpImageDataTotal.getImageSpectrumType() ? rscpImageDataTotal.getImageSpectrumType().toString() : null);
        if(null == rscpImageDataTotal.getImageSpectrumType() || rscpImageDataTotal.getImageSpectrumType().length <= 0) {
            imageDataDto.setImageSpectrumType("");
        }else {
            String spectrumTypeStr = "{";
            for(int i = 0; i < rscpImageDataTotal.getImageSpectrumType().length; i++) {
                String pectrumType = rscpImageDataTotal.getImageSpectrumType()[i];
                spectrumTypeStr += pectrumType;
                if(i == rscpImageDataTotal.getImageSpectrumType().length - 1) {
                    spectrumTypeStr += "}";
                }else {
                    spectrumTypeStr += ",";
                }
            }
            imageDataDto.setImageSpectrumType(spectrumTypeStr);
        }

        if(null == rscpImageDataTotal.getImageSpectrumTypeDisplay() || rscpImageDataTotal.getImageSpectrumTypeDisplay().length <= 0) {
            imageDataDto.setImageSpectrumTypeDisplay("");
        }else {
            String spectrumTypeStr = "{";
            for(int i = 0; i < rscpImageDataTotal.getImageSpectrumTypeDisplay().length; i++) {
                String pectrumType = rscpImageDataTotal.getImageSpectrumTypeDisplay()[i];
                spectrumTypeStr += pectrumType;
                if(i == rscpImageDataTotal.getImageSpectrumTypeDisplay().length - 1) {
                    spectrumTypeStr += "}";
                }else {
                    spectrumTypeStr += ",";
                }
            }
            imageDataDto.setImageSpectrumTypeDisplay(spectrumTypeStr);
        }

//        imageDataDto.setImgUrl(null);
        imageDataDto.setCorrectStatus(rscpImageDataTotal.getCorrectStatus());
//        imageDataDto.setIsCover(null);
//        imageDataDto.setJobid(null);
        imageDataDto.setName(rscpImageDataTotal.getName());
//        imageDataDto.setNum(null);
        imageDataDto.setImageProductId(rscpImageDataTotal.getImageProductId());
        imageDataDto.setImageProductLevel(rscpImageDataTotal.getImageProductLevel());
        imageDataDto.setRange(rscpImageDataTotal.getRange());
//        imageDataDto.setRecordId(null);
//        imageDataDto.setRelationNo(null);
        imageDataDto.setImageSensorId(rscpImageDataTotal.getImageSensorId());
//        imageDataDto.setSrid(null);
//        imageDataDto.setTip(null);
//        rscmAreaImageDto.setUpdateTime(rscpImageDataTotal.getCreateDt());

        imageDataDto.setImageSceneId(rscpImageDataTotal.getImageSceneId());

        //复制到zmp目录
        String sourcePath = rscpImageDataTotal.getImageFilePath();
        Integer index = rscpImageDataTotal.getImageFilePath().lastIndexOf(rscpImageDataTotal.getName()+".tar.gz");
        if(index > 0) {
            sourcePath = rscpImageDataTotal.getImageFilePath().substring(0, index);
        }

        if(sourcePath.startsWith("/")) {
            sourcePath = sourcePath.substring(1);
        }

        String targetPath = sourcePath;
        targetPath = targetPath.replaceAll("rscloudmart", "zmp");
        Map<String, Object> copy0Map = gtDataRestClient.mkdirs(targetPath);
        Boolean sign = false;
        if (200 == (Integer) copy0Map.get("HttpStatusCode") ) {
            sign = true;
        }else if(2002 == (Integer) ((Map<String, Object>) copy0Map.get("GTDataException")).get("errorCode")) {
            sign = true;
        }else {
            log.warn(MessageFormat
                    .format("mkdir ({0}) ... Fail!Code: {1} Message: {2}",
                            targetPath,
                            copy0Map.get("result"),
                            copy0Map.get("message")));
            copy0Map.put("targetPath", targetPath);
//            return copy0Map;
        }
        if(sign) {
            String sourceFile = sourcePath + rscpImageDataTotal.getName()+".tar.gz";
            String targetFile = targetPath + rscpImageDataTotal.getName()+".tar.gz";
            Map<String, Object> copyMap = gtDataRestClient.copy(sourceFile, targetFile);
            if (200 != (Integer) copyMap.get("HttpStatusCode") && 2002 != (Integer) ((Map<String, Object>) copy0Map.get("GTDataException")).get("errorCode")) {
                log.warn(MessageFormat.format("Copy data file({0}) to {1}... Fail!Code: {2} Message: {3}",
                                sourcePath,
                                targetPath,
                                copyMap.get("result"),
                                copyMap.get("message")));
                copyMap.put("sourcePath", sourcePath);
                copyMap.put("targetPath", targetPath);
//                return copyMap;
            }else {
                //复制压缩图
                String sourceTPath = rscpImageDataTotal.getThumbnailPath();
                sourceTPath = THUMBNAIL_PATH + sourceTPath + "_800_800.png";
                String targetTPath = targetPath + rscpImageDataTotal.getName()+ "_800_800.png";
                Map<String, Object> copy2Map = gtDataRestClient.copy(sourceTPath, targetTPath);
                if (200 != (Integer) copyMap.get("HttpStatusCode") ) {
                    log.warn(MessageFormat
                            .format("Copy data file({0}) to {1}... Fail!Code: {2} Message: {3}",
                                    sourcePath,
                                    targetPath,
                                    copyMap.get("result"),
                                    copyMap.get("message")));
                    copyMap.put("sourceTPath", sourcePath);
                    copyMap.put("targetTPath", targetPath);
//                    return copy2Map;
                }
            }
        }
        imageDataDto.setImageFilePath(targetPath);
        imageDataDto.setThumbnailPath(rscpImageDataTotal.getThumbnailPath());

        return
//                CollUtil.newHashMap();
                rscloudboxClientRest.saveImage(imageDataDto);
    }

    public void updateImageAreaByRange(Long id){
        mapper.updateImageAreaByRange(id);
    }

    public static void main(String[] args) {
        String name = "GF6_PMS_E126.5_N46.8_20230903_L1A1420349421";
        String path = "/rscloudmart/data/GF6//GF6_PMS_E126.5_N46.8_20230903_L1A1420349421//GF6_PMS_E126.5_N46.8_20230903_L1A1420349421.tar.gz";
        Integer index = path.lastIndexOf(name+".tar.gz");
        if(path.lastIndexOf(name+".tar.gz") > 0) {
            String sourcePath = path.substring(0, index);
            System.out.println(sourcePath);
        }
    }

//    public ObjectRestResponse deleteByIdstute(Integer id) {
//        RscpImageDataTotal rscpImageDataTotal = mapper.selectByPrimaryKey(id);
//        if (rscpImageDataTotal != null) {
//            int currentState = rscpImageDataTotal.getStatus();
//            if (currentState == 0) {
//                rscpImageDataTotal.setStatus(1);
//            } else if (currentState == 1) {
//                rscpImageDataTotal.setStatus(0);
//            }
//         //   mapper.updateByPrimaryKeySelective(rscpImageDataTotal);
//            mapper.updateByPrimaryKey(rscpImageDataTotal);
//        }
//        return ObjectRestResponse.succ(rscpImageDataTotal);
//    }
    }

//    public static void main(String[] args) {
//        String a = "{\"type\":\"MultiPolygon\",\"coordinates\":[[[[127.356594042708778,47.644835444097517],[127.357065068039759,47.644778005960397],[127.357380289567914,47.644951051887936],[127.357570695577238,47.645238711845799],[127.358978060081768,47.646780658972837],[127.359254486067684,47.646769364835279],[127.359454179758714,47.646738285065197],[127.359655729369152,47.646643455794319],[127.360102305253093,47.646098008032027],[127.360528061781963,47.645698580298074],[127.360756877057909,47.645615370946679],[127.360937610008207,47.645666563030083],[127.361218904863051,47.646109779819206],[127.361555684161345,47.646473166703032],[127.362000308006174,47.646611863953268],[127.362226258554628,47.646555900818818],[127.362919866650117,47.64634397918838],[127.363133107834003,47.645978137910397],[127.363116162014478,47.645564964978782],[127.362909624957567,47.644952613949179],[127.362767286900777,47.644621336092136],[127.363237354627771,47.644381836937342],[127.364858933191556,47.644108606280291],[127.365159382823094,47.643729183124748],[127.365381690703117,47.643299556049442],[127.365392596250686,47.642424663880611],[127.365544635214178,47.641423851778725],[127.365895946558837,47.640288066150042],[127.366953489125422,47.639250221952331],[127.367342349150647,47.639314413838513],[127.367829335747686,47.63948806619586],[127.369894188886661,47.639894184907256],[127.372387828572059,47.639485045249252],[127.373817231445443,47.639096091011936],[127.375115155097191,47.638498907178601],[127.376231391787726,47.638179498160092],[127.376969680288838,47.637918954775145],[127.378105897307933,47.637658787192841],[127.379396537419339,47.637312179762603],[127.380210543119134,47.637185355706166],[127.382077783963638,47.63691520595944],[127.382992330008307,47.63681428094084],[127.383911141253932,47.636816638017066],[127.383147825689079,47.63618712176374],[127.38250801410264,47.635288874994856],[127.382548555071466,47.635137025960972],[127.382524288880674,47.634974482707783],[127.382498156889028,47.634625117724212],[127.382453888810204,47.634403320035545],[127.382258142316473,47.633914063224061],[127.38187891043448,47.633515768764774],[127.381390613195492,47.632884986899356],[127.381007128688879,47.632383408276866],[127.381103950008523,47.632035676800875],[127.381379990617262,47.631493700872056],[127.381456811845382,47.631086717768966],[127.381426902438022,47.630972101174763],[127.381352550678614,47.630687163756654],[127.381004812832117,47.630200808882051],[127.380824282002706,47.629937879828802],[127.380910171723642,47.629467117799273],[127.381145978587384,47.627808764134954],[127.378660403976667,47.626699208722457],[127.377602281996758,47.626296532255488],[127.377530761727044,47.626351211178061],[127.377492660582632,47.626380136846208],[127.376871277934313,47.627157471932399],[127.370903116426703,47.627388483975601],[127.370807997414516,47.627453152973722],[127.369561680179217,47.62830049307999],[127.369196814155202,47.62854855192635],[127.358774677908187,47.625833671074396],[127.358357673665026,47.625828068965717],[127.357414806434392,47.625577195232054],[127.355294522750782,47.626214866731623],[127.352044471951757,47.626212520074922],[127.35201596661112,47.626174397787054],[127.351481090826354,47.625459104036409],[127.351123841617678,47.62516424480684],[127.348943346555458,47.624662464939924],[127.348836255695502,47.62487989086015],[127.347335593962214,47.627926503726052],[127.34666932788906,47.627699541868061],[127.346574490049548,47.627668051783694],[127.346575640791428,47.627723987929464],[127.346579170272165,47.628097625778032],[127.346472142294317,47.6286630987655],[127.346425116387465,47.628911543953137],[127.346546008065175,47.629724267122995],[127.346603184036383,47.630983459870812],[127.34645891011013,47.631463251891574],[127.345683083708309,47.631521581245266],[127.344993862086312,47.633562126898994],[127.346647854560501,47.63365823116763],[127.34646756088631,47.6351206972029],[127.346114579573566,47.636797134933119],[127.345420033636913,47.638277246991429],[127.344635781935978,47.639854466805552],[127.343709256857025,47.641100401767581],[127.343246860742596,47.641816782743419],[127.342928080987605,47.642323724083951],[127.341879228723144,47.643297624745642],[127.342302228322467,47.643378352699507],[127.343383296867941,47.643606817041203],[127.344019271749772,47.64376172691933],[127.344310928671348,47.643795685718779],[127.34461087255147,47.643923537746794],[127.345901290778997,47.644357385958386],[127.346603323275261,47.644708246726822],[127.347113960716996,47.645184061762372],[127.347633215697371,47.646308973234362],[127.347705177039771,47.646868895019281],[127.347834579356487,47.646975680056492],[127.348591188099476,47.647349778186744],[127.349426912367903,47.647473601868718],[127.350365281733843,47.647486262969508],[127.351324486624577,47.647352899139719],[127.352334152579772,47.646815061837643],[127.353534696159755,47.64635856993813],[127.354018255683926,47.646061223827765],[127.354501810716528,47.645763877235147],[127.355032962984438,47.64553844473987],[127.355338513250231,47.645475033958867],[127.355804952681737,47.645196210197781],[127.356594042708778,47.644835444097517]]],[[[127.30746261872342,47.633353945072294],[127.3080201069005,47.633171825852173],[127.309614661445607,47.633229946268678],[127.311274135439618,47.633564613060948],[127.312034003270469,47.633733237157898],[127.312570863433677,47.633573411785058],[127.313783538761598,47.632830866291343],[127.314176065709844,47.632827223259227],[127.314538834167635,47.633153065990989],[127.315256784810742,47.634283679137006],[127.315277299636847,47.634294000167614],[127.315663084728882,47.634488101145529],[127.316478713684376,47.634571601832768],[127.317637988660223,47.634506164995784],[127.318339044687733,47.634416357797598],[127.318763690898976,47.634675252162083],[127.31934042009118,47.635636704072411],[127.320054537622852,47.636003505778199],[127.321811100634491,47.63620832722625],[127.322263219123712,47.636214515984925],[127.322631311896231,47.636138206070136],[127.322967987888347,47.635550798922601],[127.323506122760975,47.63422500479588],[127.323670191064451,47.633626202282734],[127.32354252429289,47.632996294065485],[127.323632520213025,47.632428114781206],[127.3239111650377,47.63200260871966],[127.323975850026358,47.63094150417826],[127.324411865315838,47.630816411178458],[127.324935739433329,47.630868761929435],[127.325636042672656,47.631027461703404],[127.326660914410652,47.631231262017444],[127.327880566953368,47.631595882019148],[127.328619148305194,47.63203527604918],[127.328932372878484,47.632464344994865],[127.329425000895469,47.632674425135306],[127.329920587064649,47.632559164894381],[127.330256495895512,47.63222029226003],[127.33055028362098,47.631505758053166],[127.331044961593435,47.630970205737924],[127.331281434108817,47.630169032140522],[127.331317906607637,47.629609163831553],[127.331050435028402,47.628981889118542],[127.330837314218826,47.628766588879628],[127.330188894077054,47.628427861772373],[127.329903984401568,47.628166393129774],[127.329662564863952,47.627783503225409],[127.329329437217169,47.627128219161136],[127.328851156193636,47.626208854785908],[127.328574642172796,47.625888753096334],[127.327758226293113,47.625385040952978],[127.327079286787907,47.624955508236731],[127.32573906506272,47.624399445057982],[127.324858581336969,47.624039450800325],[127.324469088897729,47.623717799164361],[127.321250824086732,47.620338792256909],[127.320377251100481,47.619748408257578],[127.320027464196869,47.619555608271924],[127.318754643067393,47.618854024915464],[127.318033050654208,47.618297345201327],[127.317299987653087,47.617455817742865],[127.317024302777241,47.616887178854917],[127.316572911923402,47.615294872896214],[127.316358337639642,47.614907827800018],[127.315456555756853,47.613481063140526],[127.315301543369799,47.613103875040224],[127.315193061917753,47.612279969144048],[127.315032686588367,47.611636103142601],[127.314779194591608,47.611216896296014],[127.314584509906609,47.611056065194006],[127.314552426576256,47.610793538258442],[127.314597421392207,47.610175088720922],[127.314559228619544,47.609894403859506],[127.314449273930492,47.609567545240211],[127.314495062857134,47.609369350937421],[127.315076713918771,47.608591089990639],[127.315011801656382,47.608314557979952],[127.314992678320579,47.607839832281719],[127.315343782154457,47.607212040753232],[127.316000189217391,47.606154653834068],[127.316587164593685,47.605643069224072],[127.316961942628538,47.605336428099797],[127.317186350769646,47.605167800214176],[127.317380212597854,47.60490837992954],[127.318120630106165,47.604602234792459],[127.319032731834952,47.603887247946297],[127.319708202046584,47.603304572253812],[127.3200920656422,47.602690787129305],[127.320249251952305,47.602322417864947],[127.320194266972038,47.602158996042192],[127.320221706012461,47.601906330902629],[127.320644489117726,47.601324710723162],[127.320584116940736,47.600894621744622],[127.320562678646453,47.600496697158363],[127.320777841326731,47.599966458076992],[127.321113636071459,47.599627649155565],[127.321535678965006,47.599294541123037],[127.321706625668668,47.599134214896758],[127.322052230016311,47.59823976609875],[127.32248192925104,47.59809653780227],[127.322971164331136,47.59796315997918],[127.32356412697888,47.59746972213771],[127.324083048684201,47.597006898942283],[127.325957358371653,47.595893871713088],[127.327625678974599,47.594826583872219],[127.327787712593988,47.59476595576983],[127.328332573153148,47.594425029823391],[127.32913506784088,47.593659733790723],[127.329589627052769,47.592980567207988],[127.330140162269601,47.59244659823311],[127.331218999399894,47.591942551791931],[127.331893575787802,47.591357259136416],[127.333591354843847,47.590452683954517],[127.334556884772439,47.589822117970485],[127.334786965774626,47.589386015195707],[127.334955366652707,47.588206922714761],[127.335404148798986,47.587720785799206],[127.336936206651416,47.586954032113006],[127.338761636309414,47.585869402257572],[127.33979663295888,47.58495577808327],[127.339928236148054,47.584647077993012],[127.340557356884247,47.5842769711603],[127.341037353689998,47.583673871289015],[127.341967392080093,47.582728525012321],[127.342368089205792,47.582169784734653],[127.342595671094855,47.582006270276693],[127.343795331630901,47.581931651195355],[127.344396659390526,47.582318431925778],[127.345526240554619,47.582735080028471],[127.346432552641431,47.582978311870846],[127.346837292185938,47.582851263281036],[127.347564246643088,47.582561969278991],[127.347893992132768,47.582142351890475],[127.348161715240252,47.581748400895584],[127.348506308983247,47.581582672194514],[127.349136716106884,47.581356435064592],[127.349469691039985,47.581016373718846],[127.349563486833731,47.580665508929037],[127.349453653417214,47.579849962882044],[127.34929802837911,47.579457867702352],[127.349317679924241,47.579166584916159],[127.349580259278397,47.57875742319694],[127.350228920168647,47.578096004161708],[127.350233192556175,47.577759081288754],[127.350543765302675,47.577422505908295],[127.352166651813519,47.577345961096853],[127.352380187644755,47.577280687758645],[127.352433826050373,47.577160250139926],[127.352537347005438,47.577048058111721],[127.352706123379292,47.576989752825405],[127.3525378518586,47.576839819107512],[127.352063286267025,47.576689538930879],[127.351593503306063,47.576625453153575],[127.35140216304886,47.576576061158669],[127.351319480313464,47.576460263945471],[127.351231623282075,47.576285885883635],[127.351361611300348,47.576196362883977],[127.351606273756147,47.576187961743322],[127.351665933569123,47.576148978808888],[127.351452419297473,47.576033756970105],[127.351401731857521,47.575883284191242],[127.351495394700606,47.575858804197146],[127.351633722677988,47.575837265792572],[127.351708377169643,47.575756357161119],[127.351815872271516,47.57572972271695],[127.35230836284623,47.575722323247803],[127.352522189731673,47.57570882300157],[127.352726514237943,47.575667110812276],[127.352824815981194,47.575483542241599],[127.352777295102655,47.575342475155175],[127.352698626938235,47.575325030821453],[127.352587966173402,47.57534226183558],[127.352559451849601,47.57525762115862],[127.352600104209515,47.575162211911596],[127.35263441715837,47.575047993296955],[127.352619516802804,47.574614812730914],[127.35269416680292,47.574533905240763],[127.352885815182219,47.574454573914487],[127.352972290604754,47.574322333963053],[127.352927938084264,47.574190674259142],[127.352711259946091,47.574066049094476],[127.352035789734543,47.574092045016819],[127.351847940330501,47.573923340068738],[127.351404555262448,47.573428210143256],[127.351327366623394,47.573242274993298],[127.351514153320394,47.57297564928087],[127.351441292764349,47.572759346930397],[127.351239930901855,47.572464077825515],[127.351173091753154,47.572395303884726],[127.351287231693149,47.57225875996911],[127.351550358121287,47.5720891212382],[127.351602832310334,47.571942383186716],[127.351465989248155,47.571795431996073],[127.35127667020032,47.57179521684381],[127.350884831361597,47.571539506884918],[127.350746512367394,47.5715610428148],[127.350608191576598,47.571582579947936],[127.350469870785787,47.571604115860104],[127.350398706248995,47.571565710123686],[127.350129035593909,47.57137015370629],[127.350148359254021,47.571297863132457],[127.350282666372124,47.571177976003717],[127.350441469649738,47.571044376845066],[127.350429962230919,47.570966988754563],[127.350418453015521,47.570889599943627],[127.350544102170929,47.570830445963459],[127.350751577967301,47.570798141008595],[127.350847555768837,47.57069411797314],[127.350815880273657,47.570600074992861],[127.350881026996362,47.570490956268905],[127.350863180166641,47.570394758919733],[127.350739330336722,47.570156708797875],[127.350708814566531,47.570022893086637],[127.350834778132253,47.569835023949558],[127.350947938010307,47.569659057089261],[127.351065334343176,47.569426300850587],[127.351170421061767,47.569350772280373],[127.351127816662753,47.569224282167227],[127.351221939443292,47.569083900076045],[127.351190301677335,47.56902226512905],[127.351250180679187,47.568909401081079],[127.351396610562119,47.56882743501609],[127.351795184968836,47.568654437079907],[127.351818456724558,47.568562063879334],[127.351592420836184,47.568375390796781],[127.351157392795201,47.567858870989255],[127.351149027683306,47.56770486594943],[127.351179638674921,47.567537393864484],[127.351104529635663,47.567378988706189],[127.351129774091774,47.567131002143114],[127.351106105280707,47.567060730150153],[127.351031631350352,47.566968788725788],[127.350899879040924,47.56690055671266],[127.350838973264644,47.566784313819305],[127.350798579619564,47.566406031976044],[127.35090042791154,47.566353194216099],[127.351146730691113,47.566374006746585],[127.3512586787418,47.566415740279034],[127.351389166223314,47.566351047925345],[127.351441077168644,47.566246820884324],[127.351342300216686,47.566018146917074],[127.351287863208768,47.565856524062021],[127.35130813818472,47.565690663836953],[127.351470495197603,47.565591426999049],[127.351669295064923,47.565212875295067],[127.351652962794745,47.565067507251541],[127.351607992233255,47.564933993125379],[127.351327062992837,47.564778059222093],[127.351072166929228,47.564699421700347],[127.350844805127466,47.564734825996069],[127.350630143707193,47.564775646769654],[127.350526797923649,47.564791739280281],[127.350436151623256,47.564813250102233],[127.350312767120656,47.564899022962223],[127.350170449725169,47.564928579064571],[127.349583975608738,47.564931149713097],[127.349438661433453,47.564887215912599],[127.349352987308222,47.564826601015419],[127.349370030145749,47.564683432205975],[127.349367271419538,47.564513764088794],[127.349259432262883,47.564419622119722],[127.349107646624319,47.564421068994932],[127.348976531220373,47.564419297830582],[127.348877289839379,47.564382982280549],[127.348949871019386,47.564275538124377],[127.349107733760903,47.564066069969009],[127.349016460436431,47.564021117712862],[127.348825704084177,47.564036027851934],[127.348676917022004,47.564110963996093],[127.348542565886433,47.564131882281622],[127.348418550766468,47.564151191227751],[127.348288065081547,47.56421588023688],[127.348046894377276,47.564371757017206],[127.347789396792678,47.564382267025429],[127.347424688872152,47.56436509423223],[127.347388325069431,47.564289405007791],[127.347529001242904,47.563964289059001],[127.347778863147639,47.563511240288761],[127.347684206767809,47.563230157178886],[127.347579606936122,47.563113324223629],[127.347200949975871,47.562957811034558],[127.346281668013006,47.56290865103923],[127.346091158697448,47.562827378736706],[127.346039103123388,47.56267278304361],[127.34617678790697,47.562274182302275],[127.346152987043538,47.561945094300995],[127.34622817872777,47.561748502979249],[127.346318195309124,47.561660534832733],[127.346593984389571,47.561639782866052],[127.346748997674979,47.56161564901069],[127.347001123334195,47.561524626698954],[127.347164348119648,47.561395677799666],[127.347123252890313,47.561305935972491],[127.346790917557712,47.561061863297006],[127.346689171673674,47.560759701935474],[127.346309903859066,47.560537727906329],[127.345961177865746,47.560378201943045],[127.345702848441178,47.560323286733322],[127.345573106561318,47.560234762130186],[127.345576304563707,47.560125538762513],[127.345460170363822,47.559980785230159],[127.34537554636907,47.559926343046058],[127.345374276151304,47.55979130879949],[127.3455101175919,47.559702543241215],[127.345651651656539,47.559597865292474],[127.345646206967601,47.559516071973512],[127.345714251655394,47.559422835181493],[127.345740303696957,47.559336136770348],[127.34553475658349,47.559217880240944],[127.34539524013509,47.559164470850043],[127.345232957682384,47.559174709715265],[127.345019954552086,47.559132741873],[127.344947599747542,47.55901628714831],[127.34485891806267,47.558654446737002],[127.344685503686989,47.55859880286831],[127.344487807849106,47.558569477800127],[127.344366000788199,47.558535849794147],[127.344310472327223,47.558469366037684],[127.344364732366955,47.55840081620731],[127.344314009892798,47.558348608720443],[127.344273785131037,47.558294769240476],[127.344362941126292,47.557837629137126],[127.344170303701844,47.557724874965125],[127.343678662933399,47.55774130973407],[127.342199314628516,47.557941549186744],[127.342052340366621,47.557964426216337],[127.341916747759313,47.557955482006413],[127.341760162422133,47.557949804123687],[127.341643418266074,47.557832747214],[127.341574612705273,47.557595532971845],[127.34174485962123,47.55731359728594],[127.342075865447256,47.556984099228281],[127.342077886656654,47.556826016198301],[127.342013633757588,47.556700785912511],[127.341899296188231,47.556590867096801],[127.341764593811419,47.556551733777276],[127.341646712388226,47.556562570298411],[127.341467616168373,47.556522833749597],[127.341320012187424,47.556478195115396],[127.341115746071566,47.556494966132142],[127.340813076702915,47.5564819768395],[127.340720997589642,47.556503822080408],[127.34061905317796,47.55659481795329],[127.340524571071313,47.556609525297439],[127.340430975601862,47.556594041968005],[127.340285861750885,47.556635438948838],[127.340199133901777,47.556660180123565],[127.340136145830698,47.556669982987138],[127.3400521623348,47.55668305589392],[127.34003053359767,47.556618808018051],[127.34004128822825,47.55651946790865],[127.340410998866545,47.556206488012698],[127.340377450383954,47.556106819143508],[127.340326044291828,47.55610133930228],[127.34006418987812,47.55612541022343],[127.339798966782013,47.556066560878691],[127.33935982984697,47.556001402878863],[127.338778805809397,47.556025082817854],[127.338684129666646,47.555889622025049],[127.338508818947403,47.555733335038518],[127.338162965766372,47.555653655134563],[127.338107622358308,47.555562138070563],[127.33824614257513,47.555390384003509],[127.338192770070862,47.555231806918123],[127.337820233332636,47.55507283892392],[127.337594346564558,47.555057929265082],[127.337246525174734,47.555045308220116],[127.336877356220555,47.554969255720081],[127.336552855993844,47.554953004990203],[127.33645284924819,47.55480168593003],[127.336234852383228,47.554518534205187],[127.335978339352181,47.554558454152534],[127.33576196484465,47.55500933476965],[127.335660793882411,47.555292092202642],[127.333415160182341,47.556434867741089],[127.333882656930953,47.557337160841989],[127.33386848960059,47.55814725780251],[127.333387502851366,47.560005044109424],[127.332513213009562,47.563372688036708],[127.331334007112488,47.563277563248178],[127.331158467322808,47.563973483796694],[127.33076713603225,47.564758697166404],[127.33068266385277,47.56499470973003],[127.330819585068383,47.565279857225548],[127.330608401026609,47.565869889862583],[127.330399517570186,47.56671030098574],[127.331210550744643,47.566807002727082],[127.333715919732754,47.566946547203706],[127.334461296839692,47.566969870041149],[127.335065457885719,47.567182318979597],[127.335301388716999,47.567396344163718],[127.336049094257234,47.567670034010966],[127.336667514261791,47.567881229708881],[127.33711390599106,47.568033674719061],[127.337664619972642,47.568087276295095],[127.338015035696955,47.568032744952184],[127.33835325229974,47.568063692117541],[127.338885726887796,47.568100211797706],[127.339465810389214,47.56824049227567],[127.339878959063157,47.568604373281318],[127.33836000403744,47.578194964004012],[127.33790736093205,47.580028301190282],[127.337589696884649,47.580672307193382],[127.337225047354607,47.580960270050028],[127.335381902919323,47.580536842868881],[127.334303918290146,47.580076939135829],[127.333667308299425,47.579845658075257],[127.333091349861732,47.579505842031004],[127.332948764768318,47.579435607245038],[127.33268364318188,47.579305011765562],[127.331592588963645,47.579094869270513],[127.330948759212987,47.578914248085113],[127.330360298921491,47.578609402783719],[127.329759323301502,47.57833953509973],[127.328659691070598,47.578031615292616],[127.328228921942383,47.577834363213391],[127.327418840982105,47.577448371086923],[127.326728870165212,47.577274913798576],[127.326191894119304,47.576978567836008],[127.325495289244031,47.576779270765044],[127.325331740166803,47.576732479284807],[127.324516408553635,47.576330777921221],[127.32418266915424,47.576349646043198],[127.323517764927018,47.576106219174235],[127.322568438809526,47.578483405277304],[127.321451030715764,47.578194713730745],[127.320014376641481,47.577823526850331],[127.318030945003144,47.577487786947664],[127.317778274964894,47.577097673275858],[127.317625900031416,47.577005754925025],[127.317098888098641,47.576955559729008],[127.31673086359811,47.577161403964951],[127.315955248300341,47.577744393213848],[127.315120920013925,47.578369533865683],[127.315128861120996,47.578682086849007],[127.315310931662779,47.578934544177017],[127.315693525040587,47.579205377751116],[127.315741028851164,47.579346630766508],[127.315787894857863,47.57970268120652],[127.315900713376067,47.579965905302636],[127.31618963672426,47.580102663024931],[127.31625294639224,47.580437668700384],[127.315610756066974,47.581896557861263],[127.315339381307851,47.582278505863499],[127.314129782709813,47.582149391734198],[127.313834858615451,47.582263182211953],[127.313548991335864,47.582602076906369],[127.31341331967684,47.583189442199838],[127.313186248929185,47.583405940807694],[127.312649766058414,47.583693177878168],[127.312048129278296,47.583786675038745],[127.311480867430916,47.583784225288603],[127.311195881398604,47.583828512244907],[127.310780621683818,47.584278110286441],[127.310393407372132,47.585108419995528],[127.310274892636727,47.585647815170532],[127.310505606052814,47.585838477732359],[127.311179647943106,47.585960250177656],[127.311290941121996,47.586192121027558],[127.31101862492838,47.586868675870605],[127.31067484505904,47.588620956887659],[127.310201660178095,47.590483960173692],[127.309780925231664,47.591115626263196],[127.309015443828613,47.591415775004677],[127.308412824291608,47.591803874224027],[127.308021928683885,47.592227032764356],[127.307409339643911,47.592684631231997],[127.306985846869509,47.593407323846968],[127.306808470025089,47.594069131009562],[127.306305082885928,47.600104837192589],[127.304639078139829,47.6002050492772],[127.303419219882912,47.600145340854283],[127.298280959764014,47.600127815136297],[127.296040308120524,47.600203894748638],[127.29366298319637,47.600369115039385],[127.293202740343702,47.602569836183562],[127.293289556227748,47.602828182039488],[127.293466900732795,47.602959216113788],[127.293831562839259,47.603151779289192],[127.293932850582451,47.603453183046007],[127.294107281851041,47.604468100701148],[127.294236544030596,47.605150253162968],[127.294566807848156,47.605438765161139],[127.295242783811247,47.605764217780447],[127.295952213035477,47.606288345706034],[127.296259820443296,47.60680690117794],[127.296448767588601,47.607864889035802],[127.296313858599262,47.608157663708283],[127.29596894056445,47.608618958960079],[127.295377832039506,47.609141125713869],[127.293936860661901,47.609613994867821],[127.292279597421754,47.609939199851347],[127.290068312603239,47.610599547925162],[127.289279825345787,47.61112966409182],[127.288442188564133,47.6125055457426],[127.288033330243991,47.614562428972818],[127.287966970795679,47.615456186913555],[127.288017106670026,47.617192682276361],[127.288738834728832,47.619142121022193],[127.289180415081461,47.619662582954341],[127.289725278335538,47.619895175793694],[127.290603209947591,47.620325269004248],[127.291293788025598,47.620693820891567],[127.292119124176054,47.621562489848365],[127.292845905258346,47.622038688845741],[127.293514801598675,47.622342641207432],[127.295012807013677,47.623129557931293],[127.295864595854255,47.623382463244624],[127.296569709571898,47.623794053955621],[127.29674615576171,47.624219747939591],[127.295200438127083,47.630531035219896],[127.295159407576463,47.631896684174599],[127.295678172076606,47.631952098812121],[127.296299242111189,47.632014286824656],[127.296584442840896,47.63197002188339],[127.296961163033416,47.631503762749396],[127.297915507140104,47.630970498740631],[127.298625348691104,47.630701729215744],[127.299295308636758,47.630711004856316],[127.300834379636584,47.630925180162926],[127.302665893583907,47.631116590045686],[127.303533226872219,47.631117857702549],[127.30400309966474,47.631226144786915],[127.3045942800549,47.631496834879769],[127.305239751027585,47.632325477002468],[127.305243346085376,47.632732713788911],[127.304586866258859,47.6338541378271],[127.303841672408183,47.634513570076898],[127.302410103696673,47.635710009898368],[127.301871279816183,47.636586602854806],[127.300912073128885,47.639386214015822],[127.300460197184805,47.639728225748058],[127.300055438775615,47.639813711837526],[127.299288161640291,47.640547569978381],[127.298660658769961,47.642364276757696],[127.301996971192466,47.643638902752315],[127.306367116946234,47.64526511906228],[127.310955355684612,47.647698788780183],[127.311196824629604,47.646949984200596],[127.311307492581108,47.646830243124832],[127.311692761141785,47.646212487959652],[127.311587048297497,47.645739848126738],[127.311511862901497,47.645403694846927],[127.311509378161389,47.645125120053038],[127.313288058593628,47.640106572131792],[127.313514682878576,47.639017537279898],[127.312959707289295,47.638452840937219],[127.310370780606775,47.636995242829649],[127.309338957705108,47.636504601116783],[127.308873218061208,47.636204994957147],[127.308085439574498,47.635490483757216],[127.307149054586958,47.634334137153239],[127.306714319396775,47.633719777299532],[127.30746261872342,47.633353945072294]]],[[[127.27491822892982,47.653756154850846],[127.275234125092723,47.65311548217219],[127.27538059719646,47.652096984152834],[127.2752869280651,47.651375487298225],[127.275026026763911,47.650535602219058],[127.274745870074582,47.649005990953981],[127.274605460700741,47.64833504597555],[127.274596918620659,47.648119898698589],[127.274790295358656,47.647873446918481],[127.275168244446462,47.647670540008789],[127.275563531917498,47.647392784018983],[127.275647817247375,47.647264266907158],[127.274778078270785,47.646951728970123],[127.274500680307696,47.646821557988744],[127.274097114861192,47.646379023246503],[127.273698838695182,47.645762493733976],[127.273613058568671,47.645443871110103],[127.27273333122443,47.644469042107936],[127.272412719804549,47.644273413099469],[127.271962831832184,47.644198841054376],[127.271219980787762,47.644010936749673],[127.270492325644682,47.643488761136702],[127.270132031147156,47.643111676956067],[127.269996675695111,47.642771881976337],[127.269845741659395,47.642448934190874],[127.269554550065067,47.64227760311131],[127.268862397240341,47.642240575933727],[127.26881633522585,47.64210340803924],[127.268792227138547,47.641905110094349],[127.268859860398024,47.641663733094639],[127.268858397940733,47.641216601898769],[127.268625636365741,47.640776461911166],[127.267917151270879,47.640121438811768],[127.267469757021701,47.639801148747395],[127.267409881613048,47.639622830138023],[127.267351774088922,47.63938651423468],[127.267149500436361,47.639100387918255],[127.266866470934772,47.638826779176398],[127.266359592942408,47.638645585752542],[127.265472658414666,47.638407847231477],[127.265159538046007,47.638297636881909],[127.265099669823826,47.638119316772702],[127.264886431334943,47.637863754082076],[127.264549221743579,47.637555248104114],[127.263978957726493,47.637311720942201],[127.263602444146514,47.63713918116747],[127.263428886040359,47.637065060787528],[127.263409401581868,47.636880484840525],[127.263550365216261,47.63654117111129],[127.263276568599139,47.636294992782339],[127.262987193398317,47.636065656887602],[127.262945752317677,47.635942206279957],[127.262985065289456,47.635806240966247],[127.263064754838325,47.635664019284789],[127.263184822760834,47.635515539973881],[127.263199342230791,47.635368985179426],[127.263178088989449,47.635242405196188],[127.263291780670187,47.635138205747587],[127.263551395583875,47.635025823234159],[127.263619039623109,47.634784453797806],[127.263594952197067,47.63458616318254],[127.263406521583079,47.634341186925106],[127.263059064909299,47.633875542183837],[127.262925534833897,47.633477757739662],[127.262913492019209,47.633378614284325],[127.262939696774339,47.633013797268475],[127.262815378922127,47.632643447759804],[127.262626957291289,47.632398473291325],[127.262220015077688,47.632071921209956],[127.262187785321942,47.631975904828877],[127.262217889663745,47.631812510281691],[127.262290848136146,47.631397159781358],[127.262353889207859,47.631142079992351],[127.26203514269055,47.630888443996618],[127.261498592446088,47.630365530022644],[127.261180561886064,47.629924191971774],[127.260929473780948,47.629429192217039],[127.260817923683916,47.628970292065006],[127.260613937842479,47.628742163889612],[127.260610048137337,47.628540747037633],[127.260690445558609,47.628210833228948],[127.260657872646391,47.627797415040966],[127.260442566235739,47.6272824471571],[127.260327480369725,47.626939537242777],[127.259952803844541,47.626709000897129],[127.259790258185404,47.626604321280716],[127.259874547108538,47.62647582083482],[127.259834890980343,47.626294381156903],[127.259821794441777,47.626065534760073],[127.259658192363929,47.625831151851045],[127.259362495718491,47.625646097885564],[127.259321069010866,47.625522651118487],[127.25925024583384,47.62537489919012],[127.2591482618963,47.625260834948541],[127.258931538842418,47.625121261240388],[127.258948895192006,47.62504642391815],[127.258924823935658,47.624848138734237],[127.258851174658744,47.624628678972279],[127.258811522123807,47.624447237726287],[127.258463429442799,47.624169297110413],[127.258349411673649,47.623956090703878],[127.258314363004573,47.623788366863863],[127.258454604393449,47.623636770796317],[127.258667436843837,47.623574934276824],[127.258849104042056,47.62354678386599],[127.258927014926627,47.623462563224379],[127.258910376330931,47.623349706952375],[127.258704303703112,47.622862175786295],[127.258668196818576,47.622564752859027],[127.258740450113507,47.622337116225737],[127.258907248397094,47.622138115986324],[127.258952939407408,47.62195788311427],[127.25887008689044,47.621710991849504],[127.258516378840582,47.621448638896361],[127.258191333336498,47.621153467014672],[127.258348690326528,47.621033103099599],[127.258514527412828,47.620853833998396],[127.258579074959187,47.620709454809131],[127.258714295664006,47.620438948018844],[127.258926307054182,47.620060559136768],[127.259144439564722,47.619700416925355],[127.259865233375692,47.619070414737109],[127.26039710070259,47.618719240714114],[127.261622399156835,47.618414167050673],[127.262239988219761,47.618318450139796],[127.263234916414376,47.61833701489747],[127.26429956914636,47.618479140829798],[127.264969926147373,47.618624786266437],[127.265809875192559,47.618686554162331],[127.266243276384529,47.618715355096121],[127.266586220820628,47.618642994263872],[127.266826459971981,47.618432983066249],[127.266678953009077,47.617572803149663],[127.266484801025072,47.616489501272412],[127.266199708093225,47.614882804092723],[127.265967398370833,47.613517485133855],[127.266077085361971,47.612329512761683],[127.265745925924108,47.612016125122899],[127.265100127964615,47.611943472205247],[127.263817950881531,47.611489561931336],[127.263198531950394,47.610990502017437],[127.262577707155884,47.61031889804503],[127.262548972744867,47.609728279780683],[127.262933314244208,47.608516960010029],[127.262827800825946,47.608034227124968],[127.262683198116292,47.607519163274844],[127.262602180857471,47.607109418264315],[127.262699204298059,47.606556902194335],[127.262698729987576,47.606134674157225],[127.262277186557355,47.60572012926923],[127.261750616595691,47.605245083242401],[127.260540649688366,47.604837572941918],[127.259083910182554,47.604199569224079],[127.258834766930093,47.604046231936138],[127.258664758965949,47.603707872815335],[127.258618143589217,47.603484754948759],[127.2588324627514,47.603029244895303],[127.259109902037054,47.602256832231781],[127.258927655425424,47.601881981797128],[127.258470836052339,47.601530494269817],[127.257912760376996,47.601213892773352],[127.257325044788914,47.600556379133927],[127.256942217849115,47.599751943919969],[127.256838162396463,47.599441757983939],[127.256474144382125,47.599114279180959],[127.25601735555172,47.598762786990996],[127.255637346626955,47.598303423801291],[127.255643038352545,47.597899455824937],[127.256140397796145,47.597361706779886],[127.256492691897776,47.596980801118463],[127.257136497393915,47.596458741954621],[127.257835381295081,47.596100893029828],[127.258358598744124,47.595808657265053],[127.258669426612201,47.595472560189172],[127.258861594217763,47.594866940171151],[127.259123446834877,47.594384877944393],[127.25990236703457,47.593592333194813],[127.260447685734519,47.593450217775235],[127.261302860325443,47.593221677739706],[127.261953183997306,47.593140056878703],[127.262553590983742,47.593162143091931],[127.263052754244427,47.593219118778677],[127.264138178720785,47.592666943078179],[127.26450876970803,47.592340760745216],[127.265083259400257,47.592117324807113],[127.265591819937114,47.591865719842239],[127.265972294189169,47.591653168086147],[127.266316029142715,47.591331145166372],[127.267430586882071,47.590697645971368],[127.26816232037649,47.590353838765196],[127.268930785982917,47.590119498123336],[127.269366347623162,47.590071143958731],[127.270117870105054,47.589954590802606],[127.271279017169945,47.58954416718317],[127.27237097509331,47.589432382777552],[127.273106991755029,47.589606140278207],[127.273329272685629,47.589763606984768],[127.273609919855076,47.589758463884387],[127.274146711746383,47.58967519817655],[127.275059256344619,47.589533641019315],[127.275918119418066,47.589400403739539],[127.27637204801259,47.589406762833647],[127.277746977047101,47.589212647744596],[127.278292222085241,47.589070468932995],[127.278868973735285,47.58876983901223],[127.279130660164085,47.588287752730757],[127.279294906334002,47.587935956974491],[127.279348881607859,47.587255764265898],[127.279599186381972,47.586487524783763],[127.280154323668,47.584693057141223],[127.280226082889527,47.583645412795299],[127.280388853127405,47.583121098014502],[127.280780020924638,47.582772478991295],[127.281255773190708,47.581834899213213],[127.281527334799392,47.581466452193283],[127.28185635894188,47.581185058238219],[127.282546765441722,47.58021416073742],[127.282734278875765,47.579090980708656],[127.282777426755487,47.578546845225119],[127.282805393106941,47.577621181809803],[127.282651646446027,47.57674291772819],[127.282899806043275,47.575380010905583],[127.282851931228549,47.574312578036874],[127.283027771953854,47.573575111299071],[127.283074710724065,47.573126366167536],[127.283271856792936,47.572788664055651],[127.283233636172568,47.572506690738855],[127.283222249128031,47.57222054986336],[127.283236227812139,47.571757731251303],[127.283310858049305,47.571055172186114],[127.283575635580988,47.570246325156013],[127.283895537331759,47.569601667859693],[127.284007164683942,47.568336756010254],[127.284255875846725,47.567396056259796],[127.285120434239133,47.565515244940144],[127.286117380948156,47.564112906711756],[127.286546015679278,47.563624108088753],[127.287236802166461,47.563075414770488],[127.288264088575858,47.56243608292565],[127.288810779901567,47.56179459195144],[127.289123621792555,47.561381343995386],[127.289582209050153,47.560561602201588],[127.290353419009747,47.560000403049294],[127.291346188552751,47.559174473900121],[127.291908886060227,47.558664839074204],[127.292407158192105,47.558299558975328],[127.292429517259549,47.557777871771975],[127.292746126684818,47.55745999682302],[127.293131786012708,47.556843503067988],[127.293596260828679,47.556713784244451],[127.294430158822067,47.556507491042105],[127.294962849904081,47.556328785270679],[127.295277127302896,47.556088040121182],[127.29561441325103,47.555747751019076],[127.295883478441581,47.555456447896866],[127.296252895330753,47.555379869766313],[127.296612369666462,47.555189678897641],[127.297040060268145,47.554950501752906],[127.297863983368643,47.55463057806994],[127.298989090922717,47.554283049183944],[127.299866645242233,47.553954779164492],[127.300684413086401,47.553616598770482],[127.302184295980339,47.552788562800565],[127.302841100996943,47.552475379946863],[127.303483337136285,47.552202842086025],[127.304352405969695,47.551933439158695],[127.305905814979795,47.551768798975893],[127.306925069552349,47.551610389788294],[127.307981874602035,47.551311785039665],[127.308541311224985,47.551128864728319],[127.308755889101988,47.55109551205863],[127.309205733056899,47.551006395270264],[127.309868618769642,47.550711423100815],[127.310773656147049,47.550129292192103],[127.310934585736931,47.550104273880017],[127.311256444916694,47.550054240857861],[127.311812027767161,47.549775938879478],[127.312587551436778,47.549732148193414],[127.313264214611081,47.54964614314072],[127.313817492384445,47.549444963112109],[127.314460402260195,47.548922751195775],[127.315000658055254,47.548934718275717],[127.316483484636905,47.548896089766387],[127.316834443841969,47.548764743284174],[127.31808037300506,47.547937614133886],[127.31817612263454,47.547634824101323],[127.318528539805371,47.547004217177687],[127.319232719275092,47.546664385700808],[127.319608922936283,47.546356363941698],[127.319763708049607,47.546313099142253],[127.319970572093297,47.546088993191447],[127.320178993815588,47.546037385255879],[127.320307683768249,47.545748662200566],[127.320429515083745,47.545691326816083],[127.320670886112381,47.545653786767161],[127.321095421830776,47.545741305185814],[127.321357481060431,47.545681352116667],[127.322243951159237,47.545044445133314],[127.322912857381013,47.54476765795966],[127.324144232039899,47.544652889780785],[127.324908992994096,47.544745052888643],[127.325101282770504,47.544561589992703],[127.325007696284231,47.544115505719702],[127.324716396892129,47.543585018069912],[127.32454392934072,47.543323946937996],[127.324540787932122,47.542978954820647],[127.324343788288658,47.542644927176113],[127.323966768058838,47.542530835944731],[127.323684038594564,47.542613203962709],[127.323275639313536,47.542657540292289],[127.323117013902362,47.54260544021961],[127.323067944328301,47.542459526752467],[127.323218866685934,47.542320892148929],[127.323811851791447,47.541902365241242],[127.324055491964558,47.54178769024039],[127.324033238,47.541637606024359],[127.323971901930719,47.541455215914205],[127.324087586074683,47.541379640952044],[127.3242714550437,47.541255071738668],[127.32418329887328,47.541076853060289],[127.323646100045138,47.540738169923522],[127.323465226957651,47.54053599027641],[127.323391624393125,47.54031712098628],[127.323004638253579,47.540089424809004],[127.322619217877588,47.540034219081463],[127.322033813654684,47.539971734913706],[127.320917367656634,47.539588796715627],[127.319715912286654,47.53937261787425],[127.31891744474639,47.538844247840451],[127.317987196150511,47.538259601778982],[127.317396418205561,47.537929241011298],[127.316979544218199,47.537360714792818],[127.316466936771022,47.53709496896893],[127.315840194773685,47.537077280227997],[127.315131458150489,47.536899605297002],[127.313992872273971,47.536366536864534],[127.312330248786552,47.535953329747045],[127.311385541806189,47.53540929375022],[127.309532948890705,47.534430645729174],[127.308251943210763,47.533977268210251],[127.306865221991458,47.533713043937297],[127.305061721107961,47.533551975848077],[127.304294808688653,47.533536836873004],[127.30389257903704,47.533599357215181],[127.303436713674714,47.533670210237801],[127.30268818437942,47.533709782769456],[127.301729743056711,47.533628442131139],[127.300965139307678,47.533536161832686],[127.299445179965488,47.533043088944886],[127.298145889976155,47.532534906728102],[127.297156965222626,47.531690623051581],[127.296756364216606,47.531253899040088],[127.295763662945589,47.530314245738317],[127.295063489961976,47.530077595972784],[127.293081679782816,47.529637048786434],[127.292753781229351,47.529668801080618],[127.291922526079475,47.529797937230526],[127.290601642387401,47.530233419034438],[127.289500545902627,47.530903420231944],[127.288124302632866,47.531846437075082],[127.287300170224924,47.533509710919198],[127.287000316176304,47.534381491720389],[127.287008541151067,47.534994329976961],[127.286659691190223,47.535720195719925],[127.285926938107949,47.536563253738322],[127.285439703575918,47.5385580377027],[127.285238015624941,47.539049950159267],[127.284436996869246,47.539941985835405],[127.283728058125178,47.540435893788583],[127.281575814180357,47.542094262246771],[127.281421604887086,47.54255960482304],[127.281496536059905,47.542950993286084],[127.28171959403312,47.544624407048474],[127.281313793578235,47.545685371708544],[127.280467356900076,47.547316586267677],[127.280122829632418,47.548758595713124],[127.280301058978083,47.549113278279648],[127.280483263368836,47.549567961898212],[127.280225853819132,47.55021163190019],[127.279758717294982,47.550847610294298],[127.278674312406466,47.55176051396306],[127.278317207826561,47.552459903883864],[127.278229454999718,47.552815630277777],[127.276816769773774,47.551163380262771],[127.276745819036009,47.551657360138293],[127.276465724330421,47.552586275026322],[127.276095171970653,47.552804774793294],[127.275772000352248,47.553076292187264],[127.275760677088101,47.553218913722326],[127.275804676570743,47.553614562905828],[127.275814131339061,47.55399544828304],[127.275572884277963,47.554334746002986],[127.274942746648875,47.554573402148009],[127.274433049743209,47.554994605151101],[127.274116280417786,47.555285246993002],[127.274004336858681,47.555745343000709],[127.27383707773933,47.555952413985992],[127.273686620709,47.556297745086006],[127.269390664119584,47.556018475958332],[127.258433045724956,47.555464217011583],[127.256592318656018,47.561623003191002],[127.255749173405093,47.561553848274663],[127.255821354834808,47.562184363177458],[127.255168092773701,47.562127844104758],[127.255098210132758,47.561781006280611],[127.252550181948493,47.561702615218053],[127.252278585305518,47.562922925021411],[127.250045307033858,47.562722059038272],[127.248873197827521,47.562640730072587],[127.246769702758257,47.562503858852658],[127.246255573564952,47.563277825715979],[127.244163221198463,47.562897236942518],[127.244107388208604,47.563284592898974],[127.24368110706358,47.564413119970077],[127.243119836979091,47.565646722187637],[127.243007961691902,47.566190038892366],[127.242860517611106,47.566581070275113],[127.242614964924769,47.56718717699912],[127.240619520116184,47.566034091756549],[127.240652102909863,47.565808131725454],[127.240553059158216,47.565697242200834],[127.240244012649285,47.565513687778576],[127.240163027729835,47.565410517991836],[127.24013286859082,47.56532051391725],[127.240088004928907,47.565232788769009],[127.239852679562119,47.565269243747835],[127.240925773762868,47.566901853201742],[127.240859865268746,47.567259213223593],[127.240737731221031,47.567541125089143],[127.24009355561904,47.567188574096342],[127.23924813224049,47.566835635238213],[127.238742661009908,47.566850819148456],[127.23803332071887,47.566950177248685],[127.237853471710764,47.566967515270889],[127.237703605771927,47.566843454185801],[127.236775002889701,47.566103649289168],[127.236261930115148,47.565772859079694],[127.235953063269321,47.565820698050587],[127.235223058133514,47.565996880254026],[127.234827248741212,47.566016104260669],[127.234305193712146,47.56621267108163],[127.23389148628614,47.566455574184396],[127.233859454159713,47.566544690156341],[127.233881596733184,47.566656974998324],[127.23440005939942,47.567050057027572],[127.23441550233747,47.567142340765059],[127.234174366667418,47.567484749989539],[127.233992635688793,47.567681208260318],[127.23360089835974,47.567804990975517],[127.232927083743235,47.5680566128013],[127.23266772125605,47.568159893748259],[127.232447093225645,47.568194059858477],[127.232241172413097,47.568225946995675],[127.232099476651726,47.568311006945343],[127.231907689033548,47.568477460125344],[127.231832835115867,47.568531127918305],[127.231430309918466,47.568530343018281],[127.231228468355624,47.568666793011964],[127.230485021728185,47.568802949905219],[127.230210216302979,47.568813943295943],[127.229849047744665,47.568659474974254],[127.229412443160385,47.56869551905784],[127.22913763683691,47.568706508834509],[127.228854236331088,47.568876620973853],[127.228676418413826,47.568946231098593],[127.228408309030769,47.568977223181342],[127.228242577945679,47.569129115274798],[127.227995210662542,47.56924364196621],[127.227055141684005,47.569439211172792],[127.225143136890551,47.569735205241329],[127.223835082937342,47.569637527044243],[127.222437934074279,47.569420227221961],[127.221881352297302,47.569222894215713],[127.221228281577297,47.568957115968175],[127.220135231302535,47.568475952146031],[127.21931573599808,47.568152550183349],[127.218816420023799,47.567979697301922],[127.218309712711374,47.567858010921775],[127.217748978022826,47.567794710763231],[127.217016498926668,47.567657934834585],[127.21533124328397,47.56775196127785],[127.214688975703581,47.567884689978847],[127.214132576284655,47.568054155041864],[127.213230601264016,47.568143684081981],[127.212289389628495,47.568189255269516],[127.20999353740909,47.568144233212983],[127.209238862738857,47.568160924732354],[127.208647412854162,47.568152365927496],[127.207432683977473,47.568040115808692],[127.207024570360716,47.567919818767237],[127.206238072871656,47.567841370218936],[127.205749402831785,47.56770018071925],[127.205378422874006,47.567690861170945],[127.204914172636833,47.567695962799533],[127.204405390216081,47.567641254064917],[127.204128779177182,47.567767404943346],[127.203755695364919,47.567825102873734],[127.203423943038985,47.567859732875078],[127.203140930605286,47.567820127934411],[127.202983010371625,47.567861223901119],[127.202709853355003,47.569170733878806],[127.202508743919083,47.570402408846114],[127.202258636774275,47.570607830952646],[127.201976705013962,47.570718125218811],[127.201399038878904,47.570824125825631],[127.200929537988927,47.57118019179476],[127.200886173615231,47.571637114867642],[127.200639327354963,47.572292247045993],[127.201881046114309,47.574318003248408],[127.201796429306114,47.575164834781873],[127.201476498809228,47.576114754256807],[127.200967959831971,47.57752738881954],[127.201576495673422,47.577733451995215],[127.201689985233102,47.577999382044958],[127.201554347710115,47.578253807277527],[127.201007421924075,47.578671873005987],[127.200657597291197,47.578725961205734],[127.200227200065527,47.57875915206364],[127.199635726824567,47.579117400138806],[127.199360147051593,47.57939345687506],[127.199030510258069,47.579727896264039],[127.198681766298492,47.57993188806276],[127.197889895087314,47.580204381064419],[127.197488170288921,47.580616660050055],[127.197178701571858,47.58123145489936],[127.196945528568449,47.581634354194499],[127.196592548153987,47.581972396153638],[127.196122995161758,47.582695310009598],[127.19582087107041,47.582892086900998],[127.195392603750321,47.583225087881615],[127.194899706238715,47.583951607246291],[127.194539285078747,47.584340819747275],[127.194119493363317,47.584772557758619],[127.193110313396758,47.586229204272563],[127.192784904973237,47.587163291187899],[127.192242141081991,47.588180993781656],[127.19202589593182,47.588781378943516],[127.19196762221938,47.589340676928146],[127.191584901280777,47.589883410969001],[127.190675225901572,47.590757702024554],[127.189377472031424,47.592158865769619],[127.189801607101259,47.592326795269734],[127.190991299930914,47.592509838301794],[127.191870303233088,47.592424039781108],[127.192266859125382,47.592362763086193],[127.192763099268106,47.592452838215699],[127.193344188882676,47.592796611034927],[127.193555241770483,47.593280948790657],[127.19355635298642,47.593797732176434],[127.193652887743511,47.594233062744543],[127.193714452883185,47.594857237748435],[127.193813253191436,47.596693014229302],[127.193748646356184,47.597453424016138],[127.193338406427173,47.598867593225748],[127.193229211712776,47.599201313962162],[127.193023546021777,47.599833441194761],[127.19262381997487,47.600545583212416],[127.192143517741911,47.601603703164081],[127.191660013014953,47.60257893510412],[127.191191334083427,47.603451817806835],[127.190748114305407,47.604620946149531],[127.190530731888103,47.605071444293266],[127.190183966018736,47.605575283715183],[127.189853103923198,47.606126696941466],[127.189083203707284,47.607713180780642],[127.188773537360859,47.608328024986342],[127.188492499424257,47.60895512420602],[127.188106454719062,47.609414998890742],[127.187826465116416,47.609825138268441],[127.187825406002617,47.610042100218223],[127.187778744811851,47.610416196932697],[127.187566636403588,47.61161634115377],[127.187472246823447,47.612581506220188],[127.187674837581255,47.613334034155564],[127.187891218376976,47.613834276801725],[127.188408833033577,47.614354701945409],[127.188872361025261,47.614933513981498],[127.189408035412328,47.615801370921346],[127.189543808581021,47.615913817785426],[127.1897177619459,47.615920302034432],[127.189987174784406,47.615845331035338],[127.189980803034132,47.615679541959203],[127.189951095747716,47.615517357840695],[127.190015796905982,47.615490686099619],[127.190225812239674,47.615458243991213],[127.190364771732604,47.615653584250055],[127.191035199700536,47.616850851250881],[127.191987796583987,47.617937827254551],[127.19292021371291,47.618377494753702],[127.193739116129308,47.618551180962541],[127.194425428108104,47.61869531179385],[127.195529672289624,47.61884157910076],[127.198152917310921,47.619053325881183],[127.198267607019901,47.619836140159777],[127.19889876603348,47.619888710202787],[127.19894665611956,47.620765239156157],[127.198876647714556,47.620776058151883],[127.197924079577135,47.620789828935543],[127.197635599996687,47.621101251245136],[127.197655857006382,47.621748560952504],[127.19776090240245,47.621915788786787],[127.197886088027161,47.62199651284331],[127.1987750581374,47.622159353185381],[127.198876909124309,47.622243683701733],[127.199089115448899,47.622511096256538],[127.199345956365036,47.623205246257676],[127.201507947030692,47.623504916050479],[127.200952147686337,47.623824305785902],[127.200034720744512,47.62474995610313],[127.199341121632187,47.625757763147149],[127.199070790715453,47.626783557948478],[127.198816501913029,47.628590763810074],[127.198955645560631,47.629519940898575],[127.199381331122609,47.630938563252727],[127.199346355217003,47.631127431719513],[127.198504136129174,47.632058141896401],[127.197966344412976,47.632724987010761],[127.19824444216367,47.633482601737619],[127.198821757955713,47.634327419711298],[127.199900961598757,47.635278163724486],[127.201515021263575,47.636579922021163],[127.202804374089197,47.637498191171296],[127.203895307933138,47.638263650902026],[127.204774882563825,47.638651127774395],[127.206040140776864,47.639088952299659],[127.206429970084343,47.639139541864374],[127.206607245419079,47.639112143729186],[127.206734006688848,47.638585861290132],[127.206680554234481,47.638356611717086],[127.206287684129805,47.638227321809268],[127.206220157769934,47.638095252067188],[127.206241269077395,47.637949482919694],[127.206886503793172,47.636535536858084],[127.210479772116145,47.637801042183973],[127.212561068018147,47.638587692895385],[127.213700058136538,47.634878210761528],[127.214076047998759,47.634098646017733],[127.214888705327255,47.632847562005182],[127.215579490916127,47.632120320096938],[127.216862855572046,47.630753155060923],[127.217860882954383,47.629675388967733],[127.218341504987563,47.629081634811939],[127.2186018520283,47.62846423097568],[127.218903551216471,47.627970288973167],[127.219279290448682,47.626873332251556],[127.219469559914046,47.625603065069278],[127.219654247248229,47.624189383723355],[127.22049086623862,47.61990467617818],[127.220976834146072,47.617362321996936],[127.222957928368047,47.617445401951301],[127.223349476152634,47.616966416809611],[127.223842929721371,47.616601514903877],[127.224086949881794,47.616506049003554],[127.224264017705735,47.616464225809622],[127.225129165392971,47.61625823214861],[127.225497893274365,47.61602804472632],[127.225929782601668,47.615542808161393],[127.226438801279315,47.615161058711308],[127.226681818021575,47.614935892028178],[127.22707810891086,47.614788004203689],[127.227825722822914,47.614484752769499],[127.228088112632577,47.614444148785722],[127.228809336736489,47.614505673943],[127.229409457160358,47.614585937704184],[127.229165046232822,47.616961109859595],[127.229430243277733,47.616992209765883],[127.230232233112289,47.617041234816604],[127.23082598358242,47.617165767963805],[127.231098579152047,47.617282290784509],[127.231173927143118,47.617443768825737],[127.230928563103063,47.619689268916098],[127.230983727746349,47.619853873018464],[127.236343154884835,47.62064033977947],[127.236713894992462,47.620669519888956],[127.237262957870598,47.621103954765886],[127.237859027790833,47.621805257865581],[127.238300547058017,47.621982196233105],[127.239131212912994,47.622243175705194],[127.240577162753908,47.623072619055939],[127.240920577907247,47.623336886213558],[127.236997220039811,47.625315005171522],[127.24081092235717,47.629659372096413],[127.237603230716985,47.631873010091745],[127.237411556286517,47.632061398759326],[127.237205307588866,47.632396339999353],[127.236652021730634,47.632582982741759],[127.235528287700731,47.633348510240886],[127.235279849625755,47.633747692805869],[127.233856040561676,47.63463179396512],[127.233604785369963,47.634959262865785],[127.233580217345221,47.635266080779289],[127.233409719799255,47.635581054238997],[127.232927388272117,47.636232869184973],[127.231938487773022,47.637020786202477],[127.230617316620041,47.637831250800069],[127.230539353633176,47.637915459790236],[127.231584513821872,47.638879239933608],[127.232179677341989,47.639450908116665],[127.232710466690548,47.639830519717272],[127.233399205917152,47.64030113028614],[127.234118348624591,47.640925759113081],[127.235426100743922,47.641848904053326],[127.236257233722839,47.642427342088695],[127.236935571356796,47.642423369867259],[127.238021330904743,47.642240896714576],[127.239211871744047,47.64224421770431],[127.239661707614189,47.642318891194769],[127.239953593606202,47.642302570733555],[127.240357426750577,47.642240062079047],[127.240714487313085,47.64222808303056],[127.241318447136493,47.642192312916904],[127.242702724938155,47.642266623938866],[127.244145793881927,47.642389543934847],[127.244653396814655,47.642383107151865],[127.244981061806143,47.642346806949092],[127.246208890814586,47.64195468313801],[127.247947582741958,47.641122689256534],[127.250018485136124,47.640268081961814],[127.252283811703833,47.63929674810953],[127.252654238299399,47.639831016042649],[127.253169137348905,47.640732526998093],[127.254156916750503,47.641777253731576],[127.255139073596723,47.642678548925396],[127.255763467397912,47.64377956604973],[127.256343290387917,47.644367991269306],[127.256704239757298,47.644557401287656],[127.257172527921625,47.644686889778065],[127.258066616632334,47.644692695034337],[127.258609296082028,47.644853946178735],[127.259544112611053,47.645170909881024],[127.260392506718205,47.645356948989935],[127.26077154366584,47.645283795292244],[127.261105591187373,47.645203176800436],[127.261923173080277,47.644917765023997],[127.262340109051465,47.645084056301066],[127.262985889942854,47.645489079052581],[127.263572166429881,47.646033198095814],[127.26365683444206,47.646222111863466],[127.263409583041536,47.646751078276651],[127.263330945419895,47.647023021183678],[127.263455996297381,47.647205677949771],[127.263674570779003,47.647287259231675],[127.264411060852922,47.64751948586251],[127.264754693398544,47.647783723214452],[127.264914828877721,47.64813411797774],[127.264576531426542,47.648518455226323],[127.264117776184037,47.648733852007751],[127.264125218726107,47.64881928584024],[127.264985752666036,47.649927028157705],[127.266475890635718,47.651644348970962],[127.267643317822788,47.652906584938009],[127.268075214336676,47.653243737997556],[127.269411910174412,47.653238624133024],[127.269799509863319,47.653380595258753],[127.271262884325722,47.654827867011839],[127.271594520769057,47.654992943163947],[127.271966829335213,47.654646600804995],[127.272925835698231,47.654339203858356],[127.273621640174625,47.654260213770712],[127.274487121136772,47.654053895253938],[127.27491822892982,47.653756154850846]]],[[[127.448014931606806,47.705644981807559],[127.448716936255295,47.705553118879678],[127.44965594073021,47.705619776070627],[127.450537734199642,47.705517597077481],[127.450246187770773,47.70442544384678],[127.450237186651592,47.703858005955652],[127.450545952886145,47.702992066142301],[127.450890566392076,47.702618262732585],[127.450977057984261,47.702178122197942],[127.45056272083923,47.701496240929309],[127.449731401010709,47.700897273220384],[127.449479240317203,47.70061669109667],[127.449083839658314,47.700145168887403],[127.448583265144407,47.699672300243158],[127.448296794196892,47.699290421762726],[127.447677628590668,47.69885385226037],[127.44729567840659,47.698344681004336],[127.447074119721592,47.698077096130575],[127.446768520048408,47.697715983788164],[127.446562618998769,47.697108214859014],[127.446268703712576,47.696549747234492],[127.446223675658928,47.695721325282207],[127.446144090314675,47.695022732098984],[127.44617515765043,47.694573492298801],[127.446455096947517,47.693854300895488],[127.447054990995923,47.692534097858811],[127.447206629310841,47.691977152782243],[127.447488057116246,47.691648787875408],[127.447738900879614,47.691307425158278],[127.447894263609697,47.690838773847645],[127.448107290096104,47.690076712073989],[127.448298946560328,47.689637944146597],[127.44845803729882,47.689257587982198],[127.448917908249001,47.68829699128014],[127.449593578784828,47.687587084078359],[127.450104212633406,47.687471761773779],[127.451582418281163,47.687276371876834],[127.453223193842575,47.687020013822909],[127.454074159826348,47.686904825119186],[127.454722499119768,47.686732417124716],[127.455363348260249,47.68638342312429],[127.455811031766956,47.686082385016867],[127.456036953569367,47.68574490096978],[127.456574604250051,47.685323152299588],[127.45715229284292,47.685019568723035],[127.457416277162238,47.684871662111703],[127.457846980713398,47.684288868220484],[127.458286946793478,47.684042353717061],[127.459270049565717,47.683622071751628],[127.459754000755353,47.683350904868078],[127.460310743330808,47.682908377923347],[127.460609236431722,47.682630644270503],[127.46086373094829,47.682377561258775],[127.46203993287908,47.681909299021498],[127.463279248645051,47.681395609007346],[127.46568469263417,47.681001769857744],[127.467057560035073,47.680804893923224],[127.467503022008074,47.680806343023988],[127.467883565430441,47.680693513234033],[127.468807034440829,47.680637991237568],[127.467526314425086,47.677709804714567],[127.467175081233819,47.67698262000102],[127.466625356297385,47.675824324874036],[127.466049177772462,47.674279125802776],[127.465316741795434,47.67211848224261],[127.465576725916819,47.672113379905156],[127.465848003657868,47.672386197893758],[127.46613650030632,47.672457279964462],[127.466452304841056,47.672471277273424],[127.466567066415251,47.672442769094246],[127.466563767801503,47.672295402083662],[127.466663858988781,47.672131869902749],[127.466870638590777,47.672099534935207],[127.467054680934581,47.672091881728441],[127.46726379256306,47.671974677796143],[127.467441132576582,47.671809628115206],[127.467609335825301,47.671709383285055],[127.468009289146011,47.671604586945008],[127.468491057429517,47.671465868965896],[127.468926181590163,47.671418948027068],[127.469478394859991,47.671258645742228],[127.469486458137951,47.671098940013636],[127.469480043268533,47.670529538822962],[127.46974151859321,47.670245696702558],[127.470455018982335,47.670102418823738],[127.47069239879616,47.670160359021772],[127.471448763197387,47.670464581964971],[127.47174406009259,47.670555714875583],[127.472087159038949,47.670512613788809],[127.472363303852219,47.670363790122238],[127.472496318294645,47.670205665948245],[127.472407881849861,47.669944858253636],[127.471772003986118,47.669537292089082],[127.471651705196521,47.669365973042822],[127.471587082191618,47.669175383844838],[127.47168832142583,47.668969415240163],[127.471948525634417,47.668865336904453],[127.472506349781426,47.668767521905345],[127.472849439744607,47.668724419946727],[127.474333312863521,47.668238791197624],[127.475191151857572,47.667925023699965],[127.475606918222255,47.667912797068539],[127.476073792438328,47.667913699048107],[127.476394223296793,47.667757938859772],[127.476537509974463,47.66749257088717],[127.4762980577473,47.6671075100069],[127.476161821946292,47.666980942196453],[127.476134606586427,47.666900695975507],[127.476158503569621,47.666833579726642],[127.476276650894064,47.666815095111431],[127.47635621737372,47.666728705839994],[127.476742601642073,47.666446432900344],[127.477334577939615,47.666174245092876],[127.477809404042603,47.666152769273417],[127.478109331752961,47.666074152780347],[127.47837980101032,47.665862825789532],[127.47895475602985,47.665540478141125],[127.479361534750041,47.665318383985621],[127.480051069884013,47.665242177082696],[127.480866565888874,47.665399769998906],[127.481250461823862,47.665477017233322],[127.481375412089918,47.665478590175198],[127.481540175689503,47.665368302029968],[127.481423260853589,47.665207024080921],[127.481299471210761,47.665163018969857],[127.481206375204636,47.665071955290614],[127.481150776675094,47.664953900110746],[127.481171338213571,47.664739420841343],[127.481458803596098,47.664578243192253],[127.481787098306597,47.664537430075775],[127.482282327844601,47.664576125128939],[127.482517384615107,47.664718911199905],[127.482594557084539,47.664854717775349],[127.482687653989004,47.664945778808644],[127.482828527791824,47.664902605935801],[127.482906928258316,47.664858647151917],[127.483028472112863,47.664850188858416],[127.483155667268889,47.66490422426881],[127.483193095575203,47.665014561188222],[127.483241892061415,47.665112555035549],[127.483365615228848,47.665293891989933],[127.483781362728848,47.665281641752891],[127.484140351076007,47.665193768950189],[127.484499405000122,47.664968563704107],[127.485009407332996,47.665004937117473],[127.485579509653334,47.665264292135809],[127.485899716831298,47.665520504824201],[127.485929189657483,47.665653214258967],[127.485881419945557,47.665787449100925],[127.485881357961844,47.66592478226675],[127.486089139185339,47.666124650268323],[127.486417376403622,47.6662211598575],[127.487020614879896,47.666073922286479],[127.487242135835686,47.666039247772062],[127.487508017396877,47.665860307891045],[127.487859102366073,47.665657466027412],[127.488185089304594,47.665701508230093],[127.488589474014574,47.665701586271894],[127.488825759680367,47.6656645980839],[127.488924577056608,47.66568081928903],[127.488935885947669,47.665805808245494],[127.488907446184101,47.665905328768389],[127.488947137346642,47.666068130296324],[127.4891776558283,47.666243308979062],[127.489329836725645,47.666325118842636],[127.489626292447511,47.666373781222127],[127.490305616431669,47.66626743512829],[127.490832809824127,47.665941944727862],[127.491483742553768,47.665797783266804],[127.491931329940698,47.665696019291097],[127.492241553242593,47.665372803072941],[127.492545967139549,47.665399085163159],[127.492937834724387,47.6654539282559],[127.493115047177128,47.665426182145907],[127.493380910771947,47.665247229878609],[127.49354335312475,47.665221795894688],[127.49395794988294,47.665251949934849],[127.494352072239096,47.665359253964489],[127.494397480280057,47.665447214815408],[127.494315590757111,47.665755810762874],[127.494328059373217,47.665838367927805],[127.494409809657355,47.665941763841154],[127.494585874063134,47.66595645014597],[127.49478691612542,47.665998913725453],[127.494868669104449,47.666102311135724],[127.494914077145467,47.666190271944458],[127.494883346677895,47.666374662054494],[127.494912838368691,47.666507368712644],[127.495069580012697,47.666556770189615],[127.495291097375286,47.666522083896623],[127.4954717144429,47.666504365057776],[127.495608073313178,47.666356252292736],[127.495767199085947,47.666046122058681],[127.496043272034001,47.665897256012144],[127.49623525189169,47.665867194300716],[127.496447657642335,47.665897312879601],[127.49683612779873,47.665942114725063],[127.49706449212033,47.6657901551498],[127.497186036873259,47.665781684907728],[127.49738593358353,47.665866579043026],[127.497430197170829,47.665996972976501],[127.49746424511676,47.666097274756787],[127.497417646807975,47.666189080759693],[127.497451694753906,47.66628938398572],[127.497660660855317,47.666446803744726],[127.4979934309725,47.666648214825777],[127.499010071447557,47.66671083583045],[127.499730316387854,47.666450144974135],[127.500084771836029,47.666257303719888],[127.500193841684549,47.66616627582799],[127.500396070421345,47.666028966891467],[127.500775504424283,47.665863902036783],[127.501615017786534,47.665542265242919],[127.501903553062505,47.665475945212918],[127.502152337887182,47.665384157920016],[127.502468145116922,47.665260745137225],[127.502802127061443,47.665145049207318],[127.502996360792196,47.665167440777957],[127.503099703880736,47.665288580267202],[127.503132616356154,47.665431314781131],[127.503183701749748,47.665581767799779],[127.503450602898752,47.665772359230758],[127.503793603928756,47.666003847268691],[127.504110505306471,47.666112659758518],[127.504258177559407,47.666089528109389],[127.504464946381574,47.665919808787812],[127.504709180341038,47.665860421021058],[127.504784184277355,47.665669090026675],[127.504961391340188,47.665641328906631],[127.505053401283163,47.6656374788408],[127.50536460913861,47.665821126786035],[127.505597456951875,47.665911412978453],[127.505743987446067,47.66593071281148],[127.505849642798225,47.665829650259369],[127.505970068250249,47.665726275298063],[127.506150703284206,47.665571210959733],[127.50636311262808,47.665601315794952],[127.506709548815721,47.665705496225499],[127.506973075892503,47.665748719252186],[127.507224117285219,47.665709388029619],[127.507480866573189,47.665457887836268],[127.507937490113576,47.665565928909082],[127.508288494234435,47.665500369970694],[127.508363894327829,47.665473230073033],[127.508496374272625,47.665425545103801],[127.508599682326974,47.665202668219074],[127.508643765352858,47.66515252072837],[127.509082648064719,47.664912360701962],[127.509187468881976,47.664895937193243],[127.509412080940635,47.664860742819307],[127.509687384930814,47.664742621823272],[127.509868231967232,47.664671436077093],[127.509884362116438,47.664626060217785],[127.509864792318012,47.664522007100437],[127.510014546865733,47.664359283029029],[127.510137793926106,47.664350683086731],[127.510301352884838,47.66436790172456],[127.510415394010167,47.664285760283086],[127.510458017273706,47.664225520038173],[127.510565146761223,47.664123037895173],[127.511009768809487,47.663946244018909],[127.511551132227211,47.663914969982365],[127.512313639308331,47.663977582771196],[127.512713325829452,47.663947083147526],[127.513073852990615,47.663847733130055],[127.513557634398651,47.663600523092995],[127.513816796561485,47.663527770048667],[127.513984963877647,47.663512125949879],[127.514177315637795,47.663567677059895],[127.514464115368739,47.663715544243409],[127.515243898849363,47.663828995778786],[127.515420129443555,47.663790663170133],[127.515539919786619,47.66377188707856],[127.515680445043188,47.663674876862068],[127.515829031781067,47.663555177762809],[127.515915419168692,47.66353092512486],[127.51608012976763,47.663505107944431],[127.516206830850237,47.663506674290694],[127.516453321377668,47.663628722107703],[127.516653736415833,47.663800839222063],[127.516800018975061,47.663906457086313],[127.516912898578667,47.663867339854285],[127.517155934185524,47.663700696983582],[127.517443888251591,47.66352701500837],[127.517578650815551,47.663505890210075],[127.517758335431907,47.663477723799026],[127.517856241916419,47.663580212048956],[127.517893109674048,47.664152893098503],[127.517934577704182,47.664274940009591],[127.518310080679413,47.664451747897353],[127.518422962978022,47.664551888090067],[127.518342340079599,47.664778770944352],[127.518087788070815,47.665097192123341],[127.518084334946849,47.665226281220804],[127.518153446833253,47.665290433925364],[127.518432195862545,47.665321725287271],[127.51859576021117,47.665338935135075],[127.51883995644134,47.665407778704406],[127.518915980863838,47.665492271742735],[127.519190125128986,47.665556421095545],[127.51939630555465,47.665513389082413],[127.519692330085249,47.665456270730353],[127.519872018294834,47.665428101741846],[127.520039039360725,47.665455481234211],[127.520116221711618,47.665636201736895],[127.520332778577156,47.665762939781047],[127.520507861124315,47.665767630146952],[127.520777395235413,47.66572537509559],[127.520893731556328,47.665696425229427],[127.521213921666288,47.665292718934104],[127.521602073819082,47.664996193900578],[127.521880812966913,47.664888220011754],[127.522310449319505,47.664852997803337],[127.522755057892994,47.664815427018119],[127.523046485744217,47.664930421897218],[127.523411621262767,47.664937446970889],[127.523805557667728,47.664982805014972],[127.523896563294215,47.665064947174578],[127.524101592079688,47.665064936284885],[127.524333111284619,47.665050059764724],[127.52445406494607,47.665127507160584],[127.524540466706696,47.665242509216952],[127.524644136782072,47.665269102937522],[127.525106029839904,47.665282376803496],[127.525312206672311,47.665239336094757],[127.52548841930016,47.665061731087867],[127.525723374561068,47.664917763815602],[127.525977929264769,47.664877848156756],[127.526337295802634,47.664821496230573],[127.526710491904254,47.664805822875195],[127.526935096776384,47.664770601821125],[127.527111322879009,47.664732254174268],[127.527308270420164,47.664615668951122],[127.527547824157011,47.664438839233938],[127.527698704293769,47.66437232904493],[127.527968227625109,47.664330060764271],[127.528252723177289,47.664285446292517],[127.528525725683721,47.664392605296328],[127.528943889651856,47.664648399982212],[127.528993437129628,47.664747755130662],[127.5292238109826,47.664775900891875],[127.529420754032188,47.664659312136315],[127.52968681974798,47.664606871220109],[127.530032380976564,47.664649089062692],[127.5303261336677,47.664817266173507],[127.530902101088543,47.665026884085854],[127.531248806770776,47.665026067963979],[127.531376654103696,47.664984589715942],[127.531559763097974,47.664827318003375],[127.531749817865943,47.664829645986288],[127.532006682138316,47.664842918754083],[127.532291177690496,47.664798296250844],[127.53247085871358,47.664770111177639],[127.532627476390161,47.664627705783815],[127.532872723649206,47.66423572020507],[127.533112263911278,47.66405888073087],[127.533621352657562,47.663979023264353],[127.533779176771475,47.664072105900118],[127.53399233171703,47.664327908206403],[127.534138643920599,47.66443351108947],[127.534381673239309,47.664406097786618],[127.534681139215692,47.664359120891547],[127.534993295692075,47.66439585288375],[127.535106203143471,47.664495979268942],[127.535162715259659,47.664754932080406],[127.535704149644374,47.665002087041906],[127.535997879877627,47.665030994944317],[127.536136100057163,47.665020024184571],[127.536342226583955,47.664837706807965],[127.536630136632496,47.664663986266675],[127.536812136207345,47.664688995821642],[127.536989577730495,47.664886126765403],[127.537104809123576,47.66503945078864],[127.537223455911331,47.665063686996135],[127.537494115611551,47.664978372301526],[127.53771757692833,47.664986163882645],[127.537854656247404,47.665018221940329],[127.537926108245145,47.665135563701412],[127.537937665969594,47.665262304171108],[127.538017173160441,47.665356958069026],[127.537865206960433,47.665605769024715],[127.537618887112927,47.666180054010411],[127.537664988653319,47.666269236724467],[127.537814768353883,47.666385005783567],[127.538376935855339,47.666553911729267],[127.538569318158267,47.666609432983776],[127.538586611625789,47.66666028325286],[127.538592392284642,47.666723653792509],[127.538994450358018,47.666885541091318],[127.539485262879822,47.667215622075013],[127.53984586370288,47.667394726092333],[127.540539300220118,47.667393049760825],[127.54110266966741,47.667658179283187],[127.541343537639492,47.667995336908042],[127.541539436846776,47.668200285183012],[127.541659331394456,47.668460007858528],[127.541790688445218,47.668567953790877],[127.541977294580875,47.668560099225516],[127.542143144243525,47.668491221097526],[127.542324941697473,47.667959179730381],[127.542586416123882,47.667939575148047],[127.542736153603656,47.667916077709179],[127.542868594022607,47.667841729981248],[127.54330964167427,47.667515404882117],[127.543450133693128,47.667418365930388],[127.543534248343065,47.667480157828464],[127.543562144625952,47.668118561136239],[127.543673938166378,47.668261713188194],[127.543840975401878,47.668289065786503],[127.544030984355857,47.668152115723046],[127.544825784074845,47.668123801187257],[127.544960548435412,47.668102651026643],[127.545030764351282,47.667984499860019],[127.54510336529421,47.66805881108769],[127.545279647990654,47.668159701148568],[127.545574146283485,47.668210088938508],[127.545713061759045,47.668188286075868],[127.545908433655228,47.668086630811707],[127.546067194712052,47.668061713021878],[127.54624129899392,47.668204770858104],[127.546429160075974,47.668388265189037],[127.546798716204108,47.668614234845307],[127.54701092791862,47.668623523718125],[127.547223057886413,47.668448242924072],[127.547361976056891,47.668426438951009],[127.547600120337037,47.66838906129523],[127.547793986656814,47.668344432144394],[127.547963422394162,47.668289440247484],[127.548117600246329,47.668251041950512],[127.548506918412414,47.668289322888135],[127.549650445921287,47.668393798005802],[127.549870243908373,47.668302499799829],[127.550024418167339,47.668264099697645],[127.550172507238599,47.668269250807121],[127.550328273312218,47.668358388815321],[127.550584762088761,47.668374920124549],[127.550723677564292,47.668353111886269],[127.550893110606637,47.668298115763903],[127.551088474418009,47.668196455269182],[127.551227389893555,47.668174646956274],[127.551364808775801,47.668209868738181],[127.551542012245392,47.66842342996209],[127.551894830064782,47.668723011041401],[127.552053592019959,47.668698088110879],[127.552132971649996,47.668685625733779],[127.552415198057759,47.668286347768266],[127.55262581705928,47.668168089941936],[127.553128023812164,47.668046648007113],[127.553595029182276,47.667760344750704],[127.553785798110951,47.667645200028325],[127.553952134660491,47.667519692191178],[127.554103213325007,47.667410779187186],[127.554301660154422,47.667379622167907],[127.554813139317631,47.667469698770084],[127.555359722845495,47.667540065222511],[127.556284848349264,47.667494193979508],[127.556703077894454,47.667371726286717],[127.557392941811827,47.667064612968545],[127.557721120639584,47.666984680245562],[127.55809965722564,47.666868441251474],[127.558479685014987,47.666695170906898],[127.558829311120178,47.666739656881838],[127.560001733838575,47.66668332329958],[127.560374304712738,47.666795196087641],[127.560647655765464,47.666922654246008],[127.56094395158722,47.667117500899884],[127.561388217004236,47.667132920083539],[127.561722469341703,47.667009426741018],[127.562058209289219,47.666828902160759],[127.562106951876515,47.666665058233065],[127.562151105869404,47.66648773273171],[127.562263969303402,47.666328017243409],[127.56249750792108,47.666277135797252],[127.562715791348566,47.66624284980778],[127.563169101902133,47.666100649886957],[127.563416408998208,47.666090203256509],[127.564538721893356,47.666439274937133],[127.564998238008968,47.66643808678289],[127.56540726700895,47.66628863805991],[127.565747583872877,47.666121584279523],[127.565906334149858,47.666096646192472],[127.566881785970821,47.666014399181471],[127.568080104423871,47.665911330702144],[127.568557551810869,47.665410341998069],[127.569102362962724,47.665168550918523],[127.569415265939085,47.665105188170614],[127.569746532276525,47.665095737141492],[127.570004495188442,47.665055203931558],[127.570259349031176,47.664944162896859],[127.570541597896806,47.664729424048296],[127.570746102066238,47.66465469184935],[127.570857460822083,47.664551998197972],[127.571031309982359,47.664325892981431],[127.571179243645048,47.664146455972521],[127.57131814384924,47.66412462902764],[127.571478368261609,47.664042655996731],[127.571668946747508,47.663742922819026],[127.571932371416324,47.662920574956942],[127.572028472287087,47.66283447629899],[127.572376457170321,47.662751394075208],[127.572629818911352,47.66269737882164],[127.572919907374427,47.662751185952018],[127.573298549063338,47.66281947572142],[127.573713605758925,47.662626452861005],[127.57408602212287,47.662553725079675],[127.57452878196348,47.662626134020378],[127.574640288941382,47.66270800218895],[127.574767048414472,47.662773274835068],[127.574936609017598,47.662902819805097],[127.575206856391091,47.662959740088944],[127.575345753900308,47.662937910227846],[127.575667665182365,47.662716924871972],[127.575826241186263,47.662507410215824],[127.576451684219663,47.66201152725872],[127.577193218333875,47.66161098819358],[127.577769943034497,47.661278947179248],[127.578357657724254,47.661285958223679],[127.578635611744559,47.661426855937151],[127.578710726173654,47.661770030811418],[127.579153829170693,47.662211554237743],[127.579541656133387,47.662306779961092],[127.580761205369825,47.66214346090841],[127.581823306886392,47.661763494773254],[127.582613855777453,47.661568207037604],[127.582781774260297,47.661570204823391],[127.583045963395463,47.66167066213012],[127.583319335109451,47.661798074719705],[127.58393810186368,47.662325563234766],[127.584266413642126,47.662430136201401],[127.584448300029308,47.662657128709256],[127.584185946152289,47.662868774812388],[127.584006082771097,47.663138446701332],[127.584105476865759,47.663307412762691],[127.584236840204696,47.663386156238175],[127.585196981139916,47.663320387046213],[127.585661066985352,47.663332611123366],[127.586529906748368,47.663550982088076],[127.586919220422857,47.663589158782884],[127.587126830068172,47.663584912290965],[127.587390836845344,47.663500796105588],[127.587659437606874,47.663430159217178],[127.587711436587071,47.663521378825635],[127.587696382619555,47.663722542255648],[127.587746914650879,47.663870793778138],[127.588040149014162,47.663995076804724],[127.588238569792438,47.663963872976893],[127.588403566055575,47.664079924841189],[127.588641908863423,47.664320083252555],[127.588836454309543,47.664326798047952],[127.589377840185207,47.664223000850782],[127.58966869580955,47.664270535065633],[127.589951593258832,47.664375283818295],[127.590627428186465,47.664343613164789],[127.591118600034378,47.664173085946111],[127.591503575744284,47.664093882047482],[127.592959510359535,47.664014122038623],[127.593268476918368,47.664114765215416],[127.593463297249016,47.664363946901425],[127.593652082697574,47.664595424245725],[127.593892728785761,47.66457622676694],[127.594049133561526,47.664551623710132],[127.594389931024111,47.66442339505484],[127.594706857554669,47.664466816974674],[127.595001837344512,47.664606968018106],[127.595188429107139,47.664670890983778],[127.595384893354748,47.664602675024909],[127.595709493294464,47.664346403987253],[127.596108459366633,47.664227676230233],[127.59706278460871,47.663965609918044],[127.597820647399857,47.663771758214089],[127.598193829128448,47.663899598247752],[127.598332412227293,47.664064348062219],[127.598481155272083,47.664339430863272],[127.598902352850871,47.664366440067475],[127.599493943771137,47.664329325700251],[127.599822950845663,47.664408148702918],[127.600206306893142,47.664646318220967],[127.600388778083556,47.66461760672648],[127.600781696697254,47.664481160060618],[127.601172701899372,47.664419635042663],[127.601633958051664,47.664403020807008],[127.601952801587032,47.664371505047946],[127.602846715126304,47.663932349087716],[127.603303838129989,47.663823101900057],[127.603590571385496,47.663777978797214],[127.604420885999275,47.66379655402757],[127.604755618935386,47.663650595844807],[127.60495398042481,47.663507443851316],[127.605156470571345,47.663456920841391],[127.605357055391153,47.663481318713842],[127.605635840353045,47.663493410258219],[127.605840236724546,47.663367960803136],[127.606246480048867,47.662707043853501],[127.606781462733139,47.662343005790738],[127.607234433723619,47.6621411207053],[127.607442957853934,47.662108299164657],[127.607785622913951,47.661905119035815],[127.608066304219435,47.661842281718926],[127.608665811992296,47.661747914277967],[127.609062836805137,47.661704073841776],[127.609245295419129,47.661675352863682],[127.609415671692574,47.661611221127202],[127.609587950597771,47.661472168024737],[127.609629567748229,47.661111157987605],[127.60854558596624,47.660349015875539],[127.608254405151726,47.660059052255392],[127.607686360871725,47.659682079837275],[127.606949533031298,47.659051845014488],[127.604641228365381,47.657437706181391],[127.602837118424134,47.656415787824656],[127.598764050026404,47.654538344709877],[127.596360370328483,47.653368219992274],[127.595272824929793,47.652755841236257],[127.594668699816367,47.652272601843585],[127.594634121864431,47.651848992915369],[127.594966055650104,47.651050601172287],[127.59539072342092,47.650685319945381],[127.595603054611388,47.65050267897896],[127.595632952340651,47.650348742207889],[127.586845199243427,47.64913819771968],[127.584012865949845,47.647998068196884],[127.579358701649326,47.647554722791305],[127.575568909789922,47.649568156815732],[127.575524293164747,47.65129127579813],[127.573096081374757,47.651337183064356],[127.57171061600026,47.651461667183241],[127.56657952443733,47.651633774184013],[127.561128326307696,47.649897443191882],[127.558323503919695,47.650449932159184],[127.553552900890381,47.64974426411262],[127.552623351183783,47.651289157195791],[127.551233667320744,47.651078360974218],[127.549015820309023,47.650773747278883],[127.546832053582605,47.650407799053163],[127.545821332106996,47.650100161113862],[127.543595158610927,47.648882843248664],[127.541487431578346,47.647852088238004],[127.540635137884522,47.647444954762754],[127.538986909001252,47.647200032742838],[127.536781286263917,47.646930653142867],[127.535604291120748,47.64677961622305],[127.535574055624906,47.64620617026705],[127.53552740701052,47.644292415294061],[127.532530000198634,47.644277785838128],[127.528592268388365,47.644242745212068],[127.528850737950094,47.643306961094886],[127.528930832639162,47.642734875727228],[127.528537016608496,47.641248807103366],[127.528620064059908,47.640295779704452],[127.52897642573312,47.638829884901199],[127.529704342285953,47.63785864113278],[127.524887051116366,47.637812550114944],[127.521338728201968,47.63778847497808],[127.517876689368947,47.643888271133079],[127.5170861189183,47.643597518875126],[127.514842209085288,47.644059891069922],[127.512741115212719,47.641348163202977],[127.510280379917859,47.640932137970474],[127.504399090888114,47.640029220174526],[127.495396668285778,47.641798939916477],[127.492676837303421,47.643137196155358],[127.488788652970925,47.644990070117601],[127.484488849795511,47.643230516887385],[127.481778206781868,47.643516610295592],[127.47940152684815,47.641787651964783],[127.474758719947786,47.642735378077447],[127.472294650106591,47.643148570969473],[127.471932134075388,47.643039426759998],[127.470913220862712,47.642314244720971],[127.46902824098629,47.639153738166286],[127.467365206070454,47.641570053068726],[127.467610477584032,47.643494360747106],[127.464643995275807,47.643986002020995],[127.463840852902791,47.644857979947453],[127.45830393124055,47.64472866497357],[127.456653619164129,47.645622477901604],[127.455090429297215,47.645452218768263],[127.454018644840133,47.644209989888751],[127.453106264633604,47.644159115936489],[127.452800541891264,47.64373698513991],[127.451651196892598,47.642866232268418],[127.450741917670442,47.642704294091352],[127.450359284766776,47.641934835163397],[127.447889657947186,47.641850908040865],[127.44731472179231,47.643157009174644],[127.442051965954818,47.642514352002166],[127.441482702660963,47.643957736716146],[127.440246512133868,47.643791525980355],[127.436929216147604,47.641683803300211],[127.43362989365356,47.639628530033526],[127.429558417070538,47.637334490053242],[127.427974133862435,47.637581883771283],[127.427429564357396,47.638136800706199],[127.422966114188313,47.642261053853964],[127.420305950205446,47.644500557776752],[127.417639339013817,47.646962138277281],[127.413645343022338,47.650432356127276],[127.411376789706139,47.65274877700557],[127.410105884683134,47.653803903124292],[127.408724129350801,47.655373846248899],[127.408212764273614,47.655425966058729],[127.407430823937929,47.655520286837934],[127.405715479224796,47.655621975045896],[127.404383506728863,47.655774418038312],[127.403244802274727,47.655896712050627],[127.401880487733578,47.655833048815957],[127.400023169679699,47.655514560237009],[127.395865651560442,47.654891274909488],[127.393565455088336,47.654586472273316],[127.392855120362242,47.654531352727744],[127.391751887683697,47.654758584708489],[127.388719100724344,47.655175959924406],[127.386712232040253,47.655378129714428],[127.381687017713375,47.656161074022904],[127.379474752832806,47.656478053214606],[127.378005807917333,47.656706859006434],[127.377030528572902,47.656831122178538],[127.376063355625647,47.657341064179384],[127.375272486934364,47.657408955022966],[127.374020935215853,47.657438026868952],[127.372456912610716,47.657626299762036],[127.369641317625778,47.657843592165698],[127.366397244216643,47.658238084107204],[127.364785662105362,47.658406035007644],[127.363653288977375,47.658305910253084],[127.361534330308714,47.658055306793536],[127.359069847242523,47.658107189162308],[127.356631928257556,47.65823780880423],[127.354936525245449,47.6586397932126],[127.353300713774317,47.658977208756617],[127.350791038262798,47.659257077080781],[127.347143375152697,47.659299333132743],[127.346001251710533,47.659532239062933],[127.345070128155626,47.659787594101545],[127.34406167492611,47.660054970047327],[127.341714024949141,47.659729094218683],[127.337697004238606,47.658916521906754],[127.335159388426831,47.658509540031638],[127.332967797374209,47.658767283990649],[127.329096019872111,47.6592308348567],[127.326202894888283,47.659459306095243],[127.326409110348266,47.658017824295833],[127.323570114250188,47.658044387813391],[127.322073561411045,47.659520499948357],[127.321354390855831,47.65943877078243],[127.320080597749254,47.658918110777748],[127.319067569399991,47.658688566826285],[127.317926418833366,47.658561826732715],[127.317073594235197,47.658445565956981],[127.316724664324326,47.659826264843588],[127.316466360052615,47.661717974811275],[127.315760479173719,47.662159228840622],[127.315376055927644,47.662467651227189],[127.315208175174064,47.662935896764218],[127.314812752955731,47.663936922853978],[127.314510106943189,47.664730093163179],[127.307674858285722,47.663884481212001],[127.306111573197313,47.6646798647552],[127.303786966804026,47.666477727803958],[127.300896525986246,47.668529169140733],[127.300295472212767,47.66867771190195],[127.29914752409438,47.66877293611374],[127.29489156858628,47.669184543161734],[127.291453152750279,47.669607387165215],[127.290284167884508,47.669761071165752],[127.289303053982394,47.669747430037461],[127.286606056377863,47.669834081085391],[127.286044188913777,47.671551670895454],[127.285927831033334,47.672536941781487],[127.28574014781762,47.675246661985831],[127.284455903711077,47.676026135867943],[127.284192762011514,47.676453832195712],[127.283983470719974,47.677646973117263],[127.283979381588864,47.679692647029533],[127.284144677889302,47.68091063099773],[127.284281526341402,47.684343929738382],[127.284457068826001,47.687771281273918],[127.284515270673282,47.688473116704543],[127.284585500063812,47.688638985063115],[127.284606544896022,47.688811678224319],[127.284616804554872,47.688895867301206],[127.284974075323163,47.689139605048304],[127.285503411197553,47.689076235121455],[127.285636651117116,47.689037518927613],[127.285779308075831,47.688996068833681],[127.285962484443701,47.688967668854595],[127.286063878188173,47.689080923996798],[127.286227037396571,47.689263171195357],[127.28667106386176,47.689437369202004],[127.287055343377375,47.689433875850561],[127.287492781598232,47.68917909518612],[127.28778170494644,47.688978768824853],[127.287805353994614,47.688962369216618],[127.28787397809576,47.68897173610263],[127.288382490123638,47.689041142921781],[127.289108389958628,47.68915293089448],[127.289517388415916,47.688977336278157],[127.289643889174201,47.688452938096468],[127.289956450790797,47.688236209109498],[127.289957402106666,47.68821653292715],[127.289973751444833,47.687878312233359],[127.289640369574897,47.687705663149842],[127.289612757159702,47.687541685812107],[127.289745857840458,47.687446263030445],[127.29019214626345,47.687545315957443],[127.290282417966381,47.687539155050963],[127.290407458064024,47.687530621819342],[127.290559301194804,47.687245337987392],[127.290952618660469,47.686941299956928],[127.291192646707813,47.686754512791076],[127.291347383312086,47.686805298076578],[127.291656860114003,47.686906867894578],[127.29175804005942,47.687029531030227],[127.291889286617348,47.687188646167279],[127.292192788724293,47.687272447211718],[127.292267576166665,47.6871673700889],[127.292736317081918,47.687169453975422],[127.293178890971248,47.687175596179067],[127.293655869437671,47.687120315110761],[127.293618554319053,47.68684566804972],[127.293119932742528,47.686754741984132],[127.292822408025486,47.68668871317778],[127.292859476107367,47.686636630023081],[127.293046762267693,47.686373483089035],[127.293246401161511,47.686230346249936],[127.293650849651826,47.686205007155074],[127.293754711068374,47.68643194101589],[127.293834477872295,47.686568667130594],[127.293884740409098,47.686654817950846],[127.294117978989476,47.686693424038076],[127.294153838837289,47.686800035107481],[127.294024462571784,47.68698836295804],[127.29407227630108,47.68713051080308],[127.294351874238359,47.687143231831371],[127.294847581680074,47.686898084201566],[127.295031974366893,47.686869484124038],[127.295449411597957,47.68680473507257],[127.296111011821523,47.686889067081523],[127.296462335742632,47.68711500621415],[127.296489967022495,47.687278983079153],[127.296109421803465,47.687375403961184],[127.295900089189431,47.68740787399144],[127.295696732168693,47.687458113180782],[127.295668305879886,47.687537305206597],[127.29567163773126,47.687620534229517],[127.29567946295569,47.687816011126131],[127.295849879653275,47.687995231905091],[127.295722765345658,47.688108428082636],[127.295564963689614,47.68837594982282],[127.295610522647536,47.68859323274787],[127.296052311409341,47.688842535816818],[127.296418651568715,47.688785710883003],[127.296616935803044,47.688730409146999],[127.297173778989759,47.688575096896344],[127.297300102779985,47.688705070057246],[127.297235616319014,47.688983640934588],[127.297187871759959,47.689189877037705],[127.297283516286583,47.689474176062838],[127.297642301614459,47.689885920963938],[127.297930144289325,47.689841270287893],[127.298149972819161,47.689676295867116],[127.298333144695462,47.689647881140999],[127.298624709988914,47.689696129929366],[127.299219797152247,47.689828165936056],[127.299729623415374,47.690197781045477],[127.299964348707476,47.690404416279542],[127.300165458143411,47.690429304050767],[127.30027814910089,47.690141495159203],[127.300313540028142,47.690051103945322],[127.300279922375239,47.689869357164],[127.300495239565706,47.689854649167955],[127.300673907289166,47.689976498709754],[127.300721736289887,47.690118648086134],[127.300926570140902,47.690236437723023],[127.30109328128799,47.690322749984198],[127.301137385873474,47.690371997094552],[127.301140730301327,47.690455357044186],[127.301144839195402,47.690557801992412],[127.300596791413597,47.69081109505062],[127.30065883086381,47.690913648142995],[127.300951876580811,47.691129931238883],[127.301350373732419,47.691086801795343],[127.301798253071809,47.690699476920514],[127.301807648551403,47.690698019024303],[127.302112263670935,47.690650756800757],[127.302628863231291,47.690794959056198],[127.302793325895223,47.690956405245394],[127.30276713641139,47.691047126255505],[127.302742469572024,47.691132562202696],[127.302486772211196,47.691190931954544],[127.302204906027882,47.691253362059719],[127.302171983671045,47.691482825084634],[127.302374575327192,47.691675749084517],[127.30244034727734,47.691871204131118],[127.302590603983376,47.69207224679964],[127.302674315289693,47.692321010202065],[127.302923267201052,47.692488044209611],[127.303243265071572,47.692457090818316],[127.303510215627895,47.692023046040397],[127.30404257163832,47.691641298984067],[127.304533781215454,47.691546383164798],[127.305195439829575,47.691630676064008],[127.305639530973409,47.691804818998499],[127.305875041393151,47.691768273791865],[127.305990184751337,47.691619528888857],[127.305844414231856,47.691268220226277],[127.305839301919576,47.691140998096166],[127.305836947435196,47.691082414231396],[127.306040308049248,47.691032159183301],[127.306512810210549,47.691127103149107],[127.306725356996694,47.691231733902171],[127.306743826358911,47.691240825251647],[127.306777531148413,47.691235594173385],[127.307005502007939,47.691200216808589],[127.307235028749517,47.69114590023792],[127.307456328719809,47.691148949034897],[127.307587639058141,47.69129554625323],[127.307632765926442,47.691345926820503],[127.307696309156341,47.691616513981209],[127.307904896168708,47.691827196711934],[127.308320582583235,47.692080527745773],[127.308594221995222,47.692075453965806],[127.30901888796943,47.692028243178136],[127.309101885115112,47.691963115960348],[127.309345610628156,47.691771870990678],[127.308867867695383,47.691415993810722],[127.308757966905205,47.691171299214474],[127.308774201259013,47.690991843243793],[127.308787128914332,47.69084893071804],[127.308898528094375,47.690607282289719],[127.309194591252435,47.690505241974641],[127.309414772820119,47.690641907222791],[127.309507849063408,47.690699678280687],[127.309821855170952,47.690650943043998],[127.309898859655405,47.690470720957201],[127.309863362726958,47.690396846181237],[127.30980690001806,47.690279333250018],[127.310048384234477,47.69026054794265],[127.310086064069068,47.690293421923741],[127.310321271756479,47.69049864120521],[127.310433419233192,47.690668200170158],[127.310682383720959,47.690835220726406],[127.310909664674327,47.69085603272574],[127.311594489941328,47.690600160898207],[127.311945123956235,47.6904148580428],[127.312212774300249,47.690392008066084],[127.312505088788626,47.690197059044294],[127.312503585907152,47.690029022978784],[127.31279740058207,47.690002109293779],[127.313205610318562,47.690069620239925],[127.31341494383085,47.690037122841467],[127.313594366139171,47.689915786826852],[127.313470248611367,47.689710694052245],[127.313223519132038,47.689468545101015],[127.313222015352224,47.689300509107063],[127.313536010680011,47.689251764701716],[127.314631767578774,47.689065266997474],[127.314786010109671,47.689039013757196],[127.315286914305389,47.68905473304892],[127.31593291169078,47.689664916070456],[127.315965887048222,47.689740725702322],[127.316054802295056,47.689945141101511],[127.316011474752258,47.690307107870254],[127.316095233669373,47.690555859738019],[127.316271695130538,47.690752825855981],[127.316542751886061,47.690804670887658],[127.316919160363113,47.690876665730528],[127.317438026372926,47.690945681203857],[127.317675043267357,47.691077152903219],[127.317299771159114,47.691434571297783],[127.316971565381834,47.691522921751968],[127.316953696992513,47.691549512964833],[127.316733104894752,47.691877793238056],[127.316760065133039,47.692284941230007],[127.316858030008035,47.69249409690125],[127.317083084936186,47.69259003529541],[127.317429244442707,47.692554987786494],[127.317681185049011,47.692403687997029],[127.318073694929225,47.692342744933839],[127.318427446098227,47.692431272225676],[127.318765297086657,47.692515818258222],[127.319131639042695,47.692458935046204],[127.319514411185239,47.69228731696618],[127.319834567159262,47.691807053867876],[127.319861989131596,47.691765917986267],[127.320097490568187,47.691729349170117],[127.320230137599665,47.691819776174206],[127.32027619871586,47.691851176191697],[127.320348006446423,47.692064390934767],[127.320399631727483,47.692299438116635],[127.320495377763734,47.692583725028292],[127.320535035688593,47.692783236971358],[127.321037493071358,47.692966973810023],[127.321435989324712,47.69292379025709],[127.321623616844789,47.69274507619],[127.32141721363692,47.692459274263165],[127.321345402313142,47.692246058715924],[127.321428362627955,47.692083598860847],[127.321934451001141,47.691705852163835],[127.322557870130197,47.691104211761456],[127.322834968055986,47.69106117783631],[127.322950368332329,47.691043256295416],[127.323150788760415,47.691311286028579],[127.323605362345305,47.691352870939632],[127.323840861985261,47.691316295182361],[127.323993407598621,47.691442181154116],[127.324290289121919,47.69175132178497],[127.32429558019895,47.692012261146495],[127.323944972235125,47.692197597024837],[127.32364255080148,47.692420847796733],[127.323592137347717,47.692458064933447],[127.323460604227179,47.692721559082948],[127.323584757687684,47.692926644249766],[127.324000510577562,47.693179931849357],[127.32433845858408,47.693202235809302],[127.324835635669658,47.693125018730115],[127.325196681158744,47.692807177917864],[127.325265437312325,47.692684314924463],[127.32559739714911,47.692688846867888],[127.326264390857659,47.693033988121712],[127.326602339762516,47.693056286702195],[127.326679302026179,47.692876054787874],[127.327004422988736,47.692451604088809],[127.327358785910434,47.692359165851741],[127.327624215618997,47.692411422877647],[127.327945745117106,47.692548453184841],[127.328043745026378,47.692757601147925],[127.328097620587229,47.692917509054013],[127.328094718130558,47.693235819011392],[127.328138843377317,47.693285057929046],[127.32827802744913,47.693272294258932],[127.328432667035401,47.693258113877611],[127.328604541698652,47.692950949739924],[127.328796596116518,47.69262195606855],[127.329116583207281,47.692590944709067],[127.329331226661282,47.692819367274176],[127.329532354961813,47.692844215194704],[127.329663862929479,47.692580716827656],[127.329688483954811,47.692408614206713],[127.32983196377026,47.692180649994825],[127.330015130256712,47.692152194911074],[127.330377021060542,47.692245555028016],[127.33050785259681,47.692225229735918],[127.330667072692762,47.6921257031712],[127.330705882607958,47.691913999752117],[127.330897254306137,47.691828176280886],[127.331062457181886,47.691746417886066],[127.331360710432619,47.691569196959925],[127.331492210315446,47.691305698197255],[127.331721718192483,47.691251343037024],[127.332085824241759,47.691269563822317],[127.332311970622925,47.691187421184864],[127.332355688034525,47.69117154229577],[127.332502927299515,47.691036479027154],[127.332754163626603,47.691128328231414],[127.332805832925132,47.691363368748064],[127.332744303718059,47.691514921286846],[127.33270050455971,47.691622803201746],[127.332623560262405,47.691803037028762],[127.332637087093985,47.692006609899877],[127.332815817699469,47.69212842176173],[127.333799055219018,47.692349606080967],[127.333917252849147,47.692536916197639],[127.333983117325815,47.692732357132719],[127.333521217979722,47.6931593850124],[127.333741866671389,47.693405569217383],[127.334274961995305,47.693434925155735],[127.334536628661155,47.693394267025575],[127.334493155591289,47.693101854914268],[127.334759251849789,47.692910926125052],[127.335079238042198,47.69287990284419],[127.335571972060393,47.692952919114788],[127.33591591093149,47.692992963255811],[127.336494697265692,47.693239586017299],[127.336730196905663,47.693202989210981],[127.337407393679229,47.69276118799926],[127.336829256826988,47.692271397294604],[127.336810861126636,47.692187739123113],[127.336777574053698,47.692036356033057],[127.336991327277246,47.69185355618032],[127.337157541655998,47.691913864910411],[127.337712915198921,47.692115374823516],[127.337946197796768,47.692153912774025],[127.338135992053324,47.69190004091584],[127.338210713020345,47.691794938044985],[127.338556858153865,47.69175984223255],[127.338856659201838,47.691750642737091],[127.339019644137082,47.691744011286929],[127.339104771188374,47.691506406241324],[127.338978362058214,47.691376467876694],[127.339189897341313,47.691268800113122],[127.339519641034329,47.691348436837892],[127.339723943082745,47.691155264917747],[127.339874619301966,47.691012794862111],[127.340184697975147,47.690810484924519],[127.340213197925863,47.690791890283968],[127.340695517774904,47.69099739180443],[127.341038816147275,47.691280596787983],[127.341049557303094,47.691402265827811],[127.341068129073292,47.691612604154841],[127.340896313698849,47.691919779803683],[127.340950219802394,47.692079684836827],[127.341116985746694,47.692165951720646],[127.341632103985091,47.692141980246326],[127.342004415246194,47.69210280677985],[127.342212793849356,47.691659058871416],[127.342277733959591,47.691443285293687],[127.34263805989815,47.691368576835742],[127.343601769839992,47.691368354919078],[127.344013801907991,47.691528681287927],[127.344109646758909,47.691812951842429],[127.344215891405881,47.691964720756154],[127.34450371162292,47.691919976926471],[127.344654713930609,47.691877802912785],[127.344713656887947,47.691644261888314],[127.344884832662004,47.691580255258586],[127.345200402736438,47.691699480717695],[127.345514387284453,47.69165066720295],[127.345484433859639,47.691561832015609],[127.345203223446447,47.691381172266809],[127.345213621445851,47.691248666728235],[127.34550742803593,47.691221690181322],[127.345821409889027,47.691172876824034],[127.346091253918871,47.691074829114505],[127.346262429692914,47.69101081876245],[127.346449373595078,47.691075246949012],[127.34649950228291,47.69114224676067],[127.34654742919993,47.691284380866101],[127.346575180853989,47.691448350065031],[127.346723981390923,47.691481309766118],[127.347070120236197,47.69144619318358],[127.347100783330106,47.691377438988624],[127.347195566372378,47.691164913190732],[127.34756847770808,47.690882554135392],[127.347827013745189,47.690775681116818],[127.347858493407657,47.690762668911844],[127.348224800329348,47.690705714248693],[127.348562742945973,47.690727961217107],[127.348695160907113,47.690875655909572],[127.348728910612323,47.69105739192792],[127.34869487075126,47.691179349920723],[127.348641618621187,47.691370138113037],[127.348568507435218,47.691643281711229],[127.348632215056853,47.691913852212323],[127.348707906204339,47.692219955825031],[127.348826143360355,47.692407253709419],[127.349363031371354,47.69252945706242],[127.349879745017731,47.692673493282953],[127.350037340061249,47.692405907724066],[127.350112643136626,47.692057625892566],[127.350181976008543,47.692001979940621],[127.350286012596584,47.69191847673742],[127.350684481900416,47.691875213708897],[127.35099153684429,47.691932650226939],[127.351066574018304,47.691946685847654],[127.351146668707315,47.69210251774809],[127.351140078666404,47.692327923958061],[127.351127497760842,47.692535565982972],[127.350942142080086,47.692639182914064],[127.351022236769154,47.692795013954438],[127.351289884418165,47.692772093065884],[127.351525373278292,47.692735474163655],[127.351803999238427,47.692336871810546],[127.352274974263764,47.692263630950492],[127.352705602356451,47.692234059091206],[127.353279926758603,47.691978637852863],[127.353998657139385,47.691658991147946],[127.354943948922909,47.690951013293109],[127.355204862800605,47.690884183756424],[127.355501588915331,47.690808184101876],[127.356157310563745,47.690874481010027],[127.356490874791646,47.691046979922646],[127.356657659600558,47.691133229769676],[127.357029954691953,47.69109401805526],[127.357243074603218,47.691154362130511],[127.357282841224247,47.691353860797001],[127.357226427024386,47.691476443936438],[127.357171612724045,47.691595548093268],[127.357360186170212,47.691827997902585],[127.357977193124782,47.69210599580407],[127.35816576836757,47.692338445756839],[127.358177185056462,47.692617152020986],[127.358355962374418,47.692738932828291],[127.359073836660698,47.692907746824595],[127.359492476735909,47.692842621914522],[127.359624823730087,47.692623653962166],[127.359704550109868,47.692491748989077],[127.359823952380793,47.69219269074928],[127.360033268825163,47.692160128160232],[127.360298723686569,47.692212326128171],[127.360366851019378,47.692332619797014],[127.360460579439533,47.692692017716411],[127.360297547791845,47.692983659976555],[127.360288850303263,47.69299921724015],[127.360238143100446,47.693175395715997],[127.360261555891654,47.693489637808511],[127.360347668394823,47.693663229744978],[127.360612565402448,47.693958603295108],[127.361304294222336,47.694131475956176],[127.361938255979609,47.694051545995336],[127.362353090791302,47.693893509929794],[127.362468671628989,47.693501545841784],[127.362738500387536,47.693403466231139],[127.363367012964289,47.693062590260858],[127.364102911048391,47.692387114717377],[127.364597868396871,47.691487340806248],[127.365383338213348,47.691122031090408],[127.366079406794398,47.691144608036566],[127.366681177423416,47.69105096295786],[127.367967558622141,47.690701179714196],[127.368269528203157,47.690616786144105],[127.368551330606095,47.690554230106684],[127.368931257784169,47.690700790901573],[127.369083886042489,47.690826629984365],[127.369463352384855,47.690767571089168],[127.369633321721423,47.690741116741066],[127.37003776931347,47.690715566988395],[127.370321218328343,47.69082104391515],[127.370457505333391,47.691061622276898],[127.370414997054141,47.691180432297372],[127.370268321931121,47.691223149876954],[127.37013918910904,47.69126075909557],[127.370016014812222,47.691466922703114],[127.370238436778294,47.691881086884187],[127.37046956162277,47.691994708781316],[127.371069159227133,47.691976181076811],[127.372050868712336,47.692029069157144],[127.37250165410174,47.691977602052383],[127.373188428712851,47.691646303873462],[127.373351926586139,47.691396459717772],[127.373562785437855,47.690634360741711],[127.37384675278058,47.690496659039233],[127.374721622035793,47.69064095605178],[127.375120579124868,47.690354455061758],[127.375419220447796,47.689933974215862],[127.375438233290751,47.689500927960907],[127.375588060602055,47.689047517111518],[127.375860021961046,47.688874281100141],[127.376330946680781,47.688800962812351],[127.376634561077168,47.688884588924985],[127.376682550876239,47.689026712251632],[127.376754533778254,47.689239898027218],[127.376987828952537,47.689278372190145],[127.377380266069267,47.689217271275581],[127.377565571444308,47.689113622147957],[127.377717047164211,47.688828244779003],[127.377968838650105,47.688676842866435],[127.378051658827729,47.688514353751259],[127.378397767130267,47.688479163210353],[127.378761869586299,47.688497265836126],[127.379049652972427,47.688452454932097],[127.379327603399418,47.6882969791859],[127.379223451827073,47.688070103026192],[127.378990655217791,47.687788463158327],[127.379043476156511,47.687537146769472],[127.379102295146396,47.687303595982719],[127.379249431105052,47.68716848883242],[127.379627691908269,47.687146985973342],[127.379748172157591,47.687259120885031],[127.380029457130931,47.687439710856403],[127.38027091170288,47.687420810838269],[127.380697659073547,47.687298256868566],[127.380712275561535,47.687295981894145],[127.38093311289937,47.687261591792002],[127.381319048010056,47.687425883861664],[127.381340883359698,47.687572079729868],[127.381334749662912,47.687674062892867],[127.38132839587891,47.687779717106359],[127.381213424098931,47.687928518919584],[127.381108287074696,47.688187984973297],[127.381127961077738,47.688409314808403],[127.381169958215636,47.68853367183273],[127.381391253694289,47.688536608910958],[127.381649036943159,47.688402967752673],[127.381970655374431,47.688539876765567],[127.38207705183666,47.688530079248224],[127.382264435913399,47.688512825042807],[127.382424693563465,47.688473125775225],[127.382467732747003,47.688462464717681],[127.382660705243097,47.688544609832967],[127.382688543135416,47.68870857010932],[127.382643505200335,47.688750551969981],[127.382796826059803,47.688944945836653],[127.38338219614667,47.689597356224581],[127.383349280078036,47.689629789194406],[127.38302773980017,47.689849604196738],[127.3829634662399,47.690029351931784],[127.382979987156332,47.690139939287299],[127.383165538669843,47.690195910735866],[127.38347763855235,47.690133160087584],[127.383573682829308,47.690047478207269],[127.383800450844646,47.690040449861982],[127.384017775769806,47.690190487261034],[127.384104017630335,47.690445809018158],[127.384321346148653,47.690595845251053],[127.384622375193672,47.690746991253427],[127.384913052053264,47.690744154072632],[127.385468200119064,47.690453631868991],[127.385798144136444,47.690280962889943],[127.38669322368888,47.690155689086509],[127.387097744044496,47.690304854795947],[127.387308945154302,47.690355784773445],[127.3873472088938,47.69036501112128],[127.387622635953178,47.690378689792759],[127.387761164254854,47.690357110856972],[127.3879619709585,47.690396554721218],[127.38801190920347,47.690544373103663],[127.387818551330156,47.690588637992484],[127.387620650676396,47.69061946490401],[127.387607089708879,47.690623008969688],[127.387486661561866,47.690654481060662],[127.387452901975223,47.690801189721455],[127.387758478292142,47.690965766935825],[127.388065270927996,47.691150348264529],[127.388150663880538,47.691201723065113],[127.388730977350775,47.691747857008089],[127.388718774635933,47.692026972162047],[127.388716657306759,47.692075426755672],[127.388559615625454,47.692227196719521],[127.388291631108203,47.692297231083053],[127.388041806034408,47.692421017707687],[127.388012585634883,47.692581166092602],[127.388418752602377,47.692673495701605],[127.388634467746527,47.6928803617811],[127.388809323019942,47.692966285708074],[127.389051348920418,47.692942730002549],[127.389209671599332,47.69291806594547],[127.389395931883627,47.692606145943216],[127.389391739446168,47.692408767187047],[127.389454369089478,47.692285848230313],[127.389474740185193,47.692282674938475],[127.389691852209538,47.692248852883615],[127.389848544446252,47.692281022988411],[127.389957860433171,47.692419591906869],[127.389967964683464,47.69244950287802],[127.389998722100472,47.69254053390204],[127.39017648971209,47.692696729243828],[127.390450298007323,47.692767235217239],[127.390541451855796,47.692852052197587],[127.390591398185606,47.692999869062113],[127.390447980353898,47.69319195604735],[127.390271149685162,47.693346810732784],[127.389873363999257,47.693649250214094],[127.389644955660131,47.693713121281398],[127.389402582111671,47.693920621745008],[127.389374991256034,47.694023937228543],[127.389665681590358,47.69402108994705],[127.389843800443259,47.693993342699954],[127.390242179915589,47.69418589885796],[127.390453709808767,47.694195382711499],[127.390621461204887,47.694013650977453],[127.390639967398087,47.693883458861144],[127.390579312251816,47.693765600066307],[127.390832048765375,47.693712081887455],[127.39116849029719,47.693659667746346],[127.391216209703401,47.693369326250384],[127.391189306957244,47.693104756060471],[127.391406479168751,47.693036585733282],[127.391547161630442,47.692992423900272],[127.392306648575598,47.692958969938466],[127.39255904372942,47.693089391714111],[127.39251912439488,47.69327949993729],[127.392382945187691,47.693427039868141],[127.392336130384948,47.693477755772648],[127.392267338298836,47.693644073796079],[127.392311120389095,47.693835287713902],[127.392462936570439,47.694037962007435],[127.392692630398727,47.694101194092589],[127.392977155595261,47.694141736788943],[127.393272388710074,47.694152319895572],[127.393477415698953,47.694389140152715],[127.393592906705123,47.694484310189132],[127.393830396113344,47.694447307937089],[127.394048093839359,47.69441338872948],[127.394223294065867,47.694315362833166],[127.394498736396557,47.694329027166361],[127.395130304143564,47.694391107054699],[127.395166745201408,47.694394688956542],[127.395404230118146,47.694357684222339],[127.39535427300855,47.694209868183442],[127.395243321189469,47.694128137708418],[127.395254358789387,47.693914234243962],[127.395440263340788,47.693786248245495],[127.395574255150251,47.693751223912543],[127.395506132309023,47.693549656832111],[127.395447089638665,47.693374965256211],[127.395485377632681,47.6932416890102],[127.395561622142395,47.693159082079369],[127.395692695325536,47.693053785232166],[127.395945424652638,47.693000257252976],[127.397257084443382,47.693121208785264],[127.397620768284483,47.693149406965802],[127.397798879052445,47.693121650185006],[127.397753460231669,47.692987272812658],[127.397618173051598,47.692895191065105],[127.397569834706189,47.692690541131377],[127.397758975887513,47.692448883096418],[127.398046740409058,47.692375747000888],[127.398501906882032,47.692304811789512],[127.398680014955076,47.692277055163842],[127.398774744996743,47.692064254279501],[127.398732566399218,47.691816208002962],[127.39861544944236,47.691777877810303],[127.398299138257798,47.691643282920602],[127.398308543618825,47.691486216108601],[127.398576515559625,47.691416163120309],[127.399246117975821,47.69142497084416],[127.399363553834576,47.691279357801676],[127.399246759372886,47.691057087773302],[127.399201337857178,47.690922711732497],[127.399294442846454,47.690766746904181],[127.399472867126576,47.6905550482481],[127.399680163259831,47.690367140231729],[127.399639282727861,47.690246202266557],[127.399803760663161,47.690178132209518],[127.400111299799008,47.690101905975894],[127.400338383123,47.689910912990086],[127.400461976933045,47.689721903919164],[127.400344863569444,47.689683575815373],[127.400066833192398,47.68941571187041],[127.40000616636803,47.689297858095657],[127.400077857317584,47.68920181326439],[127.400414267408337,47.689149378263053],[127.400497964341625,47.689150478822924],[127.400806805136341,47.689201359132717],[127.400975817767176,47.68914672482515],[127.400921310690649,47.688985475005325],[127.400999163184736,47.688846032231417],[127.401221380334889,47.688825541134086],[127.401644408680284,47.688844473902094],[127.401846836843035,47.688827066809836],[127.401881872935775,47.688807459787007],[127.402625377953697,47.68829549219631],[127.403340996570307,47.688070774865366],[127.406721067726906,47.68888765115765],[127.407705349088801,47.689087829111728],[127.406722008262989,47.691108373173066],[127.405811137226166,47.692863497811423],[127.404173838144914,47.696018134038788],[127.403341460999286,47.697746374195006],[127.401302817107009,47.701699659279498],[127.400803500234417,47.702626246985076],[127.400629577412261,47.702799784927201],[127.405602695740868,47.702788219980839],[127.40996703029306,47.702765502984896],[127.41275156782369,47.702793478918352],[127.413172662096287,47.702567845296677],[127.413228465441719,47.702345847068152],[127.413676092354521,47.702276046257154],[127.414563256850997,47.702422097118429],[127.414700691902922,47.702596187087323],[127.415069323664653,47.702911972028183],[127.415583824760446,47.702885060760295],[127.417515464929366,47.702868206071706],[127.419736440773192,47.702468470263966],[127.423597268710324,47.701421820739938],[127.424880940590057,47.701114898152539],[127.427190466964731,47.700203517064338],[127.428170659195459,47.702325797156128],[127.429955676343667,47.701798391925031],[127.430603039168304,47.702550586062976],[127.431324186017136,47.702438042104788],[127.43329753855798,47.704245355208585],[127.433624248640342,47.704514326035373],[127.434044432919492,47.704982015971176],[127.434157055604985,47.705159971744393],[127.435258680299214,47.705165782971648],[127.435519350733358,47.704698476743225],[127.435891201158739,47.704018281228855],[127.436511712441202,47.703299267856892],[127.43694071907484,47.702787906221936],[127.437465735849372,47.701941591834519],[127.437777024553171,47.702319613813707],[127.438065444844867,47.702630102180969],[127.438430466277367,47.702857529820633],[127.438657989775891,47.702910889895037],[127.438956393045316,47.702864303738949],[127.439216495744247,47.702859247935464],[127.440288968310838,47.703242861299415],[127.441015046012282,47.703840536167142],[127.442121344640839,47.704787693975938],[127.443758844046371,47.706220747255955],[127.444637923705315,47.706883410805432],[127.444915203090815,47.706928994740544],[127.446229712337626,47.706403745797353],[127.447130906722236,47.706049691928079],[127.448014931606806,47.705644981807559]]]]}";
//    }

