package com.upyuns.platform.rs.datacenter.entity;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import tk.mybatis.mapper.annotation.KeySql;

import javax.persistence.Column;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;
import java.util.Date;

@Data
@Table(name = "rscp_mosaicimage")
@ApiModel(description = "")
public class RscpMosaicimage implements java.io.Serializable {
    /** 版本号 */
    private static final long serialVersionUID = -6625661497803837040L;


    @Id
    @KeySql(useGeneratedKeys = true)
    @Column(name = "id",insertable = false)
    @ApiModelProperty(value = "")
    private Integer id;


    private String title;// 资源的中文标题


    private String resourcename;// 资源唯一的标识名字


    private String srs;// 资源的坐标系

    private String legendurl;// 图例url


    private String extentSrs;// 四至范围的坐标系


    private String extent;// 数据有效四至地理范围


    private Integer status;// 状态，-1删除，0，等待处理，1，等待传输，2、已完成


    private String dataPath;// 存储路径


    private String metajson;// 补充信息，以json形式表现


    private String orderId; // 订单id


    private String recordId;// 推送id


    private Date createTime;// 创建时间


    private Date startTime; //开始时间


    private Date endTime; //结束时间


    private String areaCode; // 区域码


    private String areaName; // 区域名称

    private String resolution;

    private String layers; //图层标识

    // 兼容旧版本
    @Transient
    private String extent_srs;
    @Transient
    private String data_path;
    @Transient
    private Date create_time;


    private Date finishTime;// 完成时间

    @ApiModelProperty(value = "地图服务地址")

    private String url;

    private Integer hot; //1--热门；0--默认

    private Integer isDel; //0删除 1 正常

    private String imageUrl;

    /* This code was generated by TableGo tools, mark 1 end. */

    /* This code was generated by TableGo tools, mark 2 begin. */
}