package com.upyuns.platform.rs.datacenter.entity;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import tk.mybatis.mapper.annotation.KeySql;

import javax.persistence.*;
import java.math.BigDecimal;
import java.sql.Timestamp;

@Data
@Table(name = "rscp_image_price")
@ApiModel(description = "影像数据单价表")
public class RscpImagePrice implements java.io.Serializable {
    /** 版本号 */
    private static final long serialVersionUID = 1324632775380935758L;

    /* This code was generated by TableGo tools, mark 1 begin. */

    /** 标识 */
    @Id
    @KeySql(useGeneratedKeys = true)
    @Column(name = "id",insertable = false)
    @ApiModelProperty(value = "标识")
    private Integer id;

    /** 卫星 */
    @ApiModelProperty(value = "卫星")
    private String imageSatelliteType;

    /** 分辨率 */
    @ApiModelProperty(value = "分辨率")
    private String imageResolution;

    /** 光谱 */
    @ApiModelProperty(value = "光谱")
    private String imageSpectrumType;

    /** 单价 */
    @ApiModelProperty(value = "单价")
    private BigDecimal price;

    /** 优惠 */
    @ApiModelProperty(value = "优惠")
    private BigDecimal discount;

    /** 更新人 */
    @ApiModelProperty(value = "更新人")
    private String updName;

    /** 更新时间 */
    @ApiModelProperty(value = "更新时间")
    private Timestamp updTime;

    /** 产品类型 0101 原始 0102 正射 */
    @ApiModelProperty(value = "产品类型 0101 原始 0102 正射")
    private String imageProductType;

    /** 每景单价 */
    @ApiModelProperty(value = "每景单价")
    private BigDecimal unitPrice;

    /** 传感器类型 */
    @ApiModelProperty(value = "传感器类型")
    private String imageSensorType;

    /** 是否应用于数据定制 */
    @ApiModelProperty(value = "是否应用于数据定制")
    private Integer isUseForData;

    /**  状态。0 不可用， 1可用 */
    @ApiModelProperty(value = " 状态。0 不可用， 1可用")
    private Integer status;

    /** 卫星全称 */
    @ApiModelProperty(value = "卫星全称")
    private String satelliteName;

    /** 传感器全称 */
    @ApiModelProperty(value = "传感器全称")
    private String sensorName;

    /**  数据类型  定制化 */
    @ApiModelProperty(value = " 数据类型  定制化")
    private String dataType;

    /** 是否在每日最新里显示：0 不显示，1 显示 */
    @ApiModelProperty(value = "是否在每日最新里显示：0 不显示，1 显示")
    private Integer dailyDisplay;

    /** 每日最新的排序 */
    @ApiModelProperty(value = "每日最新的排序")
    private Integer dailySort;

    /** 销售状态 0下架 1上架 */
    @ApiModelProperty(value = "销售状态 0下架 1上架")
    private Integer isSell;

    /** 首页排序 */
    @ApiModelProperty(value = "首页排序")
    private Integer indexSort;

    /** 是否要首页显示：0否，1是 */
    @ApiModelProperty(value = "是否要首页显示：0否，1是")
    private Integer isIndex;

    /** 是否已删除 0--未删除；1--已删除 */
    @ApiModelProperty(value = "是否已删除 0--未删除；1--已删除")
    private Integer isDel;

    /* This code was generated by TableGo tools, mark 1 end. */

    /* This code was generated by TableGo tools, mark 2 begin. */
}