package com.upyuns.platform.rs.datacenter.entity;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import tk.mybatis.mapper.annotation.KeySql;

import javax.persistence.*;
import java.math.BigDecimal;

@Data
@Table(name = "rscp_image_data_input_fail")
@ApiModel(description = "影像数据表(分表空间)")
public class RscpImageDataInputFail implements java.io.Serializable {
    /** 版本号 */
    private static final long serialVersionUID = -3916940633746492673L;

    /* This code was generated by TableGo tools, mark 1 begin. */

    /** 标识id */
    @Id
    @KeySql(useGeneratedKeys = true)
    @Column(name = "id",insertable = false)
    @ApiModelProperty(value = "标识id")
    private Long id;

    /** 编号 */
    @ApiModelProperty(value = "编号")
    private String dataNo;

    /** 名称 */
    @ApiModelProperty(value = "名称")
    private String name;

    /** 数据范围数据 */
    @ApiModelProperty(value = "数据范围数据")
    private String range;

    /** 缩略图存储路径 */
    @ApiModelProperty(value = "缩略图存储路径")
    private String thumbnailPath;

    /** 显示名称 */
    @ApiModelProperty(value = "显示名称")
    private String displayName;

    /** 分辨率[数组] */
    @ApiModelProperty(value = "分辨率[数组]")
    private String imageResolution;

    /** 光谱 */
    @ApiModelProperty(value = "光谱")
    private String imageSpectrumType;

    /** 光谱名称 */
    @ApiModelProperty(value = "光谱名称")
    private String imageSpectrumTypeDisplay;

    /** 影像存储地址目录 */
    @ApiModelProperty(value = "影像存储地址目录")
    private String imageFilePath;

    /** 中心点 */
    @ApiModelProperty(value = "中心点")
    private String imageCenterPoint;

    /** 投影 */
    @ApiModelProperty(value = "投影")
    private String imageProjection;

    /** 卫星 */
    @ApiModelProperty(value = "卫星")
    private String imageSatelliteType;

    /** 卫星名称 */
    @ApiModelProperty(value = "卫星名称")
    private String imageSatelliteTypeDisplay;

    /** 拍摄时间 */
    @ApiModelProperty(value = "拍摄时间")
    private String imageTakeTime;

    /** 云量 */
    @ApiModelProperty(value = "云量")
    private BigDecimal imageCloudage;

    /** 传感器类型 */
    @ApiModelProperty(value = "传感器类型")
    private String imageSensorType;

    /** 包含那几个文件名称[数组]1个xml 1个jpg */
    @ApiModelProperty(value = "包含那几个文件名称[数组]1个xml 1个jpg")
    private String files;

    /** 是否存在数据,0不存在 1已存在 */
    @ApiModelProperty(value = "是否存在数据,0不存在 1已存在")
    private Integer imageIsSave;

    /** 景id */
    @ApiModelProperty(value = "景id")
    private String imageSceneId;

    /** 产品格式 GEOTIFF 、 TIFF */
    @ApiModelProperty(value = "产品格式 GEOTIFF 、 TIFF")
    private String imageProductFormat;

    /** 产品时间 */
    @ApiModelProperty(value = "产品时间")
    private String imageProductTime;

    /** sat行号 */
    @ApiModelProperty(value = "sat行号")
    private String imageSatPath;

    /** sat列号 */
    @ApiModelProperty(value = "sat列号")
    private String imageSatRow;

    /** 影像开始时间 */
    @ApiModelProperty(value = "影像开始时间")
    private String imageStartTime;

    /** 影像结束时间 */
    @ApiModelProperty(value = "影像结束时间")
    private String imageEndTime;

    /** 影像中间时间 */
    @ApiModelProperty(value = "影像中间时间")
    private String imageCenterTime;

    /** 影像宽度 */
    @ApiModelProperty(value = "影像宽度")
    private String imageWidthInPixels;

    /** 卫星平台平均俯仰角 */
    @ApiModelProperty(value = "卫星平台平均俯仰角")
    private String imagePitchSatellitessAngle;

    /** 太阳方位角 */
    @ApiModelProperty(value = "太阳方位角")
    private String imageSolarAzimuth;

    /** 太阳高度角 */
    @ApiModelProperty(value = "太阳高度角")
    private String imageSolarZenith;

    /** 卫星方向角 */
    @ApiModelProperty(value = "卫星方向角")
    private String imageSatelliteAzimuth;

    /** 卫星高度角 */
    @ApiModelProperty(value = "卫星高度角")
    private String imageSatelliteZenith;

    /** 影像高度 */
    @ApiModelProperty(value = "影像高度")
    private String imageHeightInPixels;

    /** 卫星平台平均偏航角 */
    @ApiModelProperty(value = "卫星平台平均偏航角")
    private String imageYawSatelliteAngle;

    /** 传感器id */
    @ApiModelProperty(value = "传感器id")
    private String imageSensorId;

    /** 状态：10展示，20不展示 */
    @ApiModelProperty(value = "状态：10展示，20不展示")
    private Integer recordStatus;

    /** 创建时间 */
    @ApiModelProperty(value = "创建时间")
    private String crtTime;

    /** 更新时间 */
    @ApiModelProperty(value = "更新时间")
    private String updTime;

    /* This code was generated by TableGo tools, mark 1 end. */

    /* This code was generated by TableGo tools, mark 2 begin. */

    /**
     * 获取标识id
     * 
     * @return 标识id
     */
    public Long getId() {
        return this.id;
    }

    /**
     * 设置标识id
     * 
     * @param id
     *          标识id
     */
    public void setId(Long id) {
        this.id = id;
    }

    /**
     * 获取编号
     * 
     * @return 编号
     */
    public String getDataNo() {
        return this.dataNo;
    }

    /**
     * 设置编号
     * 
     * @param dataNo
     *          编号
     */
    public void setDataNo(String dataNo) {
        this.dataNo = dataNo;
    }

    /**
     * 获取名称
     * 
     * @return 名称
     */
    public String getName() {
        return this.name;
    }

    /**
     * 设置名称
     * 
     * @param name
     *          名称
     */
    public void setName(String name) {
        this.name = name;
    }

    /**
     * 获取数据范围数据
     * 
     * @return 数据范围数据
     */
    public String getRange() {
        return this.range;
    }

    /**
     * 设置数据范围数据
     * 
     * @param range
     *          数据范围数据
     */
    public void setRange(String range) {
        this.range = range;
    }

    /**
     * 获取缩略图存储路径
     * 
     * @return 缩略图存储路径
     */
    public String getThumbnailPath() {
        return this.thumbnailPath;
    }

    /**
     * 设置缩略图存储路径
     * 
     * @param thumbnailPath
     *          缩略图存储路径
     */
    public void setThumbnailPath(String thumbnailPath) {
        this.thumbnailPath = thumbnailPath;
    }

    /**
     * 获取显示名称
     * 
     * @return 显示名称
     */
    public String getDisplayName() {
        return this.displayName;
    }

    /**
     * 设置显示名称
     * 
     * @param displayName
     *          显示名称
     */
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    /**
     * 获取分辨率[数组]
     * 
     * @return 分辨率[数组]
     */
    public String getImageResolution() {
        return this.imageResolution;
    }

    /**
     * 设置分辨率[数组]
     * 
     * @param imageResolution
     *          分辨率[数组]
     */
    public void setImageResolution(String imageResolution) {
        this.imageResolution = imageResolution;
    }

    /**
     * 获取光谱
     * 
     * @return 光谱
     */
    public String getImageSpectrumType() {
        return this.imageSpectrumType;
    }

    /**
     * 设置光谱
     * 
     * @param imageSpectrumType
     *          光谱
     */
    public void setImageSpectrumType(String imageSpectrumType) {
        this.imageSpectrumType = imageSpectrumType;
    }

    /**
     * 获取光谱名称
     * 
     * @return 光谱名称
     */
    public String getImageSpectrumTypeDisplay() {
        return this.imageSpectrumTypeDisplay;
    }

    /**
     * 设置光谱名称
     * 
     * @param imageSpectrumTypeDisplay
     *          光谱名称
     */
    public void setImageSpectrumTypeDisplay(String imageSpectrumTypeDisplay) {
        this.imageSpectrumTypeDisplay = imageSpectrumTypeDisplay;
    }

    /**
     * 获取影像存储地址目录
     * 
     * @return 影像存储地址目录
     */
    public String getImageFilePath() {
        return this.imageFilePath;
    }

    /**
     * 设置影像存储地址目录
     * 
     * @param imageFilePath
     *          影像存储地址目录
     */
    public void setImageFilePath(String imageFilePath) {
        this.imageFilePath = imageFilePath;
    }

    /**
     * 获取中心点
     * 
     * @return 中心点
     */
    public String getImageCenterPoint() {
        return this.imageCenterPoint;
    }

    /**
     * 设置中心点
     * 
     * @param imageCenterPoint
     *          中心点
     */
    public void setImageCenterPoint(String imageCenterPoint) {
        this.imageCenterPoint = imageCenterPoint;
    }

    /**
     * 获取投影
     * 
     * @return 投影
     */
    public String getImageProjection() {
        return this.imageProjection;
    }

    /**
     * 设置投影
     * 
     * @param imageProjection
     *          投影
     */
    public void setImageProjection(String imageProjection) {
        this.imageProjection = imageProjection;
    }

    /**
     * 获取卫星
     * 
     * @return 卫星
     */
    public String getImageSatelliteType() {
        return this.imageSatelliteType;
    }

    /**
     * 设置卫星
     * 
     * @param imageSatelliteType
     *          卫星
     */
    public void setImageSatelliteType(String imageSatelliteType) {
        this.imageSatelliteType = imageSatelliteType;
    }

    /**
     * 获取卫星名称
     * 
     * @return 卫星名称
     */
    public String getImageSatelliteTypeDisplay() {
        return this.imageSatelliteTypeDisplay;
    }

    /**
     * 设置卫星名称
     * 
     * @param imageSatelliteTypeDisplay
     *          卫星名称
     */
    public void setImageSatelliteTypeDisplay(String imageSatelliteTypeDisplay) {
        this.imageSatelliteTypeDisplay = imageSatelliteTypeDisplay;
    }

    /**
     * 获取拍摄时间
     * 
     * @return 拍摄时间
     */
    public String getImageTakeTime() {
        return this.imageTakeTime;
    }

    /**
     * 设置拍摄时间
     * 
     * @param imageTakeTime
     *          拍摄时间
     */
    public void setImageTakeTime(String imageTakeTime) {
        this.imageTakeTime = imageTakeTime;
    }

    /**
     * 获取云量
     * 
     * @return 云量
     */
    public BigDecimal getImageCloudage() {
        return this.imageCloudage;
    }

    /**
     * 设置云量
     * 
     * @param imageCloudage
     *          云量
     */
    public void setImageCloudage(BigDecimal imageCloudage) {
        this.imageCloudage = imageCloudage;
    }

    /**
     * 获取传感器类型
     * 
     * @return 传感器类型
     */
    public String getImageSensorType() {
        return this.imageSensorType;
    }

    /**
     * 设置传感器类型
     * 
     * @param imageSensorType
     *          传感器类型
     */
    public void setImageSensorType(String imageSensorType) {
        this.imageSensorType = imageSensorType;
    }

    /**
     * 获取包含那几个文件名称[数组]1个xml 1个jpg
     * 
     * @return 包含那几个文件名称[数组]1个xml 1个jpg
     */
    public String getFiles() {
        return this.files;
    }

    /**
     * 设置包含那几个文件名称[数组]1个xml 1个jpg
     * 
     * @param files
     *          包含那几个文件名称[数组]1个xml 1个jpg
     */
    public void setFiles(String files) {
        this.files = files;
    }

    /**
     * 获取是否存在数据,0不存在 1已存在
     * 
     * @return 是否存在数据
     */
    public Integer getImageIsSave() {
        return this.imageIsSave;
    }

    /**
     * 设置是否存在数据,0不存在 1已存在
     * 
     * @param imageIsSave
     *          是否存在数据
     */
    public void setImageIsSave(Integer imageIsSave) {
        this.imageIsSave = imageIsSave;
    }

    /**
     * 获取景id
     * 
     * @return 景id
     */
    public String getImageSceneId() {
        return this.imageSceneId;
    }

    /**
     * 设置景id
     * 
     * @param imageSceneId
     *          景id
     */
    public void setImageSceneId(String imageSceneId) {
        this.imageSceneId = imageSceneId;
    }

    /**
     * 获取产品格式 GEOTIFF 、 TIFF
     * 
     * @return 产品格式 GEOTIFF 、 TIFF
     */
    public String getImageProductFormat() {
        return this.imageProductFormat;
    }

    /**
     * 设置产品格式 GEOTIFF 、 TIFF
     * 
     * @param imageProductFormat
     *          产品格式 GEOTIFF 、 TIFF
     */
    public void setImageProductFormat(String imageProductFormat) {
        this.imageProductFormat = imageProductFormat;
    }

    /**
     * 获取产品时间
     * 
     * @return 产品时间
     */
    public String getImageProductTime() {
        return this.imageProductTime;
    }

    /**
     * 设置产品时间
     * 
     * @param imageProductTime
     *          产品时间
     */
    public void setImageProductTime(String imageProductTime) {
        this.imageProductTime = imageProductTime;
    }

    /**
     * 获取sat行号
     * 
     * @return sat行号
     */
    public String getImageSatPath() {
        return this.imageSatPath;
    }

    /**
     * 设置sat行号
     * 
     * @param imageSatPath
     *          sat行号
     */
    public void setImageSatPath(String imageSatPath) {
        this.imageSatPath = imageSatPath;
    }

    /**
     * 获取sat列号
     * 
     * @return sat列号
     */
    public String getImageSatRow() {
        return this.imageSatRow;
    }

    /**
     * 设置sat列号
     * 
     * @param imageSatRow
     *          sat列号
     */
    public void setImageSatRow(String imageSatRow) {
        this.imageSatRow = imageSatRow;
    }

    /**
     * 获取影像开始时间
     * 
     * @return 影像开始时间
     */
    public String getImageStartTime() {
        return this.imageStartTime;
    }

    /**
     * 设置影像开始时间
     * 
     * @param imageStartTime
     *          影像开始时间
     */
    public void setImageStartTime(String imageStartTime) {
        this.imageStartTime = imageStartTime;
    }

    /**
     * 获取影像结束时间
     * 
     * @return 影像结束时间
     */
    public String getImageEndTime() {
        return this.imageEndTime;
    }

    /**
     * 设置影像结束时间
     * 
     * @param imageEndTime
     *          影像结束时间
     */
    public void setImageEndTime(String imageEndTime) {
        this.imageEndTime = imageEndTime;
    }

    /**
     * 获取影像中间时间
     * 
     * @return 影像中间时间
     */
    public String getImageCenterTime() {
        return this.imageCenterTime;
    }

    /**
     * 设置影像中间时间
     * 
     * @param imageCenterTime
     *          影像中间时间
     */
    public void setImageCenterTime(String imageCenterTime) {
        this.imageCenterTime = imageCenterTime;
    }

    /**
     * 获取影像宽度
     * 
     * @return 影像宽度
     */
    public String getImageWidthInPixels() {
        return this.imageWidthInPixels;
    }

    /**
     * 设置影像宽度
     * 
     * @param imageWidthInPixels
     *          影像宽度
     */
    public void setImageWidthInPixels(String imageWidthInPixels) {
        this.imageWidthInPixels = imageWidthInPixels;
    }

    /**
     * 获取卫星平台平均俯仰角
     * 
     * @return 卫星平台平均俯仰角
     */
    public String getImagePitchSatellitessAngle() {
        return this.imagePitchSatellitessAngle;
    }

    /**
     * 设置卫星平台平均俯仰角
     * 
     * @param imagePitchSatellitessAngle
     *          卫星平台平均俯仰角
     */
    public void setImagePitchSatellitessAngle(String imagePitchSatellitessAngle) {
        this.imagePitchSatellitessAngle = imagePitchSatellitessAngle;
    }

    /**
     * 获取太阳方位角
     * 
     * @return 太阳方位角
     */
    public String getImageSolarAzimuth() {
        return this.imageSolarAzimuth;
    }

    /**
     * 设置太阳方位角
     * 
     * @param imageSolarAzimuth
     *          太阳方位角
     */
    public void setImageSolarAzimuth(String imageSolarAzimuth) {
        this.imageSolarAzimuth = imageSolarAzimuth;
    }

    /**
     * 获取太阳高度角
     * 
     * @return 太阳高度角
     */
    public String getImageSolarZenith() {
        return this.imageSolarZenith;
    }

    /**
     * 设置太阳高度角
     * 
     * @param imageSolarZenith
     *          太阳高度角
     */
    public void setImageSolarZenith(String imageSolarZenith) {
        this.imageSolarZenith = imageSolarZenith;
    }

    /**
     * 获取卫星方向角
     * 
     * @return 卫星方向角
     */
    public String getImageSatelliteAzimuth() {
        return this.imageSatelliteAzimuth;
    }

    /**
     * 设置卫星方向角
     * 
     * @param imageSatelliteAzimuth
     *          卫星方向角
     */
    public void setImageSatelliteAzimuth(String imageSatelliteAzimuth) {
        this.imageSatelliteAzimuth = imageSatelliteAzimuth;
    }

    /**
     * 获取卫星高度角
     * 
     * @return 卫星高度角
     */
    public String getImageSatelliteZenith() {
        return this.imageSatelliteZenith;
    }

    /**
     * 设置卫星高度角
     * 
     * @param imageSatelliteZenith
     *          卫星高度角
     */
    public void setImageSatelliteZenith(String imageSatelliteZenith) {
        this.imageSatelliteZenith = imageSatelliteZenith;
    }

    /**
     * 获取影像高度
     * 
     * @return 影像高度
     */
    public String getImageHeightInPixels() {
        return this.imageHeightInPixels;
    }

    /**
     * 设置影像高度
     * 
     * @param imageHeightInPixels
     *          影像高度
     */
    public void setImageHeightInPixels(String imageHeightInPixels) {
        this.imageHeightInPixels = imageHeightInPixels;
    }

    /**
     * 获取卫星平台平均偏航角
     * 
     * @return 卫星平台平均偏航角
     */
    public String getImageYawSatelliteAngle() {
        return this.imageYawSatelliteAngle;
    }

    /**
     * 设置卫星平台平均偏航角
     * 
     * @param imageYawSatelliteAngle
     *          卫星平台平均偏航角
     */
    public void setImageYawSatelliteAngle(String imageYawSatelliteAngle) {
        this.imageYawSatelliteAngle = imageYawSatelliteAngle;
    }

    /**
     * 获取传感器id
     * 
     * @return 传感器id
     */
    public String getImageSensorId() {
        return this.imageSensorId;
    }

    /**
     * 设置传感器id
     * 
     * @param imageSensorId
     *          传感器id
     */
    public void setImageSensorId(String imageSensorId) {
        this.imageSensorId = imageSensorId;
    }

    /**
     * 获取状态：10展示，20不展示
     * 
     * @return 状态：10展示
     */
    public Integer getRecordStatus() {
        return this.recordStatus;
    }

    /**
     * 设置状态：10展示，20不展示
     * 
     * @param recordStatus
     *          状态：10展示
     */
    public void setRecordStatus(Integer recordStatus) {
        this.recordStatus = recordStatus;
    }

    /**
     * 获取创建时间
     * 
     * @return 创建时间
     */
    public String getCrtTime() {
        return this.crtTime;
    }

    /**
     * 设置创建时间
     * 
     * @param crtTime
     *          创建时间
     */
    public void setCrtTime(String crtTime) {
        this.crtTime = crtTime;
    }

    /**
     * 获取更新时间
     * 
     * @return 更新时间
     */
    public String getUpdTime() {
        return this.updTime;
    }

    /**
     * 设置更新时间
     * 
     * @param updTime
     *          更新时间
     */
    public void setUpdTime(String updTime) {
        this.updTime = updTime;
    }

    /* This code was generated by TableGo tools, mark 2 end. */
}