package com.github.wxiaoqi.security.admin.rest;

import com.github.wxiaoqi.security.admin.biz.UserProfileDisplayBiz;
import com.github.wxiaoqi.security.admin.vo.UserProfileDisplayVo;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import lombok.RequiredArgsConstructor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author libin
 * @version 1.0
 * @description
 * @data 2019/12/26 10:11
 */
@RestController
@RequestMapping("/large_screen/app/unauth")
@RequiredArgsConstructor(onConstructor = @__(@Autowired))
public class LargeScreenDisplayUserController {
    private final UserProfileDisplayBiz userProfileDisplayBiz;

    /**
     * 用户概况
     *
     * @return
     */
    @GetMapping("/user_profile_display")
    public ObjectRestResponse<UserProfileDisplayVo> findUserProfileData() {
        UserProfileDisplayVo userProfileDisplayVo = userProfileDisplayBiz.findUserProfileData();
        return ObjectRestResponse.succ(userProfileDisplayVo);
    }

}
