package com.github.wxiaoqi.security.admin.vo;

import com.alibaba.fastjson.annotation.JSONField;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

/**
 * @author libin
 * @version 1.0
 * @description
 * @data 2019/7/12 11:02
 */
@Data
public class SellingWalletVo {

    /**
     * 用户名
     */
    private String username;

    /**
     * 昵称
     */
    private String nickName;

    /**
     * 用户头像
     */
    private String headUrl;


    @ApiModelProperty(value = "商品数量")
    private Integer goodNumber;

    @ApiModelProperty(value = "商品标题")
    private String title;

    @ApiModelProperty(value = "图片")
    private String img;

    @ApiModelProperty(value = "售价")
    private BigDecimal price;

    @ApiModelProperty(value = "创建时间", hidden = true)
    private Long crtTime;

    @ApiModelProperty(value = "更新时间", hidden = true)
    private Long updTime;

    @ApiModelProperty("是否入账：0-未入账；1-已入账")
    private Integer waiting;

    @ApiModelProperty("'类别：0-正；1-负(退款时)")
    private Integer status;

    @JSONField(serialize = false)
    private Integer sourceId;

    @JSONField(serialize = false)
    private BigDecimal commissionnm;
    /**
     * 所获佣金
     */
    private BigDecimal commission;

    /**
     * 订单状态
     */
    private Integer sellerStatus;
    /**
     * 订单文案
     */
    private String statusText;
    /**
     * 是否显示 默认false
     */
    private Boolean isShow;
}
