package com.github.wxiaoqi.security.admin.feign.dto;

import com.github.wxiaoqi.security.admin.entity.User;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

@Data
public class UserDTO extends User {
    public List<Integer> dataZone2List() {
        return str2List(getDataZone());
    }

    public List<Integer> dataCompany2List() {
        return str2List(getDataCompany());
    }

    private List<Integer> str2List(String str) {
        if(StringUtils.isNotBlank(str)) {
            return Arrays.asList(str.split(",")).stream().map(s -> Integer.valueOf(s)).collect(Collectors.toList());
        }else {
            return new ArrayList<Integer>();
        }
    }

}