package com.github.wxiaoqi.security.admin.dto;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @author libin
 * @version 1.0
 * @description
 * @data 2019/10/21 10:23
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class UserSellingWaterAdminDTO implements Serializable {
    private static final long serialVersionUID = 1L;
    private Integer id;

    private String userName;

    private String sourceName;

    private String phone;

    @ApiModelProperty(value = "订单id")
    private Integer orderId;

    @ApiModelProperty(value = "订单号")
    private String orderNo;

    @ApiModelProperty(value = "1-租车；2-旅游；3-会员；4-营地")
    private Integer orderType;

    @ApiModelProperty(value = "商品数量")
    private Integer goodNumber;

    @ApiModelProperty(value = "类型 1=>一级上线提成")
    private Integer type;

    @ApiModelProperty(value = "类别：0-正；1-负")
    private Integer status;

    @ApiModelProperty(value = "商品标题")
    private String title;

    @ApiModelProperty(value = "售价")
    private BigDecimal price;

    @ApiModelProperty(value = "提成百分比")
    private Integer extract;

    @ApiModelProperty(value = "是否入账：0-未入账；1-已入账")
    private Integer waiting;

    @ApiModelProperty(value = "创建时间", hidden = true )
    private Long crtTime;

    private BigDecimal commission;

}
