package com.github.wxiaoqi.security.admin.dto;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.Set;

/**
 * 用户信息表
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class AppUserManageDTO {
    /**
     * 每页条数
     */
    private Integer limit;

    /**
     * 当前页数
     */
    private Integer page;

    /**
     * 手机号
     */
    private String mobile;

    /**
     * 注册终端
     */
    private Integer channel;

    /**
     * 会员等级(-1为全不会员)
     */
    private Integer memberLevel;

    /**
     * 注册时间(开始)
     */
    private Long registrationTimeBegin;

    /**
     * 注册时间(结束)
     */

    private Long registrationTimeEnd;

    /**
     * 身份标识 0：除普通用户外  1:与1相反
     */
    private Integer postionState;

    /**
     * 用户来源:0-自来,1-用户邀请
     */
    private Integer source;

    /**
     * 公司所在的城市数组
     */
    private Set<Integer> citySet;

    /**
     * 用户id
     */
    private Integer userId;

	/**
	 * 真实姓名
	 */
	private String realName;

    /**
     * 状态：0-启用，1-禁用
     */
	private Integer status;

	private String nickname;
//    /**
//     * 接收前台时间范围
//     */
//    private String[] registrationDate;


}
