package com.github.wxiaoqi.security.admin.bo;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.apache.commons.collections4.CollectionUtils;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/**
 * @author libin
 * @version 1.0
 * @description
 * @data 2019/11/26 17:09
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class StaffStatisticsBo {

    private static final long serialVersionUID = 1L;
    private String name ;
    private Integer userId;
    private List<String> companyNames;
    private List<Integer> compnayIds;
    private List<String> postionNames;
    private List<Integer> postionIds;
    private String phone;
    private BigDecimal sellAmount = BigDecimal.ZERO;
    private BigDecimal royaltyAmount = BigDecimal.ZERO;
    private Integer memberOrderNum = 0;
    private BigDecimal memberAmount = BigDecimal.ZERO;
    private Integer rentVehicleOrderNum = 0;
    private BigDecimal rentVehicleAmount = BigDecimal.ZERO;
    private Integer travelOrderNum = 0;
    private BigDecimal travelAmount = BigDecimal.ZERO;

    public List<String> getCompanyNames() {
        return CollectionUtils.isEmpty(companyNames)? new ArrayList<>():companyNames;
    }

    public List<Integer> getCompnayIds() {
        return CollectionUtils.isEmpty(compnayIds)?new ArrayList<>():compnayIds;
    }

    public List<String> getPostionNames() {
        return CollectionUtils.isEmpty(postionNames)?new ArrayList<>() :postionNames;
    }

    public List<Integer> getPostionIds() {
        return CollectionUtils.isEmpty(postionIds)?new ArrayList<>():postionIds;
    }

    public BigDecimal getSellAmount() {
        return rentVehicleAmount.add(travelAmount).add(memberAmount);
    }
}
