package com.github.wxiaoqi.security.common.vo;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.convert.Convert;
import com.github.pagehelper.ISelect;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.github.wxiaoqi.security.common.util.Query;
import lombok.Data;

import java.util.List;

@Data
public  class PageDataVO<T> {
    /**
     * 符合条件记录总数
     */
    private Long totalCount;

    private Integer totalPage;

    private Integer pageNum;

    private Integer pageSize;

    /**
     * 实际数据
     */
    private List<T> data;

    public static <M> PageDataVO<M> pageInfo(PageInfo<M> pageInfo){
        PageDataVO<M> pageDataVo = new PageDataVO<>();
        pageDataVo.setTotalCount(pageInfo.getTotal());
        pageDataVo.setData(pageInfo.getList());
        pageDataVo.setPageNum(pageInfo.getPageNum());
        pageDataVo.setTotalPage(pageInfo.getPages());
        pageDataVo.setPageSize(pageInfo.getSize());
        return pageDataVo;
    }

//    public static <M> PageDataVO<M> pageInfo(Integer page, Integer limit, List<M> list){
//        PageInfo<M> pageInfo = new PageInfo<M>(list);
//        return PageDataVO.pageInfo(pageInfo);
//    }

    public static <M> PageDataVO<M> pageInfo(Integer page, Integer limit, ISelect select){
        return PageDataVO.pageInfo(PageHelper.startPage(page, limit).doSelectPageInfo(select));
    }

    public static <M> PageDataVO<M> pageInfo(Query query, ISelect select){
        return PageDataVO.pageInfo(PageHelper.startPage(query.getPage(), query.getLimit()).doSelectPageInfo(select));
    }

    public static <M> PageDataVO<M> pageInfo(Query query, ISelect select, Class classz){
        PageDataVO<M> pageDataVo = pageInfo(query, select);
        if(CollUtil.isNotEmpty(pageDataVo.getData()) && pageDataVo.getData().get(0).getClass() != classz) {
            pageDataVo.setData(Convert.toList(classz, pageDataVo.getData()));
        }
        return pageDataVo;
    }
}
