package com.github.wxiaoqi.security.auth.controller.feign;

import com.alibaba.fastjson.JSONObject;
import com.github.wxiaoqi.security.api.vo.user.AppUserInfo;
import com.github.wxiaoqi.security.auth.common.util.jwt.JWTInfo;
import com.github.wxiaoqi.security.auth.feign.IUserService;
import com.github.wxiaoqi.security.auth.service.AuthService;
import com.github.wxiaoqi.security.auth.util.user.JwtAuthenticationRequest;
import com.github.wxiaoqi.security.auth.util.user.JwtTokenUtil;
import com.github.wxiaoqi.security.common.constant.RequestTypeConstants;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.util.process.ResultCode;
import com.github.wxiaoqi.security.common.util.result.JsonResultUtil;
import io.swagger.annotations.Api;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import java.util.Map;

@Api(tags = "用户登录")
@RestController
@RequestMapping("/fegin/jwt/app/unauth")
@Slf4j
public class FeginAuthController {
    @Value("${jwt.token-header}")
    private String tokenHeader;

    @Autowired
    @Qualifier("baseAuthService")
    private AuthService authService;

    @Autowired
    @Qualifier("appAuthService")
    private AuthService appAuthService;

    @Autowired
    IUserService iUserService;

    @Autowired
    private JwtTokenUtil jwtTokenUtil;

    @RequestMapping(value = "/app/token", method = RequestMethod.GET)
    public ObjectRestResponse<String> createAuthenticationToken(String username) throws Exception {
        ObjectRestResponse<AppUserInfo> restResponse = iUserService.getUserByUsername(username);
        if(null != restResponse.getData()) {
            AppUserInfo appUserInfo = restResponse.getData();
            if(null != appUserInfo) {
                String token = jwtTokenUtil.generateToken(new JWTInfo(appUserInfo.getUsername(), appUserInfo.getId() + "", appUserInfo.getName(),
                        RequestTypeConstants.APP));
                return ObjectRestResponse.succ(token);
            }
        }
        return ObjectRestResponse.succ();
    }

}
