/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.csp.sentinel.dashboard.inmem;

import com.taobao.csp.sentinel.dashboard.datasource.entity.MetricEntity;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.springframework.stereotype.Component;

@Component
public class InMemMetricStore {
    public static final long MAX_METRIC_LIVE_TIME_MS = 300000L;
    private Map<String, Map<String, LinkedHashMap<Long, MetricEntity>>> allMetrics = new ConcurrentHashMap();

    public synchronized void saveAll(Iterable<MetricEntity> metrics) {
        if (metrics == null) {
            return;
        }
        for (MetricEntity entity : metrics) {
            this.allMetrics.computeIfAbsent(entity.getApp(), e -> new HashMap(16)).computeIfAbsent(entity.getResource(), e -> new /* Unavailable Anonymous Inner Class!! */).put(entity.getTimestamp().getTime(), entity);
        }
    }

    public synchronized List<MetricEntity> queryByAppAndResouce(String app, String resource, long startTime, long endTime) {
        ArrayList<MetricEntity> results = new ArrayList<MetricEntity>();
        Map resouceMap = (Map)this.allMetrics.get(app);
        if (resouceMap == null) {
            return results;
        }
        LinkedHashMap metricsMap = (LinkedHashMap)resouceMap.get(resource);
        if (metricsMap == null) {
            return results;
        }
        for (Map.Entry entry : metricsMap.entrySet()) {
            if ((Long)entry.getKey() < startTime || (Long)entry.getKey() > endTime) continue;
            results.add((MetricEntity)entry.getValue());
        }
        return results;
    }

    public synchronized List<String> findResourcesOfApp(String app) {
        ArrayList<String> results = new ArrayList<String>();
        Map resourceMap = (Map)this.allMetrics.get(app);
        if (resourceMap == null) {
            return results;
        }
        long minTimeMs = System.currentTimeMillis() - 60000L;
        HashMap resourceCount = new HashMap(32);
        for (Map.Entry resourceMetrics : resourceMap.entrySet()) {
            for (Map.Entry metrics : ((LinkedHashMap)resourceMetrics.getValue()).entrySet()) {
                if ((Long)metrics.getKey() < minTimeMs) continue;
                MetricEntity newEntity = (MetricEntity)metrics.getValue();
                if (resourceCount.containsKey(resourceMetrics.getKey())) {
                    MetricEntity oldEntity = (MetricEntity)resourceCount.get(resourceMetrics.getKey());
                    oldEntity.addPassedQps(newEntity.getPassedQps());
                    oldEntity.addRtAndSuccessQps(newEntity.getRt(), newEntity.getSuccessQps());
                    oldEntity.addBlockedQps(newEntity.getBlockedQps());
                    oldEntity.addException(newEntity.getException());
                    oldEntity.addCount(1);
                    continue;
                }
                resourceCount.put(resourceMetrics.getKey(), MetricEntity.copyOf((MetricEntity)newEntity));
            }
        }
        return resourceCount.entrySet().stream().sorted((o1, o2) -> {
            MetricEntity e1 = (MetricEntity)o1.getValue();
            MetricEntity e2 = (MetricEntity)o2.getValue();
            int t = e2.getBlockedQps().compareTo(e1.getBlockedQps());
            if (t != 0) {
                return t;
            }
            return e2.getPassedQps().compareTo(e1.getPassedQps());
        }).map(e -> (String)e.getKey()).collect(Collectors.toList());
    }
}

