package com.upyuns.platform.rs.website.controller.web;

import com.github.wxiaoqi.security.auth.client.annotation.IgnoreUserToken;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.rest.BaseController;
import com.upyuns.platform.rs.website.biz.ImageInformationBiz;
import com.upyuns.platform.rs.website.dto.ImageInformationDto;
import com.upyuns.platform.rs.website.entity.ImageInformation;
import org.springframework.web.bind.annotation.*;

@RestController
@RequestMapping("imageInformation/web")
public class ImageInformationWebController extends BaseController<ImageInformationBiz,ImageInformation> {

	@GetMapping(value = "/app/unauth/getAll")
	@IgnoreUserToken
	public ObjectRestResponse getAll(ImageInformationDto imageInformationDto) {
		return ObjectRestResponse.succ(baseBiz.selectList(imageInformationDto));
	}

	@GetMapping(value = "/app/unauth/getDetail/{id}")
	@IgnoreUserToken
	public ObjectRestResponse getDetail(@PathVariable Integer id) {
		return ObjectRestResponse.succ(baseBiz.selectById(id));
	}
}