package com.upyuns.platform.rs.website.biz;

import org.springframework.stereotype.Service;

import com.upyuns.platform.rs.website.entity.OrderItem;
import com.upyuns.platform.rs.website.mapper.OrderItemMapper;
import com.github.wxiaoqi.security.common.biz.BaseBiz;
import tk.mybatis.mapper.entity.Example;

import java.util.List;

/**
 * 订单商品信息
 *
 * @author jiaoruizhen
 * @email jiaoruizhen@126.com
 * @date 2020-12-03 13:29:23
 */
@Service
public class OrderItemBiz extends BaseBiz<OrderItemMapper,OrderItem> {

	/**
	 * 根据订单ID查询所有订单商品
	 * @param orderIdList
	 * @return
	 */
	public List<OrderItem> getAllByOrderId(List<Long> orderIdList) {
		Example example = new Example(OrderItem.class);
		example.createCriteria().andIn("orderId", orderIdList);
		return mapper.selectByExample(example);
	}

	/**
	 * 根据订单ID
	 * @param OrderId
	 * @return
	 */
	public List<OrderItem> getByOrderId(Long OrderId) {
		Example example = new Example(OrderItem.class);
		example.createCriteria().andEqualTo("orderId", OrderId);
		return mapper.selectByExample(example);
	}

}