package com.upyuns.platform.rs.datacenter.rest;

import cn.hutool.core.util.StrUtil;
import com.github.wxiaoqi.security.auth.client.annotation.IgnoreUserToken;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.rest.BaseController;
import com.github.wxiaoqi.security.common.util.Query;
import com.github.wxiaoqi.security.common.vo.PageDataVO;
import com.upyuns.platform.rs.datacenter.biz.RscpImageStatisticsBiz;
import com.upyuns.platform.rs.datacenter.biz.RscpResolutionBiz;
import com.upyuns.platform.rs.datacenter.entity.RscpImageStatistics;
import com.upyuns.platform.rs.datacenter.entity.RscpResolution;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;
import java.util.Map;

import static com.github.wxiaoqi.security.common.constant.CommonConstants.SYS_FALSE;
import static com.github.wxiaoqi.security.common.constant.CommonConstants.SYS_TRUE;

@RestController
@RequestMapping("/web/statistics")
public class RscpImageStatisticsController extends BaseController<RscpImageStatisticsBiz, RscpImageStatistics> {

//    @Override
//    public ObjectRestResponse<PageDataVO<RscpImageStatistics>> pages(Map<String, Object> params) {
//        //查询列表数据
//        Query query = new Query(params);
//        return ObjectRestResponse.succ(baseBiz.selectByQueryLogicPage(query));
//    }

    @RequestMapping(value = "/app/unauth/all", method = RequestMethod.GET)
    @IgnoreUserToken
    public ObjectRestResponse unauthQuery(RscpImageStatistics entity) {

        List<RscpImageStatistics> list = baseBiz.selectByWeekend(w -> {
            w.andEqualTo(RscpImageStatistics::getIsDel, SYS_FALSE);
            if(null != entity.getType()) {
                w.andEqualTo(RscpImageStatistics::getType, entity.getType());
            }
            if(null != entity.getDateyear()) {
                w.andEqualTo(RscpImageStatistics::getDateyear, entity.getDateyear());
            }

            return w;
        }, " sort asc");

        return ObjectRestResponse.succ(list);
    }
}