package com.upyuns.platform.rs.datacenter.mapper;

import com.upyuns.platform.rs.datacenter.entity.RscpAreaImageTotal;
import com.upyuns.platform.rs.datacenter.entity.RscpImageDataTotal;
import com.upyuns.platform.rs.datacenter.rest.RscpImageDataTotalController;
import org.apache.ibatis.annotations.Update;
import tk.mybatis.mapper.common.Mapper;

import java.math.BigDecimal;
import java.util.List;

public interface RscpAreaImageTotalMapper extends Mapper<RscpAreaImageTotal> {
    public List<RscpAreaImageTotal> queryDataList(RscpImageDataTotalController.QueryDTO dto);

    @Update("update rscp_area_image_total set range = st_GeomFromText('MULTIPOLYGON(((${leftTopLon} ${leftTopLat}  ,${leftBottomLon} ${leftBottomLat}  , ${rightBottomLon} ${rightBottomLat}  ,${rightTopLon} ${rightTopLat},   ${leftTopLon} ${leftTopLat})))',4326) where id = #{id}")
    Integer updateGeom(BigDecimal leftTopLon, BigDecimal leftTopLat, BigDecimal leftBottomLon, BigDecimal leftBottomLat, BigDecimal rightBottomLon, BigDecimal rightBottomLat, BigDecimal rightTopLon, BigDecimal rightTopLat, String id);


}