package com.upyuns.platform.rs.datacenter.job;

import cn.hutool.core.date.DateField;
import cn.hutool.core.date.DateUtil;
import com.upyuns.platform.rs.datacenter.biz.RscpImageDataTotalBiz;
import com.upyuns.platform.rs.datacenter.biz.RscpImagePriceBiz;
import com.upyuns.platform.rs.datacenter.biz.RscpImageStatisticsBiz;
import com.upyuns.platform.rs.datacenter.entity.RscpImageDataTotal;
import com.upyuns.platform.rs.datacenter.entity.RscpImagePrice;
import com.upyuns.platform.rs.datacenter.entity.RscpImageStatistics;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;

import java.util.List;
import java.util.stream.Collectors;

import static com.github.wxiaoqi.security.common.constant.CommonConstants.SYS_FALSE;
import static com.github.wxiaoqi.security.common.constant.CommonConstants.SYS_TRUE;

@Configuration      //1.主要用于标记配置类，兼备Component的效果。
@EnableScheduling   // 2.开启定时任务
@Slf4j
public class CoverScheduleTask {

    @Autowired
    RscpImagePriceBiz rscpImagePriceBiz;

    @Autowired
    RscpImageDataTotalBiz rscpImageDataTotalBiz;

    @Autowired
    RscpImageStatisticsBiz rscpImageStatisticsBiz;

    //定时按月份统计覆盖率
    //@Scheduled(cron = "0 0 2 * * ?")
    //或直接指定时间间隔，例如：5秒
    //@Scheduled(fixedRate=5000)
    public void configureTasks() {


    }

    private void insertPart(int sort, String satelliteType, Integer countAll, int type) {
       insertPart(sort, satelliteType, countAll, type, null);
    }

    private void insertPart(int sort, String satelliteType, Integer countAll, int type, String year) {
        RscpImageStatistics rscpImageStatisticsAll = new RscpImageStatistics();
        rscpImageStatisticsAll.setName(satelliteType);
        rscpImageStatisticsAll.setNum(countAll);
        rscpImageStatisticsAll.setSort(sort);
        rscpImageStatisticsAll.setType(type);
        rscpImageStatisticsAll.setDateyear(Integer.valueOf(year));
        rscpImageStatisticsBiz.insertSelective(rscpImageStatisticsAll);
    }

    private void yearInsert(String year, String satelliteType, Integer sort) {
        Integer countYear = rscpImageDataTotalBiz.selectCountByWeekend(w-> {
            w.andEqualTo(RscpImageDataTotal::getImageSatelliteType, satelliteType);
            w.andEqualTo(RscpImageDataTotal::getImageYear, year);
            return w;
        });

        //添加
        insertPart(sort, satelliteType, countYear, RscpImageStatistics.TYPE_YEAR, year);
    }
}