package com.upyuns.platform.rs.datacenter.biz;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONUtil;
import com.github.wxiaoqi.security.common.biz.BaseBiz;
import com.github.wxiaoqi.security.common.exception.BaseException;
import com.upyuns.platform.rs.datacenter.entity.RscpAreaImageTotal;
import com.upyuns.platform.rs.datacenter.entity.RscpAreaInfo;
import com.upyuns.platform.rs.datacenter.entity.RscpImageDataTotal;
import com.upyuns.platform.rs.datacenter.entity.RscpImageInputLog;
import com.upyuns.platform.rs.datacenter.mapper.RscpAreaInfoMapper;
import com.upyuns.platform.rs.datacenter.mapper.RscpImageDataTotalMapper;
import com.upyuns.platform.rs.datacenter.pojo.ImageTotalInputDTO;
import com.upyuns.platform.rs.datacenter.pojo.imagedata.BgImageQueryDTO;
import com.upyuns.platform.rs.datacenter.rest.RscpImageDataTotalController;
import com.upyuns.platform.rs.datacenter.vo.ImageInputVO;
import lombok.extern.slf4j.Slf4j;
import org.springframework.amqp.support.AmqpHeaders;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

import static com.github.wxiaoqi.security.common.util.process.ResultCode.PARAM_ILLEGAL_CODE;
import static com.upyuns.platform.rs.datacenter.constant.DataConstant.THUMBNAIL_PATH;

@Service
@Slf4j
public class RscpImageDataTotalBiz extends BaseBiz<RscpImageDataTotalMapper, RscpImageDataTotal> {

    @Autowired
    RscpImageInputLogBiz rscpImageInputLogBiz;

    @Autowired
    RscpImageDataTotalBiz rscpImageDataTotalBiz;

    @Autowired
    RscpAreaImageTotalBiz rscpAreaImageTotalBiz;

    @Autowired
    RscpAreaInfoMapper rscpAreaInfoMapper;

    public void inStorage(ImageInputVO ii) {
        ExecutorService executorService = Executors.newCachedThreadPool();
        executorService.execute(() -> {
            ii.setThumbnailPath(ii.getThumbnailPath().replace(THUMBNAIL_PATH, ""));
            RscpImageDataTotal rscpImageDataTotal= null;
            try {
                //查询数据是否存在
                rscpImageDataTotal = rscpImageDataTotalBiz.selectOne(new RscpImageDataTotal(){{
                    setName(ii.getName());
                }});

                ImageTotalInputDTO imageTotalInputDTO = BeanUtil.toBean(ii, ImageTotalInputDTO.class);

                if(null != rscpImageDataTotal) {
                    //更新
                    BeanUtil.copyProperties(ii, rscpImageDataTotal);
//                    rscpImageDataTotal.setImageResolution(null);
                    rscpImageDataTotalBiz.updateSelectiveById(rscpImageDataTotal);
                }else {
                    rscpImageDataTotal = BeanUtil.toBean(ii, RscpImageDataTotal.class);
                    rscpImageDataTotalBiz.insertSelective(rscpImageDataTotal);
                    RscpImageDataTotal finalRscpImageDataTotal = rscpImageDataTotal;
                    rscpImageDataTotalBiz.updateSelectiveById(new RscpImageDataTotal(){{
                        setId(finalRscpImageDataTotal.getId());
                        setDataId(finalRscpImageDataTotal.getId());
                    }});
                }
                imageTotalInputDTO.setId(rscpImageDataTotal.getId());
                //更新几何范围
                updateGeom(imageTotalInputDTO);

                //更新地区信息
                rscpAreaImageTotalBiz.inStorageAreaDeal(imageTotalInputDTO);

            }catch (Exception e) {
                log.error(e.getMessage(), e);
                if(null != ii.getLogId()) {
                    rscpImageInputLogBiz.updateSelectiveById(new RscpImageInputLog(){{
                        setId(ii.getLogId());
                        setStatus(STATU_FAIL);
                        setResult(e.getMessage());
                    }});
                }
                throw e;
            }finally {
                if(null != ii.getLogId()) {
                    if(null != rscpImageDataTotal) {
                        String message = rscpImageDataTotal.getId()+ "";
                        rscpImageInputLogBiz.updateSelectiveById(new RscpImageInputLog(){{
                            setId(ii.getLogId());
                            setStatus(STATU_SUCC);
                            setResult(message);
                            //setResult(JSONUtil.toJsonStr(CollUtil.newArrayList(resultDTO)));
                        }});

                    }else {
                        rscpImageInputLogBiz.updateSelectiveById(new RscpImageInputLog(){{
                            setId(ii.getLogId());
                            setStatus(STATU_FAIL);
                        }});
                    }
                }
            }
        });
    }

    public List<RscpImageDataTotal> queryDataList(RscpImageDataTotalController.QueryDTO dto) {
        return mapper.queryDataList(dto);
    }

    public List<RscpImageDataTotal> bgQueryDataList(BgImageQueryDTO dto) {
        return mapper.bgQueryDataList(dto);
    }


    public RscpImageDataTotal queryDataList(Long id) {
        List<RscpImageDataTotal> list2 = mapper.queryDataById(id);
        if(list2.size() > 0) {
            RscpImageDataTotal rscpImageDataTotal = list2.get(0);
            return list2.get(0);
        }
        throw new BaseException("数据不存在", PARAM_ILLEGAL_CODE);
    }

    public List<RscpAreaImageTotal> queryDataAreaList(RscpImageDataTotalController.QueryDTO dto) {
        List<RscpImageDataTotal> list = mapper.queryDataList(dto);
        List<RscpAreaImageTotal> list2 = CollUtil.newArrayList();
        if(CollUtil.isNotEmpty(list)) {
//            for(RscpImageDataTotal ridt : list) {
//                RscpAreaImageTotal rait = BeanUtil.toBean(ridt, RscpAreaImageTotal.class);
//                rait.setBeginTime(ridt.getImageTakeTime());
//                rait.setImageResolution(rait.getImageResolution().replace("[","{").replace("]", "}"));
//                list2.add(rait);
//            }
            list2 = Convert.toList(RscpAreaImageTotal.class, list);
        }
        return list2;
    }

    public String getBinNameByGId(ImageTotalInputDTO dto){
//        String param = StrUtil.format("MULTIPOLYGON((({} {}  ,{} {}  , {} {}  ,#{rightTopLon} #{rightTopLat},   #{leftTopLon} #{leftTopLat})))");
        return mapper.getBinNameByGId(dto.getLeftTopLon(), dto.getLeftTopLat(), dto.getLeftBottomLon(), dto.getLeftBottomLat(), dto.getRightBottomLon(), dto.getRightBottomLat(), dto.getRightTopLon(), dto.getRightTopLat());
    }

    public Integer updateGeom(ImageTotalInputDTO dto){
        return mapper.updateGeom(dto.getLeftTopLon(), dto.getLeftTopLat(), dto.getLeftBottomLon(), dto.getLeftBottomLat(), dto.getRightBottomLon(), dto.getRightBottomLat(), dto.getRightTopLon(), dto.getRightTopLat(), dto.getId());
    }

    public String geoJsonByRange(String rangeMeta){
        return mapper.geoJsonByRange(rangeMeta);
    }

    public void aaa(ImageInputVO vo) {
        ImageTotalInputDTO dto = BeanUtil.toBean(vo, ImageTotalInputDTO.class);
//        dto.setRange(getBinNameByGId(dto));
        List<RscpAreaInfo> imageAreaInfoList = rscpAreaInfoMapper.getIntersectAreaInfo(dto.getLeftTopLon(), dto.getLeftTopLat(), dto.getLeftBottomLon(), dto.getLeftBottomLat(), dto.getRightBottomLon(), dto.getRightBottomLat(), dto.getRightTopLon(), dto.getRightTopLat());
    }
}
