package com.upyuns.platform.rs.datacenter.fegin;

import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.vo.PageDataVO;
import com.upyuns.platform.rs.datacenter.entity.RscpAreaInfo;
import com.upyuns.platform.rs.datacenter.entity.RscpImageDataTotal;
import com.upyuns.platform.rs.datacenter.pojo.ImageDataVO;
import com.upyuns.platform.rs.datacenter.pojo.ImagePageFeginDTO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;
import java.util.Map;


/**
 * ${DESCRIPTION}
 *
 * @author wanghaobin
 * @create 2017-06-21 8:11
 */
@FeignClient(value = "rs-datacenter", contextId = "datacenter-base")
public interface DatacenterFeign {

    @RequestMapping(value = "/web/areaInfo/app/unauth/Fegin/queryByCodeFegin", method = RequestMethod.GET)
    public ObjectRestResponse<RscpAreaInfo> queryByCode(@RequestParam("areaCode") String areaCode);

    @RequestMapping(value = "/web/imageData/app/unauth/Fegin/queryByIds", method = RequestMethod.GET)
    public ObjectRestResponse<List<ImageDataVO>> queryByIds(@RequestParam("ids") String ids);

    @RequestMapping(value = "/web/imageData/app/unauth/Fegin/pageBykey", method = RequestMethod.POST)
    public ObjectRestResponse<PageDataVO<ImageDataVO>> pageBykey(@RequestBody ImagePageFeginDTO dto);

    @RequestMapping(value = "/web/gtdata/app/unauth/register", method = RequestMethod.GET)
    public ObjectRestResponse<Map<String, String>> dataRegister(@RequestParam("id") Integer id);
}
