import Vue from 'vue';
import Router from 'vue-router';

const _import = require('./_import_' + process.env.NODE_ENV);
// in development env not use Lazy Loading,because Lazy Loading large page will cause webpack hot update too slow.so only in production use Lazy Loading

Vue.use(Router);

/* layout */
import Layout from '../views/layout/Layout';

/**
 * icon : the icon show in the sidebar
 * hidden : if `hidden:true` will not show in the sidebar
 * redirect : if `redirect:noredirect` will no redirct in the levelbar
 * noDropdown : if `noDropdown:true` will has no submenu
 * meta : { role: ['admin'] }  will control the page role
 **/
export const constantRouterMap = [{
    path: '/login',
    component: _import('login/index'),
    hidden: true
  },
  {
    path: '/authredirect',
    component: _import('login/authredirect'),
    hidden: true
  },
  {
    path: '/404',
    component: _import('error/404'),
    hidden: true
  },
  {
    path: '/401',
    component: _import('error/401'),
    hidden: true
  },
  {
    path: '/',
    component: Layout,
    redirect: '/index',
    name: '首页',
    hidden: true,
    children: [{
      path: 'index',
      component: _import('index/index')
    }]
  },
  {
    path: '*',
    hidden: true,
    component: _import('error/404')
  }
]

export default new Router({
  // mode: 'history', //后端支持可开
  scrollBehavior: () => ({
    y: 0
  }),
  routes: constantRouterMap
});

export const asyncRouterMap = [{
    path: '/baseManager',
    component: Layout,
    name: '基础配置管理',
    icon: 'setting',
    authority: 'baseManager',
    children: [{
      path: 'userManager',
      icon: 'fa-user',
      component: _import('admin/user/index'),
      name: '后台用户管理',
      authority: 'userManager'
    }, {
      path: 'appUserManager',
      icon: 'fa-user',
      component: _import('admin/appUser/index'),
      name: 'App用户管理',
      authority: 'appUserManager'
    }, {
      path: 'menuManager',
      icon: 'category',
      component: _import('admin/menu/index'),
      name: '菜单管理',
      authority: 'menuManager'
    }, {
      path: 'groupManager',
      icon: 'group_fill',
      component: _import('admin/group/index'),
      name: '角色权限管理',
      authority: 'groupManager'
    }, {
      path: 'groupTypeManager',
      icon: 'fa-users',
      component: _import('admin/groupType/index'),
      name: '角色类型管理',
      authority: 'groupTypeManager'
    }, {
      path: 'gateLogManager',
      icon: 'viewlist',
      component: _import('admin/gateLog/index'),
      name: '操作日志管理',
      authority: 'gateLogManager'
    }]
  },
  {
    path: '/industryApplication',
    component: Layout,
    name: '基础配置管理',
    icon: 'setting',
    authority: 'industryApplication',
    children: [{
      path: 'applicationList',
      component: _import('webSiteManagement/industryApplication/applicationList/index'),
      name: '应用详情',
      authority: 'applicationList'
    }, {
      path: 'applicationCate',
      component: _import('webSiteManagement/industryApplication/applicationCate/index'),
      name: '类别管理',
      authority: 'applicationCate'
    }, {
      path: 'transactionProtection',
      component: _import('webSiteManagement/industryApplication/transactionProtection/index'),
      name: '交易保障',
      authority: 'transactionProtection'
    }]
  },
  {
    path: '/userManagement',
    component: Layout,
    name: '用户管理',
    icon: 'setting',
    authority: 'userManagement',
    children: [{
      path: 'userList',
      component: _import('userManagement/index'),
      name: '用户列表',
      authority: 'applicationList'
    }]
  },
  {
    path: '/orderManagement',
    component: Layout,
    name: '订单管理',
    icon: 'setting',
    authority: 'orderManagement',
    children: [{
      path: 'orderList',
      component: _import('orderManagement/orderList/index'),
      name: '订单列表',
      authority: 'orderList'
    }, {
      path: 'demandList',
      component: _import('orderManagement/demandList/index'),
      name: '定制需求列表',
      authority: 'demandList'
    }]
  },
  {
    path: '/archiveDataManagement',
    component: Layout,
    name: '存档数据管理',
    icon: 'setting',
    authority: 'archiveDataManagement',
    children: [{
      path: 'satelliteManagement',
      component: _import('archiveDataManagement/satelliteManagement/index'),
      name: '卫星传感器价格管理',
      authority: 'satelliteManagement'
    }, {
      path: 'dataList',
      component: _import('archiveDataManagement/dataList/index'),
      name: '已入库卫星数据管理',
      authority: 'dataList'
    }, {
      path: 'resolutionManger',
      component: _import('archiveDataManagement/resolutionManger/index'),
      name: '分辨率管理',
      authority: 'resolutionManger'
    }]
  },
  {
    path: '/webSiteManagement',
    component: Layout,
    name: 'web站点管理',
    icon: 'setting',
    authority: 'webSiteManagement',
    children: [{
      path: 'nebulaDynamics',
      component: _import('webSiteManagement/newsCategory/index'),
      name: '星云动态',
      authority: 'nebulaDynamics',
      children: [{
        path: 'newsCreator',
        component: _import('webSiteManagement/newsCategory/newsCreator/index'),
        name: '创建资讯文章',
        authority: 'newsCreator'
      }]
    }, {
      path: 'bannerSetting',
      component: _import('webSiteManagement/bannerSetting/index'),
      name: 'banner管理',
      authority: 'bannerSetting'
    }, {
      path: 'satelliteIntroduction',
      component: _import('webSiteManagement/satelliteIntroduction/index'),
      name: '卫星介绍',
      authority: 'satelliteIntroduction'
    }, {
      path: 'imageLibrary',
      component: _import('webSiteManagement/imageLibrary/index'),
      name: '影像图库',
      authority: 'imageLibrary'
    }, {
      path: 'aboutUs',
      component: _import('webSiteManagement/aboutUs/index'),
      name: '关于我们',
      authority: 'aboutUs'
    }]

},
{
  path: '/contactService',
  component: Layout,
  name: '联系我们',
  icon: 'setting',
  authority: 'contactService',
  children: [{
    path: 'contact',
    component: _import('contactService/contact'),
    name: '联系客服',
    authority: 'contact'
  },
  {
    path: 'feedback',
    component: _import('contactService/feedback'),
    name: '意见反馈',
    authority: 'feedback'
  },
  {
    path: 'complaint',
    component: _import('contactService/complaint'),
    name: '意见反馈',
    authority: 'complaint'
  }]
}];
