import fetch from 'utils/fetch';

// 卫星列表
export function getSatelliteData(obj) {
  return fetch({
    url: '/api/datacenter/bg/imagePrice/pages',
    method: 'get',
    params: obj
  });
}
// 已入库数据列表
export function getDateList(obj) {
  return fetch({
    url: '/api/datacenter/bg/imageData/bgPages',
    method: 'get',
    params: obj
  });
}

// 分辨率列表
export function getResolutionData(obj) {
  return fetch({
    url: '/api/datacenter/bg/resolution/pages',
    method: 'get',
    params: obj
  });
}


// 全部分辨率列表
export function getResolutionAll(obj) {
  return fetch({
    url: '/api/datacenter/web/resolution/app/unauth/all',
    method: 'get',
    params: obj
  });
}

// 全部卫星列表
export function getimagePriceAll(obj) {
  return fetch({
    url: '/api/datacenter/web/imagePrice/app/unauth/all',
    method: 'get',
    params: obj
  });
}

// 删除分辨率
export function delResolution(obj) {
  return fetch({
    url: '/api/datacenter/bg/resolution/del?id=' + obj.id,
    method: 'DELETE'
    // data: obj
  });
}
// 删除卫星传感器
export function delimagePrice(obj) {
  return fetch({
    url: '/api/datacenter/bg/imagePrice/del?id=' + obj.id,
    method: 'DELETE'
    // data: obj
  });
}

// 添加分辨率
export function addResolution(obj) {
  return fetch({
    url: '/api/datacenter/bg/resolution',
    method: 'post',
    data: obj
  });
}

// 修改分辨率
export function updateResolution(obj) {
  return fetch({
    url: '/api/datacenter/bg/resolution/' + obj.id,
    method: 'PUT',
    data: obj
  });
}

// 添加卫星传感器
export function addimagePrice(obj) {
  return fetch({
    url: '/api/datacenter/bg/imagePrice',
    method: 'post',
    data: obj
  });
}
// 修改卫星传感器
export function updateimagePrice(obj) {
  return fetch({
    url: '/api/datacenter/bg/imagePrice/' + obj.id,
    method: 'PUT',
    data: obj
  });
}
