/*
 * @Author: your name
 * @Date: 2020-12-04 14:20:54
 * @LastEditTime: 2020-12-04 14:21:11
 * @LastEditors: Please set LastEditors
 * @Description: In User Settings Edit
 * @FilePath: \rs-cloud-platform-ui\src\utils\loadBMap.js
 */
/**
 * 动态加载百度地图api函数
 * @param {String} ak  百度地图AK，必传
 */
export default function loadBMap(ak) {
    return new Promise(function(resolve, reject) {
      if (typeof window.BMap !== 'undefined') {
        resolve(window.BMap)
        return true
      }
      window.onBMapCallback = function() {
        resolve(window.BMap)
      }
      let script = document.createElement('script')
      script.type = 'text/javascript'
      script.src =
        'http://api.map.baidu.com/api?v=3.0&ak=' + ak + '&callback=onBMapCallback'
      script.onerror = reject
      document.head.appendChild(script)
    })
  }
  