import fetch from 'utils/fetch';

/**
 * 用户列表
 */
export function appUsersManageList(query) {
  return fetch({
    url: '/api/admin/appUsersManage/findAll',
    method: 'post',
    data: query
  });
}

/**
 * 用户禁用、启用
 */
export function updateStatus(query) {
  return fetch({
    url: '/api/admin/appUsersManage/updateStatus',
    method: 'post',
    data: query
  });
}

/**
 * 发票列表
 */
export function userInvoiceList(query) {
  return fetch({
    url: '/api/website/userInvoice/getList',
    method: 'get',
    data: query
  });
}

/**
 * 用户地址列表
 */
export function userAddressList(query) {
  return fetch({
    url: '/api/website/userAddress/getList',
    method: 'get',
    data: query
  });
}

/**
 * 联系客服-意见反馈-订单投诉列表
 */
export function feedbackInfoList(query) {
  return fetch({
    url: '/api/website/feedbackInfo/getAll',
    method: 'get',
    params: query
  });
}
