import fetch from 'utils/fetch';

export function getAllGroupTypes() {
  return fetch({
    url: '/api/admin/groupType/all',
    method: 'get'
  });
}

export function fetchTree(query) {
  return fetch({
    url: '/api/admin/group/tree',
    method: 'get',
    params: query
  });
}


export function addObj(obj) {
  return fetch({
    url: '/api/admin/group',
    method: 'post',
    data: obj
  });
}

export function getObj(id) {
  return fetch({
    url: '/api/admin/group/' + id,
    method: 'get'
  });
}

export function delObj(id) {
  return fetch({
    url: '/api/admin/group/' + id,
    method: 'delete'
  });
}

export function putObj(id, obj) {
  return fetch({
    url: '/api/admin/group/' + id,
    method: 'put',
    data: obj
  });
}

export function getUsers(id) {
  return fetch({
    url: '/api/admin/group/' + id + '/user',
    method: 'get'
  });
}

export function modifyUsers(id, data) {
  return fetch({
    url: '/api/admin/group/' + id + '/user',
    method: 'put',
    params: data
  });
}


export function removeElementAuthority(id, data) {
  return fetch({
    url: '/api/admin/group/' + id + '/authority/element/remove',
    method: 'put',
    params: data
  });
}

export function addElementAuthority(id, data) {
  return fetch({
    url: '/api/admin/group/' + id + '/authority/element/add',
    method: 'put',
    params: data
  });
}

export function getElementAuthority(id) {
  return fetch({
    url: '/api/admin/group/' + id + '/authority/element',
    method: 'get'
  });
}

export function modifyMenuAuthority(id, data) {
  return fetch({
    url: '/api/admin/group/' + id + '/authority/menu',
    method: 'put',
    params: data
  });
}

/**
 * 权限角色分配权限
 */
export function modifyMenuAndBtnAuthority(id, data) {
  return fetch({
    url: '/api/admin/group/V2/' + id + '/authority/menu',
    method: 'put',
    params: data
  });
}


export function getMenuAuthority(id) {
  return fetch({
    url: '/api/admin/group/' + id + '/authority/menu',
    method: 'get'
  });
}

/**
 *
 * @param id
 */
export function getCurrentGroups() {
  return fetch({
    url: '/api/admin/current/groups',
    method: 'get'
  });
}

/**
 *
 * @param id
 */
export function getUserGroups(id) {
  return fetch({
    url: '/api/admin/user/' + id + '/group',
    method: 'get'
  });
}

export function getAppUserGroups(id) {
  return fetch({
    url: '/api/admin/app/user/groups/' + id,
    method: 'get'
  });
}

export function getGroups() {
  return fetch({
    url: '/api/admin/group/getGroups',
    method: 'get'
  });
}

/**
 * 角色列表-不分页
 */
export function listAll() {
  return fetch({
    url: '/api/admin/group/list_all',
    method: 'get'
  });
}

