//单选组
let radioGroup = {
  isDel: {
    0: '否',
    1: '是'
  },
  status: {
    1: '启用',
    2: '禁用',
  },
  indexShow: {
    1: '展示',
    2: '不展示',
  },
  jumpType: {
    0: '不跳转',
    1: '商品详情页',
    2: '店铺首页',
  }
}

//banner表单项
export const banner = {
  init: () => ({
    title: "",
    cover: "",
    rank: "",
    url: "",
    status: 1,
    jumpType: 0,
    jumpId: '',
    id: null
  }),
  rules: {
    title: [
      { required: true, message: '请输入标题', trigger: 'blur' }
    ],
    cover: [
      { required: true, message: '请上传封面图片', trigger: 'change' }
    ],
    rank: [
      { required: true, message: '请设置0-10000，数值越大排序越靠前', trigger: 'blur' }
    ],
    status: [
      { required: true, message: '请选择是否启用', trigger: 'change' }
    ]
  },
  formInfo: {
    title: { label: "标题" },
    cover: { label: "封面地址", type: 'file' },
    rank: { label: "排序", placeholder: '请设置0-10000，数值越大排序越靠前'},
    url: { label: "链接到", type: 'custom' },
    status: { label: "状态", type: 'radio', radioArr: radioGroup.status },//是否启用，1、启用，2、禁用
  }
}

//卫星介绍表单项
export const satelliteIntroduction = {
  init: () => ({
    name: "",//标题名称
    resolution: "",//分辨率
    coverImg: "",//封面图
    iconImg: "",//图标
    content: "",//详细内容
    rank: '',//排序
    status: 1//是否启用
  }),
  rules: {
    name: [
      { required: true, message: '请输入卫星名称', trigger: 'blur' }
    ],
    resolution: [
      { required: true, message: '请输入分辨率', trigger: 'blur' }
    ],
    rank: [
      { required: true, message: '请设置0-10000，数值越大排序越靠前', trigger: 'blur' }
    ],
    coverImg: [
      { required: true, message: '请输入封面图链接', trigger: 'blur' }
    ],
    iconImg: [
      { required: true, message: '请输入图标链接', trigger: 'blur' }
    ],
    content: [
      { required: true, message: '请输入详细内容', trigger: 'blur' }
    ]
  },
  formInfo: {
    name: { label: "卫星名称" },
    resolution: { label: "分辨率" },
    coverImg: { label: "封面图", type: 'file'},
    iconImg: { label: "图标", type: 'file'},
    rank: { label: "排序" },
    content: { label: "详细内容", type: 'kindEditor'},
  }
}



// //影像图库
// export const imageLibrary = {
//   init: () => ({
//     name: "",//标题名称
//     coverImg: "",//封面图
//     detailImg: "",//详情图
//     //产品分类
//     //影像分类
//     //文件格式
//     //分辨率
//     //拍摄地点
//     //拍摄时间
//     //可否商用
//     //是否水印

//   }),
//   rules: {
//     name: [
//       { required: true, message: '请输入卫星名称', trigger: 'blur' }
//     ],
//     resolution: [
//       { required: true, message: '请输入分辨率', trigger: 'blur' }
//     ],
//     rank: [
//       { required: true, message: '请设置0-10000，数值越大排序越靠前', trigger: 'blur' }
//     ],
//     coverImg: [
//       { required: true, message: '请输入封面图链接', trigger: 'blur' }
//     ],
//     iconImg: [
//       { required: true, message: '请输入图标链接', trigger: 'blur' }
//     ],
//     content: [
//       { required: true, message: '请输入详细内容', trigger: 'blur' }
//     ]
//   },
//   formInfo: {
//     name: { label: "卫星名称" },
//     resolution: { label: "分辨率" },
//     coverImg: { label: "封面图", type: 'file'},
//     iconImg: { label: "图标", type: 'file'},
//     rank: { label: "排序" },
//     content: { label: "详细内容", type: 'kindEditor'},
//   }
// }
