/*
 * @Author: Jenkins
 * @Date: 2020-12-02 09:18:01
 * @LastEditTime: 2020-12-08 10:57:37
 * @LastEditors: Please set LastEditors
 * @Description: 星云动态页请求接口
 * @FilePath: \rs-cloud-platform-ui\src\api\wsmanagement\newsCategory\index.js
 */

import fetch from 'utils/fetch';


/**
 * 获取所有新闻类型
 */
export function getAllnewsType() {
  return fetch({
    url: '/api/website/newsType/app/unauth/getAll',
    method: 'get'
  });
}

/**
 * 分页获取新闻类型
 * @param {Object} obj
 */
export function getListnewsType(obj) {
  return fetch({
    // url: '/api/website/newsType/getList',
    url: '/api/website/newsType/getList',
    method: 'get',
    params: obj
  });
}

/**
 * 添加或更新新闻类型
 * @param {Object} obj
 */
export function addUpdateNewsType(obj) {
  return fetch({
    url: '/api/website/newsType/addUpdate',
    method: 'post',
    data: obj
  });
}

/**
 * 分页查询新闻资讯
 * @param {Object} obj
 */
export function getListNewsInfo(obj) {
  return fetch({
    url: '/api/website/newsInfo/getList',
    method: 'get',
    params: obj
  });
}

/**
 * 添加或更新新闻资讯
 * @param {Object} obj
 */
export function addUpdateNewsInfo(obj) {
  return fetch({
    url: '/api/website/newsInfo/addUpdate',
    method: 'post',
    data: obj
  });
}

/**
 * 上传图片
 * @param {Object} obj
 */
export function uploadFile(obj) {
  return fetch({
    url: '/api/universal/file/app/unauth/admin/upload',
    method: 'post',
    data: obj
  });
}

/**
 * 上传图片加水印
 * @param {Object} obj
 */
export function uploadFileshuiy(obj) {
  return fetch({
    url: '/api/universal/file/admin/uploadDispose?size=24&alpha=0.3&degree=-20',
    method: 'post',
    data: obj
  });
}
