import fetch from 'utils/fetch';
// 获取影像图库列表
export function page(query) {
  return fetch({
    url: '/api/website/imageImgStorage/getList',
    method: 'get',
    params: query
  });
}
// 新增或修改影像图库
export function update(query) {
  return fetch({
    url: '/api/website/imageImgStorage/addUpdate',
    method: 'post',
    data: query
  });
}

// 影像图库上下架
export function updateStatus(query) {
  return fetch({
    url: '/api/website/imageImgStorage/updateStatus',
    method: 'post',
    data: query
  });
}
// 获取所有相似图像
export function getAll(query) {
  return fetch({
    url: '/api/website/imageImgStorage/getList',
    method: 'get',
    params: query
  });
}
// /api/website/imageImgStorage/getDetail/{id}
export function getDetail(query) {
  return fetch({
    url: `/api/website/imageImgStorage/getDetail/${query}`,
    method: 'get'
  });
}

// /api/website/imageImgStorage/getDetail/{id}
export function imgmoreUpdata(query) {
  return fetch({
    url: '/api/website/imageImgStorage/updateBatch',
    method: 'post',
    data: query
  });
}
