import fetch from 'utils/fetch';

/**
 * 后台用户管理列表
 * @param query
 */
export function page(query) {
  return fetch({
    url: '/api/admin/user/page',
    method: 'get',
    params: query
  });
}

/**
 * 添加后台账号
 * @param obj
 */
export function addObj(obj) {
  console.log(obj);
  return fetch({
    url: '/api/admin/user',
    method: 'post',
    data: obj
  });
}

export function getObj(id) {
  return fetch({
    url: '/api/admin/user/' + id,
    method: 'get'
  })
}

/**
 * 后台账号删除
 * @param id
 */
export function delObj(id) {
  return fetch({
    url: '/api/admin/user/' + id,
    method: 'delete'
  })
}

/**
 * 修改后台用户
 * @param id
 * @param obj
 */
export function putObj(id, obj) {
  return fetch({
    url: '/api/admin/user/' + id,
    method: 'put',
    data: obj
  })
}

/**
 * 根据所属公司id查询--所属门店数据
 */
export function companyListById(query) {
  return fetch({
    url: 'vehicle/branchCompany/app/unauth/listByIds',
    method: 'post',
    data: query
  })
}
