import fetch from 'utils/fetch';

export function page(query) {
  return fetch({
    url: '/api/admin/group/listPage',
    method: 'get',
    params: query
  });
}

export function addObj(obj) {
  return fetch({
    url: '/api/admin/groupType',
    method: 'post',
    data: obj
  });
}

export function getObj(id) {
  return fetch({
    url: '/api/admin/groupType/' + id,
    method: 'get'
  })
}

export function delObj(id) {
  return fetch({
    url: '/api/admin/groupType/' + id,
    method: 'delete'
  })
}

export function delObj2(id) {
  return fetch({
    url: '/api/admin/group/' + id,
    method: 'delete'
  })
}

export function putObj(id, obj) {
  return fetch({
    url: '/api/admin/groupType/' + id,
    method: 'put',
    data: obj
  })
}

/**
 * 添加权限角色
 */
export function addGroup(query) {
  return fetch({
    url: '/api/admin/group',
    method: 'post',
    data: query
  })
}

/**
 * 基础信息-编辑
 */
export function putGroup(id, query) {
  return fetch({
    url: '/api/admin/group/' + id,
    method: 'put',
    data: query
  })
}
