import {
  formatDate
} from 'utils/dateFormattor';

export function toEast8Date(dateStr) {
  if (typeof dateStr == 'undefined' || JSON.stringify(dateStr) === '{}') {
    return undefined;
  }
  const timezone = 8; // 目标时区时间，东八区
  const offset_GMT = new Date().getTimezoneOffset(); // 本地时间和格林威治的时间差，单位为分钟
  const nowDate = new Date(dateStr).getTime(); // 本地时间距 1970 年 1 月 1 日午夜（GMT 时间）之间的毫秒数
  return new Date(nowDate + offset_GMT * 60 * 1000 + timezone * 60 * 60 * 1000);
}


export function newEast8Date() {
  const timezone = 8; // 目标时区时间，东八区
  const offset_GMT = new Date().getTimezoneOffset(); // 本地时间和格林威治的时间差，单位为分钟
  const nowDate = new Date().getTime(); // 本地时间距 1970 年 1 月 1 日午夜（GMT 时间）之间的毫秒数
  return new Date(nowDate + offset_GMT * 60 * 1000 + timezone * 60 * 60 * 1000);
}


export function deepCopyDate(date) {
  return toEast8Date(formatDate(date, 'yyyy-MM-dd'));
}


export function convertDate2Str(object) {
  const ownPropertyNames = Object.getOwnPropertyNames(object);
  for (const index in ownPropertyNames) {
    const key = ownPropertyNames[index];
    if (Object.prototype.toString.call(object[key]) === '[object Date]') {
      object[key] = formatDate(object[key], 'yyyy-MM-dd hh:mm:ss');
    }
  }
}


export function timestamp2Date(timestamp) {
  let str = timestamp + ''
  if( str.length == 10){
    timestamp = timestamp * 1000
  }
  const date = new Date(timestamp); // 时间戳为10位需*1000，时间戳为13位的话不需乘1000
  return formatDate(date, 'yyyy-MM-dd hh:mm:ss');
}
export function timestamp2DateAuto(timestamp, str) {
  const date = new Date(timestamp); // 时间戳为10位需*1000，时间戳为13位的话不需乘1000
  return formatDate(date, str);
}
/*
  num 获取当天多少天后的日期
*/
export function getTimeByDay(num) {
  const today = new Date().getTime()
  const tempTime = new Date(today + 60 * 60 * 1000 * 24 * num);
  return formatDate(tempTime, 'dd');
}
/*
  num 获取当天多少天后的日期 yyyy-MM-dd hh:mm
*/
export function getymdTimeByDay(num) {
  const today = new Date().getTime()
  const tempTime = new Date(today + 60 * 60 * 1000 * 24 * num);
  return formatDate(tempTime, 'yyyy-MM-dd');
}

/**
 * 获取月份
 * */
export function getMonth(num) {
  const today = new Date().getTime()
  const tempTime = new Date(today + 60 * 60 * 1000 * 24 * num);
  return formatDate(tempTime, 'MM');
}
/**
 * 获取当前月
 * */
export function getCurrentMonth() {
  const today = new Date();
  return formatDate(today, 'MM');
}

/**
 * 获取当前月  yyyy-MM
 * */
export function getCurrentYearMonth() {
  const today = new Date();
  return formatDate(today, 'yyyy-MM');
}

/**
 * 返回yyyy-MM-dd
 * */
export function getYMD_hm(timestamp) {
  const date = new Date(timestamp); // 时间戳为10位需*1000，时间戳为13位的话不需乘1000
  return formatDate(date, 'yyyy-MM-dd hh:mm');
}

/**
 * 返回yyyy-MM-dd
 * */
export function getYMD(timestamp) {
  const date = new Date(timestamp); // 时间戳为10位需*1000，时间戳为13位的话不需乘1000
  return formatDate(date, 'yyyy-MM-dd');
}

export function getYMD_date(date) {
  return formatDate(date, 'yyyy-MM-dd');
}
