import fetch from 'utils/fetch';

// 定制列表
export function getCustomList(obj) {
  return fetch({
    url: '/api/website/customForm/pageList',
    method: 'get',
    params: obj
  });
}
// 订单列表
export function getOrderList(query) {
  return fetch({
    url: 'api/website/orderInfo/getOrderList',
    method: 'get',
    params: query
  });
}
/**
 * 订单发货
 */
export function sendGoods(query) {
  return fetch({
    url: 'api/website/orderInfo/orderSend',
    method: 'post',
    data: query
  });
}

/**
 * 发票发货
 */
export function invoiceSend(query) {
  return fetch({
    url: 'api/website/orderInfo/invoiceSend',
    method: 'post',
    data: query
  });
}
// 定制转订单
export function createOrder(obj) {
  return fetch({
    url: '/api/website/orderInfo/customerToOrderInfo',
    method: 'post',
    data: obj
  });
}

/**
 * 添加定制数据
 */
export function setOrderItem(obj) {
  return fetch({
    url: '/api/website/orderInfo/setOrderItem',
    method: 'post',
    data: obj
  });
}

/**
 * 选择定制数据
 */
export function getItemByType(obj) {
  return fetch({
    url: '/api/website/orderInfo/getItemByType',
    method: 'get',
    params: obj
  });
}

/**
 * 对公支付审核
 */
export function updatePayStatus(obj) {
  return fetch({
    url: '/api/website/orderInfo/updatePayStatus',
    method: 'post',
    data: obj
  });
}

/**
 * 对公支付信息
 */
export function getCompanyInfoByType(query) {
  return fetch({
    url: 'api/website/commonInfo/web/app/unauth/getByType',
    method: 'get',
    params: query
  });
}
