/*
 * @Author: Jenkins
 * @Date: 2020-12-02 09:20:18
 * @LastEditTime: 2020-12-18 10:34:09
 * @LastEditors: Please set LastEditors
 * @Description: 行业应用页请求接口
 * @FilePath: \rs-cloud-platform-ui\src\api\wsmanagement\industryApplication\index.js
 */

import fetch from 'utils/fetch';

/**
 * 获取所有行业应用类型
 * @param {Object} indexShow
 */
export function getAllApplicationType(obj){
    return fetch({
        url: '/api/website/industryApplicationType/app/unauth/getAll',
        method: 'get',
        param: obj
    });
}

/**
 * 分页获取所有行业应用类型
 * @param {Object} obj
 */
export function getListApplicationType(obj){
    return fetch({
        url: '/api/website/industryApplicationType/getList',
        method: 'get',
        params: obj
    });
}

/**
 * 新增或更新行业应用类型
 * @param {Object} obj
 */
export function addUpdateApplicationType(obj){
    return fetch({
        url: '/api/website/industryApplicationType/addUpdate',
        method: 'post',
        data: obj
    });
}

/**
 * 分页获取行业应用信息
 * @param {Object} obj
 */
export function getListApplicationInfo(obj){
    return fetch({
        url: '/api/website/industryApplicationInfo/getList',
        method: 'get',
        params: obj
    });
}

/**
 * 新增或更新行业应用信息
 * @param {Object} obj
 */
export function addUpdateApplicationInfo(obj){
    return fetch({
        url: '/api/website/industryApplicationInfo/addUpdate',
        method: 'post',
        data: obj
    });
}

/**
 * 新增或更新交易保障
 * @param {Object} obj 
 */
export function addUpdateProtection(obj){
    return fetch({
        url: "/api/website/commonInfo/addUpdate",
        method: "post",
        data: obj
    })
}

/**
 * 获取分页的交易保障
 * @param {Object} obj 
 */
export function getListProtections(obj){
    return fetch({
        url: "/api/website/commonInfo/getAll",
        method: "get",
        param: obj
    })
}