package com.xxfc.platform.vehicle.entity;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.persistence.Column;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @author libin
 * @version 1.0
 * @description 车型日历价格
 * @data 2019/10/14 16:32
 */
@Data
@Builder(toBuilder = true)
@NoArgsConstructor
@AllArgsConstructor
@Table(name = "vehicle_model_calendar_price")
public class VehicleModelCalendarPrice implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(generator = "JDBC")
    private Long id;
    /**
     * 日期设置
     */
    @Column(name = "vehicle_model_day")
    private Date vehicleModelDay;
    /**
     * 是否全局设置
     */
    @Column(name = "is_global")
    private Boolean isGlobal;
    /**
     * 车型id
     */
    @Column(name = "vehicle_model_id")
    private Integer vehicleModelId;
    /**
     * 1：倍数 2：绝对值  3：会员价
     */
    private Integer type;
    /**
     * 倍数
     */
    private Double multiple;
    /**
     * 抵扣天数
     */
    @Column(name = "free_days")
    private Integer freeDays;
    /**
     * 绝对值 或会员价
     */
    private BigDecimal price;
    /**
     * 创建时间
     */
    @Column(name = "crt_time")
    private Date crtTime;
    /**
     * 更新时间
     */
    @Column(name = "upd_time")
    private Date updTime;
    /**
     * 创建者id
     */
    @Column(name = "crt_userId")
    private Integer crtUserId;
    /**
     * 更新者id
     */
    @Column(name = "upd_userId")
    private Integer updUserId;

    @Column(name = "is_del")
    private Integer isDel;

    /**
     * 会员等级 1：普通  2：黄金 3：钻石
     */
    private Integer level;
}
