package com.xxfc.platform.vehicle.constant;

import java.util.HashMap;
import java.util.Map;

public enum VehicleCountType {
        RENT_VEHICLE(1, "租车用车"),
        TOUR(2, "旅游用车"),
        INNER(3, "内部用车"),
        ;
        /**
         * 编码
         */
        private Integer code;
        /**
         * 类型描述
         */
        private String desc;

        public static Map<Integer, VehicleCountType> codeAndDesc = new HashMap<Integer, VehicleCountType>();
        //Maps.newHashMap();

        static{
            for(VehicleCountType enumE : VehicleCountType.values()){
                codeAndDesc.put(enumE.getCode(), enumE);
            }
        }

    VehicleCountType(Integer code, String desc){
            this.code=code;
            this.desc=desc;
        }

        public Integer getCode() {
            return code;
        }

        public void setCode(Integer code) {
            this.code = code;
        }

        public String getDesc() {
            return desc;
        }

        public void setDesc(String desc) {
            this.desc = desc;
        }

        public static Boolean exists(Integer code){
            return codeAndDesc.containsKey(code);
        }

        public static VehicleCountType get(Integer code) {
            for(VehicleCountType enumE : VehicleCountType.values()) {
                if (enumE.getCode().equals(code)) {
                    return enumE;
                }
            }
            return null;
        }
}
