package com.xxfc.platform.universal.service.PictureParsing.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.map.MapUtil;
import com.alibaba.fastjson.JSONObject;
import com.github.wxiaoqi.security.common.exception.BaseException;
import com.xxfc.platform.universal.entity.IDCardInformation;
import com.xxfc.platform.universal.service.PictureParsing.UserPictureParsing;
import com.xxfc.platform.universal.utils.CertifHttpUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.util.EntityUtils;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.Map;

/**
 * 调用四川涪擎图片解析接口
 *
 * @author Administrator
 */
@Service
@Slf4j
public class XCFQPictureParsingImpl implements UserPictureParsing {

//    private String appcode = "acea1c8811f748b3a65815f11db357c4";
    private String appcode2 = "ee7710ce92054cae9f6c040f6864e6a7";

    /**
     * 认证相关的数据
     */
    private String host = "https://ocridcards.market.alicloudapi.com";
    private String path = "/idimages";

    private String method = "POST";

    private String dataNam = "result";


    /**
     * 照片解析
     *
     * @param frontImage 正面照片
     * @param backImage  反面照片
     * @return
     */
    @Override
    public IDCardInformation analysis(String frontImage, String backImage) {
        Map<String,String> front = judgeAccordingToAnalyticalData(frontImage, "front");
        if (MapUtils.isEmpty(front)) {
            log.error("正面解析失败,请重新上传");
            throw new BaseException("正面解析失败,请重新上传");
        }

        Map<String,String> back = judgeAccordingToAnalyticalData(backImage, "back");
        if (MapUtils.isEmpty(back)) {
            log.error("反面解析失败,请重新上传");
            throw new BaseException("反面解析失败,请重新上传");
        }

        return new IDCardInformation(
                front.get("address"),
                front.get("birthday"),
                front.get("name"),
                front.get("code"),
                front.get("sex"),
                front.get("nation"),
                back.get("issue"),
                back.get("issueDate"),
                back.get("expiryDate"));
    }

    private Map<String,String> judgeAccordingToAnalyticalData(String imageUrl, String type) {
        String json = imageParse(imageUrl);
        log.info("json:" + json);

        if (StringUtils.isBlank(json)) {
            return null;
        }

        Map reuslt = (Map) JSONObject.parse(json);

        //判断是否调用图片解析的接口是否异常,若果两个次认证都没结果
        if ("front".equals(type)) {
            if (MapUtil.isEmpty(reuslt)
                    || !(reuslt.get("code").equals("1"))
            ) {
                return null;
            }
        }

        if ("back".equals(type)) {
            if (MapUtil.isEmpty(reuslt)
                    || !(reuslt.get("code").equals("2"))
            ) {
                return null;
            }
        }

        Map<String,String> map = (Map) reuslt.get(dataNam);
        log.info("map:" + map);
        if (MapUtils.isNotEmpty(map)) {
            return map;
        }
        return null;
    }


    //身份证照片解析
    private String imageParse(String imageUrl) {
        Map<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", "APPCODE " + appcode2);
        Map<String, String> querys = new HashMap<String, String>();
        Map<String, String> bodys = new HashMap<String, String>();
        bodys.put("image", imageUrl);
        try {
            return callExternalRequest(headers,querys,bodys,1);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
        }
        return null;
    }


    private  String callExternalRequest(Map<String, String> headers,
                                        Map<String, String> querys,
                                        Map<String, String> bodys,
                                        int type) throws Exception {

        HttpResponse response = CertifHttpUtils.doPost(host, path, method, headers, querys, bodys);
        log.info("response:"+response);
        StatusLine statusLine = response.getStatusLine();
        int statusCode = statusLine.getStatusCode();
        /**
         * 状态码: 200 正常；400 URL无效；401 appCode错误； 403 次数用完； 500 API网管错误
         */
        log.info("外部接口响应状态码:"+statusCode);
        //获取response的body

        if (statusCode == 200) {
            return EntityUtils.toString(response.getEntity());
        }

        if (403==statusCode){
                log.error("验证次数已用完");
        }

        return null;
    }

}
