package com.xxfc.platform.universal.constant.enumerate;

import java.util.HashMap;
import java.util.Map;

public enum PayChannelEnum {
    ORDER_CRT(1, "租车"),
    ORDER_CANCEL(2, "旅游"),
    ;
    /**
     * 编码
     */
    private Integer code;
    /**
     * 类型描述
     */
    private String desc;

    private static Map<Integer,String> codeAndDesc = new HashMap<Integer, String>();

    PayChannelEnum(Integer code, String desc){
        this.code=code;
        this.desc=desc;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public static Boolean exists(Integer code){
        return codeAndDesc.containsKey(code);
    }
}
