package com.xxfc.platform.order.rest.background;

import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.vo.PageDataVO;
import com.xxfc.platform.order.biz.StaffStatisticsBiz;
import com.xxfc.platform.order.pojo.dto.StaffStatisticsFindDTO;
import com.xxfc.platform.order.pojo.bo.StaffStatisticsTotalBo;
import com.xxfc.platform.order.pojo.vo.StaffStatisticsVo;
import lombok.RequiredArgsConstructor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * @author libin
 * @version 1.0
 * @description
 * @data 2019/11/25 12:39
 */
@RestController
@RequestMapping("/admin/staff_statistics")
@RequiredArgsConstructor(onConstructor = @__(@Autowired))
public class StaffStatisticsAdminController {

    private final StaffStatisticsBiz staffStatisticsBiz;

    @PostMapping("/total_statistics")
    public ObjectRestResponse<StaffStatisticsTotalBo> staffStatisticsWithTotal(@RequestBody StaffStatisticsFindDTO staffStatisticsFindDTO) {
        StaffStatisticsTotalBo staffStatisticsTotalVo = staffStatisticsBiz.staffStatisticsWithTotal(staffStatisticsFindDTO);
        return ObjectRestResponse.succ(staffStatisticsTotalVo);
    }


    @PostMapping("/page")
    public ObjectRestResponse<PageDataVO<StaffStatisticsVo>> staffStatisticsWithPage(@RequestBody StaffStatisticsFindDTO staffStatisticsFindDTO) {
       PageDataVO<StaffStatisticsVo> pageDataVO =  staffStatisticsBiz.staffStatisticsWithPage(staffStatisticsFindDTO);
        return ObjectRestResponse.succ(pageDataVO);
    }
}
