package com.xxfc.platform.order.rest.background;

import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.vo.PageDataVO;
import com.xxfc.platform.order.biz.CompanyPerformanceBiz;
import com.xxfc.platform.order.pojo.dto.CompanyPerformanceFindDTO;
import com.xxfc.platform.order.bo.CompanyPerformanceBo;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import com.github.wxiaoqi.security.common.exception.BaseException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;

/**
 * @author libin
 * @version 1.0
 * @description 公司业绩查询
 * @data 2019/11/23 14:32
 */
@Slf4j
@RestController
@RequestMapping("/statistics")
@RequiredArgsConstructor(onConstructor = @__(@Autowired))
public class CompanyOrderReceivedStatiscsAdminController {

      private final CompanyPerformanceBiz companyPerformanceBiz;

      @PostMapping("/company_performance")
      public ObjectRestResponse<PageDataVO<CompanyPerformanceBo>> companyPerformance(@RequestBody CompanyPerformanceFindDTO companyPerformanceFindDTO){
          PageDataVO<CompanyPerformanceBo> dataVO  = companyPerformanceBiz.selectCompanyPerformancePage(companyPerformanceFindDTO);
          return ObjectRestResponse.succ(dataVO);
      }

      @ApiOperation("导出")
      @PostMapping("/export")
      public void exportCompanyPerformance(@RequestBody CompanyPerformanceFindDTO companyPerformanceFindDTO, HttpServletResponse response){

          try {
              String name = DateTimeFormatter.ofPattern("YYYYMMddHHmmss").format(LocalDateTime.now());
              response.setContentType("application/vnd.ms-excel;charset=utf-8");
              String filename = String.format("%s-company-statistics.xlsx",name);
              response.setHeader("Content-Disposition","attachment;filename="+ new String(filename.getBytes(), "iso8859-1"));
              ServletOutputStream outputStream = response.getOutputStream();
              companyPerformanceBiz.exportOrderReceivedStatisticsData(companyPerformanceFindDTO,outputStream);
              response.setCharacterEncoding("UTF-8");
          }catch (Exception ex){
              log.error("导出数据失败【{}】",ex);
              throw  new BaseException("导出数据失败");
          }
      }
}
