package com.xxfc.platform.order.pojo.order;

import com.xxfc.platform.activity.entity.Coupon;
import com.xxfc.platform.order.entity.DepositRefundRecord;
import com.xxfc.platform.order.entity.OrderVehicleCrosstown;
import com.xxfc.platform.order.pojo.DedDetailDTO;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

@Data
public class OrderVehicleCrosstownDto extends OrderVehicleCrosstown {
    String userLicenses;
    /**
     * 驾驶人
     */
    private String licenseName;

    /**
     * 驾驶人手机号
     */
    private String licensePhone;

    /**
     * 驾驶证照
     */
    private String licenseImg;

    /**
     * 驾驶人身份证号
     */
    private String licenseIdCard;
    /**
     * 客服电话
     */
    private String customerPhone;

    private String vehicleNumberPlat;

    /**
     * 操作人昵称
     */
    private String username;

    List<DepositRefundRecord> depositRefundRecord;

    /**
     * 操作人
     */
    private String operatorName;

    /**
     * 操作人手机
     */
    private String operatorPhone;

    /**
     * 操作时间
     */
    private Long operatorTime;

    /**
     * 退还优惠卷
     */
    private List<Coupon> backCoupons;


    private List<DedDetailDTO> dedDetailDTOList;

    private List<DedDetailDTO> violateDetailList;


    private String types;

    private List<String> typeList;

    private Integer address;

    private Integer showType;

    /**
     * 实际退还的部分押金
     */
    private String actualDeposit;

    /**
     * 实际退还剩余押金
     */
    private BigDecimal refundOfRemainingDeposit;

    /**
     * 违章扣款
     */
    private BigDecimal violationOfCharges;

}