package com.xxfc.platform.order.pojo.dto;

import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.github.wxiaoqi.security.common.enumconstant.LevelEnum;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.util.StringUtils;

import java.math.BigDecimal;

/**
 * @author libin
 * @version 1.0
 * @description
 * @data 2019/11/13 15:58
 */
@Data
@Builder(toBuilder = true)
@AllArgsConstructor
@NoArgsConstructor
public class OrderDTO {
    protected Integer  id;
    protected Integer type;
    protected Integer status;
    protected BigDecimal orderAmount;
    protected BigDecimal realAmount;
    protected Integer orderOrigin;
    protected Integer payWay;
    protected Integer companyId;
    protected String stateGroup;
    protected Integer hasPay;
    private JSONObject data;
    private Integer damageSafe;
    private BigDecimal deposit;
    private Integer userId;
    private Integer postionId;

    /**
     * 费用其他明细 租车使用
     */
    protected String costDetail;
    /**
     * 会员相关
     */
    protected Integer memberLevel;

    protected LevelEnum levelEnum;


    public LevelEnum getLevelEnum(){
        return LevelEnum.getLevelEnumByLevel(this.memberLevel);
    }

    public JSONObject getData() {
       return StringUtils.hasText(costDetail)?JSONUtil.parseObj(costDetail):new JSONObject();
    }
}
