package com.xxfc.platform.im.rest;

import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.xxfc.platform.im.biz.MsgBiz;
import com.xxfc.platform.im.dto.MsgQueryDto;
import com.xxfc.platform.im.model.AddMsgParam;
import com.xxfc.platform.im.model.Msg;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

@RestController
@RequestMapping("msg")
public class MsgController {

    @Autowired
    private MsgBiz msgBiz;

    @PostMapping(value = "/app/unauth/list")
    public ObjectRestResponse getMsgList(Integer page, Integer limit, Integer type)throws Exception{
        return msgBiz.getMsgList(page, limit, type);
    }

    @PostMapping(value = "/app/unauth/hotMsg/list")
    public ObjectRestResponse getHotMsgList(Integer page, Integer limit) {
        return msgBiz.getHotMsgList(page, limit);
    }


    @GetMapping(value = "/get")
    public ObjectRestResponse get(String id) {
        return msgBiz.get(id);
    }

    @GetMapping(value = "/getByUserId")
    public ObjectRestResponse getByUserId(Integer page, Integer limit, Integer type) {
        return msgBiz.getMsgListByUserId(page, limit, type);
    }

    @GetMapping(value = "/delete")
    public ObjectRestResponse deleteByIds(String ids) {
        return msgBiz.deleteByList(ids);
    }

    @GetMapping(value = "/bg/app/unauth/delete")
    public ObjectRestResponse deleteById(String id) {
        return msgBiz.deleteById(id);
    }

    @PostMapping(value = "/bg/app/unauth/addMsg")
    public ObjectRestResponse addMsg(@RequestBody AddMsgParam param) {
        return ObjectRestResponse.succ(msgBiz.add(param));
    }

    @PostMapping(value = "/bg/app/unauth/update")
    public ObjectRestResponse updateMsg(@RequestBody Msg msg) {
        return msgBiz.update(msg);
    }

    @PostMapping(value = "/bg/app/unauth/list")
    public ObjectRestResponse getMsgList(@RequestBody MsgQueryDto msgQueryDto) {
        return msgBiz.getMsgList(msgQueryDto);
    }

    @GetMapping(value = "/app/unauth/getHostMsgList")
    public ObjectRestResponse getHostMsgList(String messageId, Integer number) {
        return msgBiz.getHotMsgListWithoutOne(messageId, number);
    }

    @GetMapping(value = "/app/unauth/get")
    public ObjectRestResponse getDetail(String id) {
        return msgBiz.get(id);
    }

}
