package com.xxfc.platform.activity.rest.admin;

import com.github.wxiaoqi.security.common.annotation.BeanValid;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.xxfc.platform.activity.biz.ActivityPrizeBiz;
import com.xxfc.platform.activity.entity.ActivityPrize;
import com.xxfc.platform.activity.vo.ActivityPrizeVo;
import lombok.RequiredArgsConstructor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @author libin
 * @version 1.0
 * @description
 * @data 2019/12/3 19:44
 */
@RestController
@RequestMapping("/admin/activityPrize")
@RequiredArgsConstructor(onConstructor = @__(@Autowired))
public class ActivityPrizeAdminController {

    private final ActivityPrizeBiz activityPrizeBiz;

    @PostMapping("/save")
    public ObjectRestResponse<Void> savePrize(@BeanValid @RequestBody List<ActivityPrize> activityPrizes) {
        activityPrizeBiz.saveActivityPrizes(activityPrizes);
        return ObjectRestResponse.succ();
    }

    @GetMapping("/list")
    public ObjectRestResponse<ActivityPrizeVo> listActivityPrize(){
        ActivityPrizeVo activityPrizeVo = activityPrizeBiz.selectActivitys();
        return ObjectRestResponse.succ(activityPrizeVo);
    }
}