package com.xxfc.platform.activity.vo;

import com.xxfc.platform.activity.entity.ActivityPrize;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.apache.commons.collections4.CollectionUtils;

import java.util.Collections;
import java.util.List;

/**
 * @author libin
 * @version 1.0
 * @description
 * @data 2019/12/3 17:27
 */
@Data
@Builder(toBuilder = true)
@AllArgsConstructor
@NoArgsConstructor
public class ActivityPrizeVo {
    private List<ActivityPrize> onlinePrize;
    private List<ActivityPrize> localePrize;

    public List<ActivityPrize> getOnlinePrize() {
        return CollectionUtils.isEmpty(onlinePrize)? Collections.EMPTY_LIST:onlinePrize;
    }

    public List<ActivityPrize> getLocalePrize() {
        return CollectionUtils.isEmpty(localePrize)? Collections.EMPTY_LIST:localePrize;
    }
}
