package com.xxfc.platform.activity.entity;

import java.io.Serializable;
import java.math.BigInteger;
import javax.persistence.*;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;


/**
 * 精彩活动
 *
 * @author Administrator
 */
@Data
@Table(name = "home_activities")
public class HomeActivities implements Serializable {
    private static final long serialVersionUID = 1L;

    /**
     * 主键
     */
    @Id
    @GeneratedValue(generator = "JDBC")
    @ApiModelProperty("主键")
    private Integer id;

    /**
     * 创建时间
     */
    @Column(name = "crt_time")
    @ApiModelProperty(value = "创建时间", hidden = true)
    private BigInteger crtTime;

    /**
     * 更新时间
     */
    @Column(name = "upd_time")
    @ApiModelProperty(value = "更新时间", hidden = true)
    private BigInteger updTime;

    /**
     * 活动名称
     */
    @Column(name = "name")
    @ApiModelProperty(value = "精彩活动名称")
    private String name;

    /**
     * 精彩活动开始时间
     */
    @Column(name = "start_time")
    @ApiModelProperty(value = "活动开始时间")
    private BigInteger startTime;

    /**
     * 精彩活动结束时间
     */
    @Column(name = "end_time")
    @ApiModelProperty(value = "活动结束时间")
    private BigInteger endTime;


    /**
     * 当前状态 1--显示在活动页 2--隐藏
     */
    @Column(name = "status")
    @ApiModelProperty(value = "当前状态 1--显示在活动页 2--隐藏")
    private Integer status;

    /**
     * 排序
     */
    @Column(name = "sort")
    @ApiModelProperty(value = "排序")
    private Integer sort;

    /**
     * 活动图片
     */
    @Column(name = "picture")
    @ApiModelProperty(value = "活动图片")
    private String picture;


    /**
     * 活动页面链接
     */
    @Column(name = "url")
    @ApiModelProperty(value = "安卓链接")
    private String url;


    /**
     * 活动页面链接
     */
    @Column(name = "ios_url")
    @ApiModelProperty(value = "苹果链接")
    private String iosUrl;

    /**
     * 活动页面链接
     */
    @Column(name = "p_url")
    @ApiModelProperty(value = "小程序链接")
    private String purl;

    /**
     * 是否删除:0-否,1-是
     */
    @Column(name = "is_del")
    @ApiModelProperty(value = "是否删除")
    private Integer isDel;

    /**
     * 有效期限:0-永久 ,1-有期限
     */
    @Column(name = "time_type")
    private Integer timeType;
}
